/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.alternator;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class InternalEnergyStorage
extends EnergyStorage {
    public InternalEnergyStorage(int capacity) {
        super(capacity, capacity, capacity, 0);
    }

    public InternalEnergyStorage(int capacity, int maxTransfer) {
        super(capacity, maxTransfer, maxTransfer, 0);
    }

    public InternalEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract, 0);
    }

    public InternalEnergyStorage(int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
    }

    public CompoundTag write(CompoundTag nbt) {
        nbt.m_128405_("energy", this.energy);
        return nbt;
    }

    public void read(CompoundTag nbt) {
        this.setEnergy(nbt.m_128451_("energy"));
    }

    public CompoundTag write(CompoundTag nbt, String name) {
        nbt.m_128405_("energy_" + name, this.energy);
        return nbt;
    }

    public void read(CompoundTag nbt, String name) {
        this.setEnergy(nbt.m_128451_("energy_" + name));
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public int internalConsumeEnergy(int consume) {
        int oenergy = this.energy;
        this.energy = Math.max(0, this.energy - consume);
        return oenergy - this.energy;
    }

    public int internalProduceEnergy(int produce) {
        int oenergy = this.energy;
        this.energy = Math.min(this.capacity, this.energy + produce);
        return oenergy - this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    @Deprecated
    public void outputToSide(Level world, BlockPos pos, Direction side, int max) {
        BlockEntity te = world.m_7702_(pos.m_142300_(side));
        if (te == null) {
            return;
        }
        LazyOptional opt = te.getCapability(CapabilityEnergy.ENERGY, side.m_122424_());
        IEnergyStorage ies = (IEnergyStorage)opt.orElse(null);
        if (ies == null) {
            return;
        }
        int ext = this.extractEnergy(max, false);
        this.receiveEnergy(ext - ies.receiveEnergy(ext, false), false);
    }

    public String toString() {
        return this.getEnergyStored() + "/" + this.getMaxEnergyStored();
    }
}

