/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.client.render;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelBlock;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelTileEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.teammoeg.steampowered.block.SPBlockPartials;
import com.teammoeg.steampowered.mixin.FlywheelTileEntityAccess;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class SteelFlywheelRenderer
extends KineticTileEntityRenderer {
    public SteelFlywheelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(KineticTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        if (!Backend.canUseInstancing((Level)te.m_58904_())) {
            BlockState blockState = te.m_58900_();
            FlywheelTileEntity wte = (FlywheelTileEntity)te;
            FlywheelTileEntityAccess access = (FlywheelTileEntityAccess)wte;
            float speed = access.getVisualSpeed().get(partialTicks) * 3.0f / 10.0f;
            float angle = access.getAngle() + speed * partialTicks;
            VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
            if (FlywheelBlock.isConnected((BlockState)blockState)) {
                Direction connection = FlywheelBlock.getConnection((BlockState)blockState);
                light = LevelRenderer.m_109537_((BlockAndTintGetter)te.m_58904_(), (BlockState)blockState, (BlockPos)te.m_58899_().m_142300_(connection));
                float rotation = connection.m_122434_() == Direction.Axis.X ^ connection.m_122421_() == Direction.AxisDirection.NEGATIVE ? -angle : angle;
                boolean flip = blockState.m_61143_((Property)FlywheelBlock.CONNECTION) == FlywheelBlock.ConnectionState.LEFT;
                this.transformConnector(this.rotateToFacing(CachedBufferer.partial((PartialModel)SPBlockPartials.STEEL_FLYWHEEL_UPPER_ROTATING, (BlockState)blockState), connection), true, true, rotation, flip).light(light).renderInto(ms, vb);
                this.transformConnector(this.rotateToFacing(CachedBufferer.partial((PartialModel)SPBlockPartials.STEEL_FLYWHEEL_LOWER_ROTATING, (BlockState)blockState), connection), false, true, rotation, flip).light(light).renderInto(ms, vb);
                this.transformConnector(this.rotateToFacing(CachedBufferer.partial((PartialModel)SPBlockPartials.STEEL_FLYWHEEL_UPPER_SLIDING, (BlockState)blockState), connection), true, false, rotation, flip).light(light).renderInto(ms, vb);
                this.transformConnector(this.rotateToFacing(CachedBufferer.partial((PartialModel)SPBlockPartials.STEEL_FLYWHEEL_LOWER_SLIDING, (BlockState)blockState), connection), false, false, rotation, flip).light(light).renderInto(ms, vb);
            }
            this.renderFlywheel(te, ms, light, blockState, angle, vb);
        }
    }

    private void renderFlywheel(KineticTileEntity te, PoseStack ms, int light, BlockState blockState, float angle, VertexConsumer vb) {
        BlockState referenceState = blockState.m_60717_(Rotation.CLOCKWISE_90);
        Direction facing = (Direction)referenceState.m_61143_((Property)BlockStateProperties.f_61374_);
        SuperByteBuffer wheel = CachedBufferer.partialFacing((PartialModel)SPBlockPartials.STEEL_FLYWHEEL, (BlockState)referenceState, (Direction)facing);
        SteelFlywheelRenderer.kineticRotationTransform((SuperByteBuffer)wheel, (KineticTileEntity)te, (Direction.Axis)((Direction)blockState.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_122434_(), (float)AngleHelper.rad((double)angle), (int)light);
        wheel.renderInto(ms, vb);
    }

    protected SuperByteBuffer getRotatedModel(KineticTileEntity te) {
        return CachedBufferer.partialFacing((PartialModel)AllBlockPartials.SHAFT_HALF, (BlockState)te.m_58900_(), (Direction)((Direction)te.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_());
    }

    protected SuperByteBuffer transformConnector(SuperByteBuffer buffer, boolean upper, boolean rotating, float angle, boolean flip) {
        float shift = upper ? 0.25f : -0.125f;
        float offset = upper ? 0.25f : 0.25f;
        float radians = (float)((double)(angle / 180.0f) * Math.PI);
        float shifting = Mth.m_14031_((float)radians) * shift + offset;
        float maxAngle = upper ? -5.0f : -15.0f;
        float minAngle = upper ? -45.0f : 5.0f;
        float barAngle = 0.0f;
        if (rotating) {
            barAngle = Mth.m_14179_((float)((Mth.m_14031_((float)((float)((double)radians + 1.5707963267948966))) + 1.0f) / 2.0f), (float)minAngle, (float)maxAngle);
        }
        float pivotX = (upper ? 8.0f : 3.0f) / 16.0f;
        float pivotY = (upper ? 8.0f : 2.0f) / 16.0f;
        float pivotZ = (upper ? 23.0f : 21.5f) / 16.0f;
        buffer.translate((double)pivotX, (double)pivotY, (double)(pivotZ + shifting));
        if (rotating) {
            buffer.rotate(Direction.EAST, AngleHelper.rad((double)barAngle));
        }
        buffer.translate((double)(-pivotX), (double)(-pivotY), (double)(-pivotZ));
        if (flip && !upper) {
            buffer.translate(0.5625, 0.0, 0.0);
        }
        return buffer;
    }

    protected SuperByteBuffer rotateToFacing(SuperByteBuffer buffer, Direction facing) {
        buffer.rotateCentered(Direction.UP, AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing)));
        return buffer;
    }
}

