/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.client.instance;

import com.google.common.collect.Lists;
import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileInstance;
import com.simibubi.create.content.contraptions.base.flwdata.RotatingData;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelBlock;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelTileEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.teammoeg.steampowered.block.SPBlockPartials;
import com.teammoeg.steampowered.mixin.FlywheelTileEntityAccess;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BronzeFlywheelInstance
extends KineticTileInstance<FlywheelTileEntity>
implements DynamicInstance {
    protected final Direction facing;
    protected final Direction connection;
    protected boolean connectedLeft;
    protected float connectorAngleMult;
    protected final RotatingData shaft;
    protected final ModelData wheel;
    protected List<ModelData> connectors;
    protected ModelData upperRotating;
    protected ModelData lowerRotating;
    protected ModelData upperSliding;
    protected ModelData lowerSliding;
    protected float lastAngle = Float.NaN;

    public BronzeFlywheelInstance(MaterialManager modelManager, FlywheelTileEntity tile) {
        super(modelManager, (KineticTileEntity)tile);
        this.facing = (Direction)this.blockState.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
        this.shaft = this.setup((RotatingData)this.shaftModel().createInstance());
        BlockState referenceState = this.blockState.m_60717_(Rotation.CLOCKWISE_90);
        this.wheel = (ModelData)this.getTransformMaterial().getModel(SPBlockPartials.BRONZE_FLYWHEEL, referenceState, (Direction)referenceState.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).createInstance();
        this.connection = FlywheelBlock.getConnection((BlockState)this.blockState);
        if (this.connection != null) {
            this.connectedLeft = this.blockState.m_61143_((Property)FlywheelBlock.CONNECTION) == FlywheelBlock.ConnectionState.LEFT;
            boolean flipAngle = this.connection.m_122434_() == Direction.Axis.X ^ this.connection.m_122421_() == Direction.AxisDirection.NEGATIVE;
            this.connectorAngleMult = flipAngle ? -1.0f : 1.0f;
            Material mat = this.getTransformMaterial();
            this.upperRotating = (ModelData)mat.getModel(SPBlockPartials.BRONZE_FLYWHEEL_UPPER_ROTATING, this.blockState).createInstance();
            this.lowerRotating = (ModelData)mat.getModel(SPBlockPartials.BRONZE_FLYWHEEL_LOWER_ROTATING, this.blockState).createInstance();
            this.upperSliding = (ModelData)mat.getModel(SPBlockPartials.BRONZE_FLYWHEEL_UPPER_SLIDING, this.blockState).createInstance();
            this.lowerSliding = (ModelData)mat.getModel(SPBlockPartials.BRONZE_FLYWHEEL_LOWER_SLIDING, this.blockState).createInstance();
            this.connectors = Lists.newArrayList((Object[])new ModelData[]{this.upperRotating, this.lowerRotating, this.upperSliding, this.lowerSliding});
        } else {
            this.connectors = Collections.emptyList();
        }
        FlywheelTileEntityAccess access = (FlywheelTileEntityAccess)tile;
        this.animate(access.getAngle());
    }

    public void beginFrame() {
        float partialTicks = AnimationTickHolder.getPartialTicks();
        FlywheelTileEntityAccess access = (FlywheelTileEntityAccess)this.blockEntity;
        float speed = access.getVisualSpeed().get(partialTicks) * 3.0f / 10.0f;
        float angle = access.getAngle() + speed * partialTicks;
        if ((double)Math.abs(angle - this.lastAngle) < 0.001) {
            return;
        }
        this.animate(angle);
        this.lastAngle = angle;
    }

    private void animate(float angle) {
        PoseStack ms = new PoseStack();
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        msr.translate((Vec3i)this.getInstancePosition());
        if (this.connection != null) {
            float rotation = angle * this.connectorAngleMult;
            ms.m_85836_();
            this.rotateToFacing(msr, this.connection);
            ms.m_85836_();
            this.transformConnector(msr, true, true, rotation, this.connectedLeft);
            this.upperRotating.setTransform(ms);
            ms.m_85849_();
            ms.m_85836_();
            this.transformConnector(msr, false, true, rotation, this.connectedLeft);
            this.lowerRotating.setTransform(ms);
            ms.m_85849_();
            ms.m_85836_();
            this.transformConnector(msr, true, false, rotation, this.connectedLeft);
            this.upperSliding.setTransform(ms);
            ms.m_85849_();
            ms.m_85836_();
            this.transformConnector(msr, false, false, rotation, this.connectedLeft);
            this.lowerSliding.setTransform(ms);
            ms.m_85849_();
            ms.m_85849_();
        }
        ((TransformStack)((TransformStack)msr.centre()).rotate(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.facing.m_122434_()), AngleHelper.rad((double)angle))).unCentre();
        this.wheel.setTransform(ms);
    }

    public void update() {
        this.updateRotation(this.shaft);
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.shaft, this.wheel});
        if (this.connection != null) {
            this.relight(this.pos.m_142300_(this.connection), this.connectors.stream());
        }
    }

    public void remove() {
        this.shaft.delete();
        this.wheel.delete();
        this.connectors.forEach(InstanceData::delete);
        this.connectors.clear();
    }

    protected Instancer<RotatingData> shaftModel() {
        Direction opposite = this.facing.m_122424_();
        return this.getRotatingMaterial().getModel(AllBlockPartials.SHAFT_HALF, this.blockState, opposite);
    }

    protected void transformConnector(TransformStack ms, boolean upper, boolean rotating, float angle, boolean flip) {
        float shift = upper ? 0.25f : -0.125f;
        float offset = upper ? 0.25f : 0.25f;
        float radians = (float)((double)(angle / 180.0f) * Math.PI);
        float shifting = Mth.m_14031_((float)radians) * shift + offset;
        float maxAngle = upper ? -5.0f : -15.0f;
        float minAngle = upper ? -45.0f : 5.0f;
        float barAngle = 0.0f;
        if (rotating) {
            barAngle = Mth.m_14179_((float)((Mth.m_14031_((float)((float)((double)radians + 1.5707963267948966))) + 1.0f) / 2.0f), (float)minAngle, (float)maxAngle);
        }
        float pivotX = (upper ? 8.0f : 3.0f) / 16.0f;
        float pivotY = (upper ? 8.0f : 2.0f) / 16.0f;
        float pivotZ = (upper ? 23.0f : 21.5f) / 16.0f;
        ms.translate((double)pivotX, (double)pivotY, (double)(pivotZ + shifting));
        if (rotating) {
            ms.rotate(Direction.EAST, AngleHelper.rad((double)barAngle));
        }
        ms.translate((double)(-pivotX), (double)(-pivotY), (double)(-pivotZ));
        if (flip && !upper) {
            ms.translate(0.5625, 0.0, 0.0);
        }
    }

    protected void rotateToFacing(TransformStack buffer, Direction facing) {
        ((TransformStack)((TransformStack)buffer.centre()).rotate(Direction.UP, AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing)))).unCentre();
    }
}

