/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.structures;

import com.legacy.structure_gel.api.structure.GelStructure;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public abstract class BlindingDungeonStructure
extends GelStructure<NoneFeatureConfiguration> {
    public BlindingDungeonStructure(Codec<NoneFeatureConfiguration> configFactoryIn, Predicate<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>> placementCheck, PieceGenerator<NoneFeatureConfiguration> generator) {
        super(configFactoryIn, PieceGeneratorSupplier.m_197349_(context -> context.m_197380_(Heightmap.Types.WORLD_SURFACE_WG) && BlindingDungeonStructure.isValidHeight((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context) && placementCheck.test((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context), generator));
        this.spawns.put(MobCategory.MONSTER, List.of());
    }

    protected static boolean isValidHeight(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context) {
        ChunkPos chunkPos = context.f_197355_();
        return BlindingDungeonStructure.getHeighestY(context.f_197357_(), context.f_197352_(), chunkPos.f_45578_, chunkPos.f_45579_) >= 60;
    }

    protected static int getHeighestY(LevelHeightAccessor level, ChunkGenerator chunkGen, int chunkX, int chunkZ) {
        int width = 18;
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        int y = 0;
        for (int dx = 0; dx < 2; ++dx) {
            for (int dz = 0; dz < 2; ++dz) {
                int h = chunkGen.m_142647_(dx * width + x, dz * width + z, Heightmap.Types.WORLD_SURFACE_WG, level);
                if (y > 0 && (h > y + 9 || h < y - 9)) {
                    return 0;
                }
                y = Math.max(y, h);
            }
        }
        return y;
    }
}

