/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.structures.poison_dungeon;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.world.everdawn.gen.structures.poison_dungeon.PoisonDungeonPieces;
import com.legacy.structure_gel.api.structure.GelStructure;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class PoisonDungeonStructure
extends GelStructure<NoneFeatureConfiguration> {
    private static final List<MobSpawnSettings.SpawnerData> DUNGEON_ENEMIES = Lists.newArrayList((Object[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.f_20554_, 1, 1, 1), new MobSpawnSettings.SpawnerData(SkiesEntityTypes.VENOM_SPIDER, 3, 1, 1)});

    public PoisonDungeonStructure(Codec<NoneFeatureConfiguration> config) {
        super(config, PoisonDungeonStructure::generatePieces);
        this.spawns.put(MobCategory.MONSTER, DUNGEON_ENEMIES);
    }

    public int getSpacing() {
        return 63;
    }

    public int getOffset() {
        return this.getSpacing() - 30;
    }

    public float getProbability() {
        return 0.8f;
    }

    public Set<ResourceLocation> getValidDimensions() {
        return ImmutableSet.of((Object)SkiesDimensions.EVERDAWN_ID);
    }

    private static void generatePieces(StructurePiecesBuilder builder, PieceGenerator.Context<NoneFeatureConfiguration> context) {
        ChunkGenerator chunkGen = context.f_192703_();
        ChunkPos chunkPos = context.f_192705_();
        Rotation rotation = Rotation.m_55956_((Random)context.f_192708_());
        int i = PoisonDungeonStructure.getYValue(context.f_192707_(), chunkGen, chunkPos);
        if (i >= 60 || chunkGen instanceof FlatLevelSource) {
            BlockPos blockpos = new BlockPos(chunkPos.f_45578_ * 16 + 8, i, chunkPos.f_45579_ * 16 + 8);
            PoisonDungeonPieces.assemble(context.f_192704_(), blockpos, rotation, builder, (Random)context.f_192708_());
        }
    }

    public static int getYValue(LevelHeightAccessor level, ChunkGenerator chunkGen, ChunkPos chunkPos) {
        Random random = new Random(chunkPos.f_45578_ + chunkPos.f_45579_ * 10387313);
        Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        int i = 5;
        int j = 5;
        if (rotation == Rotation.CLOCKWISE_90) {
            i = -5;
        } else if (rotation == Rotation.CLOCKWISE_180) {
            i = -5;
            j = -5;
        } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
            j = -5;
        }
        int k = (chunkPos.f_45578_ << 4) + 7;
        int l = (chunkPos.f_45579_ << 4) + 7;
        int i1 = chunkGen.m_156179_(k, l, Heightmap.Types.WORLD_SURFACE_WG, level);
        int j1 = chunkGen.m_156179_(k, l + j, Heightmap.Types.WORLD_SURFACE_WG, level);
        int k1 = chunkGen.m_156179_(k + i, l, Heightmap.Types.WORLD_SURFACE_WG, level);
        int l1 = chunkGen.m_156179_(k + i, l + j, Heightmap.Types.WORLD_SURFACE_WG, level);
        return Math.min(Math.min(i1, j1), Math.min(k1, l1));
    }
}

