/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon.NatureDungeonPieces;
import com.legacy.structure_gel.api.structure.GelStructure;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class NatureDungeonStructure
extends GelStructure<NoneFeatureConfiguration> {
    private static final List<MobSpawnSettings.SpawnerData> DUNGEON_ENEMIES = Lists.newArrayList((Object[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(SkiesEntityTypes.STONELET, 2, 1, 1), new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SPEWTER, 2, 1, 1)});

    public NatureDungeonStructure(Codec<NoneFeatureConfiguration> config) {
        super(config, NatureDungeonStructure::generatePieces);
        this.spawns.put(MobCategory.MONSTER, DUNGEON_ENEMIES);
    }

    public int getSpacing() {
        return 63;
    }

    public int getOffset() {
        return this.getSpacing() - 30;
    }

    public float getProbability() {
        return 0.8f;
    }

    public Set<ResourceLocation> getValidDimensions() {
        return Set.of(SkiesDimensions.EVERBRIGHT_ID);
    }

    public static void generatePieces(StructurePiecesBuilder builder, PieceGenerator.Context<NoneFeatureConfiguration> context) {
        ChunkPos chunkPos = context.f_192705_();
        WorldgenRandom random = context.f_192708_();
        NatureDungeonPieces.assemble(context.f_192704_(), new BlockPos(chunkPos.f_45578_ * 16 + 8, 88, chunkPos.f_45579_ * 16 + 8), Rotation.m_55956_((Random)random), builder, (Random)random, context.f_192703_(), context.f_192707_());
    }
}

