/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.util.DirectionUtil;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class StarlitTreeFeature
extends AbstractSkyTreeFeature {
    private static final BlockState LOG = SkiesBlocks.starlit_log.m_49966_();
    private static final BlockState LEAF = SkiesBlocks.starlit_leaves.m_49966_();

    public StarlitTreeFeature(Codec<TreeConfiguration> config) {
        super(config, true);
    }

    @Override
    public boolean place(WorldGenLevel world, Random rand, BlockPos pos, BiConsumer<BlockPos, BlockState> changedLogs, BiConsumer<BlockPos, BlockState> changedLeaves) {
        int y;
        int height = rand.nextInt(3) + 7;
        if (!this.isAreaOk(world, pos, height, 1, 2, 0)) {
            return false;
        }
        for (y = 0; y < height; ++y) {
            this.setBlockIfOk(changedLogs, world, pos.m_6630_(y), LOG);
        }
        this.setBlockIfOk(changedLeaves, world, pos.m_6630_(height), LEAF);
        this.setBlockIfOk(changedLeaves, world, pos.m_6630_(height + 1), LEAF);
        this.setBlockIfOk(changedLeaves, world, pos.m_6630_(height + 2), LEAF);
        for (y = height - 5; y <= height; ++y) {
            int z;
            for (Direction dir : DirectionUtil.HORIZONTAL) {
                this.setBlockIfOk(changedLeaves, world, pos.m_142300_(dir).m_6630_(y), LEAF);
            }
            if (y == height - 4 || y == height - 2) {
                int x = -2;
                z = 0;
                while (x <= 0) {
                    this.setBlockIfOk(changedLeaves, world, pos.m_142082_(x, y, z), LEAF);
                    this.setBlockIfOk(changedLeaves, world, pos.m_142082_(x + 1, y, z - 1), LEAF);
                    this.setBlockIfOk(changedLeaves, world, pos.m_142082_(x + 2, y, z - 2), LEAF);
                    ++x;
                    ++z;
                }
            }
            if (y != height - 3 && y != height - 1) continue;
            int x = 1;
            z = 1;
            for (int j = 0; j <= 1; ++j) {
                for (int k = 0; k <= 1; ++k) {
                    if (rand.nextBoolean()) {
                        this.setBlockIfOk(changedLeaves, world, pos.m_142082_(x, y, z), LEAF);
                    }
                    z = Math.negateExact(z);
                }
                x = Math.negateExact(x);
            }
        }
        return true;
    }
}

