/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.biome_provider.pixel_functions;

import com.legacy.blue_skies.util.LogicUtil;
import com.legacy.blue_skies.world.biome_provider.biomes.BiomeData;
import com.legacy.blue_skies.world.biome_provider.biomes.BiomeIds;
import com.legacy.blue_skies.world.biome_provider.pixel_functions.api.height.HeightForBiomeFunction;
import com.legacy.blue_skies.world.biome_provider.pixel_functions.api.height.HeightPixelFunction;
import com.legacy.blue_skies.world.biome_provider.region.HeightRegion;
import java.util.Random;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public class HeightFuncs {
    public static final HeightForBiomeFunction BASE_NOISE = HeightFuncs::applyBaseNoise;
    public static final HeightForBiomeFunction ADDITIONAL_NOISE = HeightFuncs::additionalNoise;
    public static final HeightPixelFunction LARGE_AVERAGE = HeightFuncs::largeAverage;
    public static final HeightPixelFunction SMALL_AVERAGE = HeightFuncs::smallAverage;
    private static final double MAIN_SCALE_A = 0.003;
    private static final double MAIN_SCALE_B = 0.03;
    private static final double VALLEY_SCALE = 0.006;
    private static final double UNORTHODOX_SCALE_A = 0.004;
    private static final double UNORTHODOX_SCALE_B = 0.02;
    private static final double UNORTHODOX_VALLEY_SCALE = 0.007;

    private static int largeAverage(HeightRegion region, int x, int z, Random rand) {
        int total = 0;
        int count = 0;
        int range = 7;
        int internalRange = 6;
        for (int dx = -6; dx <= 6; ++dx) {
            for (int dz = -6; dz <= 6; ++dz) {
                total += region.get(x + dx, z + dz);
                ++count;
            }
        }
        for (int d = -2; d <= 2; ++d) {
            total += region.get(x + d, z + 7);
            total += region.get(x + d, z - 7);
            total += region.get(x + 7, z + d);
            total += region.get(x - 7, z + d);
            count += 4;
        }
        int outerPieces = 8;
        total += region.get(x, z + 8);
        total += region.get(x, z - 8);
        total += region.get(x + 8, z);
        return (total += region.get(x - 8, z)) / (count += 4);
    }

    private static int smallAverage(HeightRegion region, int x, int z, Random rand) {
        int total = region.get(x, z);
        total += region.get(x + 1, z + 1);
        total += region.get(x + 1, z - 1);
        total += region.get(x - 1, z + 1);
        return (total += region.get(x - 1, z - 1)) / 5;
    }

    private static int applyBaseNoise(HeightRegion region, int height, int biome, int globalX, int globalZ) {
        BiomeData data = BiomeIds.getData(biome);
        return data.mainHeightFunc().transformPixel(region, height, data, globalX, globalZ);
    }

    public static int mainHeightFunc(HeightRegion region, int height, BiomeData data, int globalX, int globalZ) {
        int valley;
        int variance = data.variance();
        if (variance > 0) {
            double[] noises = HeightFuncs.getDualNoise(region, globalX, globalZ, region.biomeProvider.noiseA, 0.003, region.biomeProvider.noiseB, 0.03);
            double mergedNoise = noises[0] * 0.93 + noises[1] * 0.07;
            height += (int)(mergedNoise * (double)variance);
        }
        if ((valley = data.valleyDepth()) > 0) {
            double val = Math.abs(region.biomeProvider.noiseC.m_75449_((double)globalX * 0.006, (double)globalZ * 0.006, false)) * 2.0 - 1.0;
            height = (int)((double)height + val * (double)valley);
        }
        return height;
    }

    public static int unorthodoxHeightFunc(HeightRegion region, int height, BiomeData data, int globalX, int globalZ) {
        double[] noises = HeightFuncs.getDualNoise(region, globalX, globalZ, region.biomeProvider.noiseA, 0.004, region.biomeProvider.noiseB, 0.02);
        double mergedNoise = 1.0 - Math.abs(noises[0] * 0.93 + noises[1] * 0.07);
        mergedNoise = mergedNoise * 2.0 - 1.0;
        mergedNoise = Mth.m_14008_((double)(mergedNoise * 1.3), (double)0.0, (double)1.0);
        double val = Math.abs(region.biomeProvider.noiseC.m_75449_((double)globalX * 0.007, (double)globalZ * 0.007, false)) * 2.0 - 1.0;
        if ((height += (int)(mergedNoise * (double)data.variance())) < data.height() + 15) {
            val *= 0.2;
        }
        height = (int)((double)height + val * (double)data.valleyDepth());
        return height;
    }

    private static int additionalNoise(HeightRegion region, int height, int biome, int globalX, int globalZ) {
        double scale;
        double r;
        int roughness;
        double stepSeparation;
        double maskScale;
        double maskVal;
        double pointScale;
        double pointNoiseVal;
        BiomeData data = BiomeIds.getData(biome);
        int pointiness = data.pointiness();
        if (pointiness > 0 && (pointNoiseVal = 1.0 - Math.abs(region.biomeProvider.noiseB.m_75449_((double)globalX * (pointScale = 0.018), (double)globalZ * pointScale, false)) * 2.0) > 0.0 && (maskVal = region.biomeProvider.noiseA.m_75449_((double)globalX * (maskScale = 0.01), (double)globalZ * maskScale, false)) > 0.0) {
            height = (int)((double)height + pointNoiseVal * maskVal * (double)pointiness);
        }
        if ((stepSeparation = (double)data.stepSeparation()) > 0.0) {
            double stepScale = 0.011;
            double stepNoiseThreshold = data.stepNoiseThreshold();
            double noiseVal = region.biomeProvider.noiseC.m_75449_((double)globalX * stepScale, (double)globalZ * stepScale, false);
            double h = Math.floor((double)height / stepSeparation) * stepSeparation;
            double r2 = Math.floorMod(height, (int)stepSeparation);
            double n = Mth.m_14139_((double)noiseVal, (double)-1.0, (double)1.0) * stepSeparation / 2.0;
            double newHeight = h + n + r2 * (double)data.stepMaxHeight() / stepSeparation;
            if (noiseVal > stepNoiseThreshold) {
                height = (int)newHeight;
            } else if (noiseVal > stepNoiseThreshold - 0.23) {
                double p = LogicUtil.convertToNewRange(noiseVal, stepNoiseThreshold - 0.23, stepNoiseThreshold, 0.0, 1.0);
                height = (int)(newHeight * p + (double)height * (1.0 - p));
            }
        }
        if ((roughness = data.roughness()) > 0 && (r = region.biomeProvider.noiseC.m_75449_((double)globalX * (scale = 0.01), (double)globalZ * scale, false)) * r > 0.65) {
            height = (int)((double)height + (double)roughness * Math.abs(region.biomeProvider.noiseC.m_75449_((double)globalX * (scale *= 0.8), (double)globalZ * scale, true)));
        }
        if (biome == BiomeIds.UNORTHODOX_VALLEY) {
            if (height > 185) {
                height = height / 10 * 10 + (int)((double)(height % 10) * 0.2);
            } else if (height > 155) {
                height = height / 6 * 6;
            }
        }
        return height;
    }

    private static double[] getDualNoise(HeightRegion region, int globalX, int globalZ, PerlinSimplexNoise noiseA, double scaleA, PerlinSimplexNoise noiseB, double scaleB) {
        return new double[]{noiseA.m_75449_((double)globalX * scaleA, (double)globalZ * scaleA, false), noiseB.m_75449_((double)globalX * scaleB, (double)globalZ * scaleB, true)};
    }
}

