/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.google.common.collect.ImmutableList;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesStructureProcessors;
import com.legacy.blue_skies.world.everbright.gen.structures.blinding_dungeon.EverbrightBlindingDungeonPieces;
import com.legacy.blue_skies.world.everbright.gen.structures.blinding_dungeon.EverbrightBlindingDungeonStructure;
import com.legacy.blue_skies.world.everbright.gen.structures.bunker.FrozenBunkerPools;
import com.legacy.blue_skies.world.everbright.gen.structures.bunker.FrozenBunkerStructure;
import com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon.NatureDungeonPieces;
import com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon.NatureDungeonStructure;
import com.legacy.blue_skies.world.everdawn.gen.structures.blinding_dungeon.EverdawnBlindingDungeonPieces;
import com.legacy.blue_skies.world.everdawn.gen.structures.blinding_dungeon.EverdawnBlindingDungeonStructure;
import com.legacy.blue_skies.world.everdawn.gen.structures.poison_dungeon.PoisonDungeonPieces;
import com.legacy.blue_skies.world.everdawn.gen.structures.poison_dungeon.PoisonDungeonStructure;
import com.legacy.blue_skies.world.general_features.structures.GatekeeperHousePools;
import com.legacy.blue_skies.world.general_features.structures.GatekeeperHouseStructure;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageBiomes;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillagePools;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageStructure;
import com.legacy.blue_skies.world.util.structure_processors.RemoveSnowStructureProcessor;
import com.legacy.structure_gel.api.registry.RegistryHelper;
import com.legacy.structure_gel.api.registry.registrar.GelStructureRegistrar;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import com.legacy.structure_gel.api.structure.GelStructure;
import com.legacy.structure_gel.api.structure.processor.RandomBlockSwapProcessor;
import com.legacy.structure_gel.api.util.GelCollectors;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class SkiesStructures {
    public static final StructureRegistrar<JigsawConfiguration, FrozenBunkerStructure> FROZEN_BUNKER = GelStructureRegistrar.of((ResourceLocation)BlueSkies.locate("frozen_bunker"), (GelStructure)new FrozenBunkerStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_), FrozenBunkerStructure.Piece::new, (FeatureConfiguration)new JigsawConfiguration(() -> FrozenBunkerPools.ROOT, 7), (GenerationStep.Decoration)GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureRegistrar<NoneFeatureConfiguration, EverbrightBlindingDungeonStructure> EVERBRIGHT_BLINDING_DUNGEON = GelStructureRegistrar.of((ResourceLocation)BlueSkies.locate("everbright_blinding_dungeon"), (GelStructure)new EverbrightBlindingDungeonStructure((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_), EverbrightBlindingDungeonPieces.Piece::new, (FeatureConfiguration)NoneFeatureConfiguration.f_67737_, (GenerationStep.Decoration)GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureRegistrar<NoneFeatureConfiguration, EverdawnBlindingDungeonStructure> EVERDAWN_BLINDING_DUNGEON = GelStructureRegistrar.of((ResourceLocation)BlueSkies.locate("everdawn_blinding_dungeon"), (GelStructure)new EverdawnBlindingDungeonStructure((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_), EverdawnBlindingDungeonPieces.Piece::new, (FeatureConfiguration)NoneFeatureConfiguration.f_67737_, (GenerationStep.Decoration)GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureRegistrar<NoneFeatureConfiguration, NatureDungeonStructure> NATURE_DUNGEON = GelStructureRegistrar.of((ResourceLocation)BlueSkies.locate("nature_dungeon"), (GelStructure)new NatureDungeonStructure((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_), (Map)GelCollectors.mapOf((Object)"main", NatureDungeonPieces.Piece::new, (Object[])new Object[]{"garden", NatureDungeonPieces.GardenPiece::new, "stone_fill", NatureDungeonPieces.StoneFillPiece::new, "air_bubble", NatureDungeonPieces.AirBubblePiece::new}), (FeatureConfiguration)NoneFeatureConfiguration.f_67737_, (GenerationStep.Decoration)GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureRegistrar<NoneFeatureConfiguration, PoisonDungeonStructure> POISON_DUNGEON = GelStructureRegistrar.of((ResourceLocation)BlueSkies.locate("poison_dungeon"), (GelStructure)new PoisonDungeonStructure((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_), PoisonDungeonPieces.Piece::new, (FeatureConfiguration)NoneFeatureConfiguration.f_67737_, (GenerationStep.Decoration)GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureRegistrar<JigsawConfiguration, GatekeeperHouseStructure> GATEKEEPER_HOUSE = GelStructureRegistrar.of((ResourceLocation)BlueSkies.locate("gatekeeper_house"), (GelStructure)new GatekeeperHouseStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_), GatekeeperHouseStructure.Piece::new, Map.of("plains", new JigsawConfiguration(() -> GatekeeperHousePools.PLAINS, 7), "snowy", new JigsawConfiguration(() -> GatekeeperHousePools.SNOWY, 7), "mountain", new JigsawConfiguration(() -> GatekeeperHousePools.MOUNTAIN, 7)), (GenerationStep.Decoration)GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureRegistrar<JigsawConfiguration, SkiesVillageStructure> BLUE_SKIES_VILLAGE = GelStructureRegistrar.of((ResourceLocation)BlueSkies.locate("village"), (GelStructure)new SkiesVillageStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_), SkiesVillageStructure.Piece::new, (Map)GelCollectors.mapOf((Object)SkiesVillageBiomes.CALMING_SKIES.toString(), (Object)new JigsawConfiguration(() -> SkiesVillagePools.CALMING_SKIES, 6), (Object[])new Object[]{SkiesVillageBiomes.BRIGHTLANDS.toString(), new JigsawConfiguration(() -> SkiesVillagePools.BRIGHTLANDS, 6), SkiesVillageBiomes.SLUSHLANDS.toString(), new JigsawConfiguration(() -> SkiesVillagePools.SLUSHLANDS, 6), SkiesVillageBiomes.SHADED_WOODLANDS.toString(), new JigsawConfiguration(() -> SkiesVillagePools.SHADED_WOODLANDS, 6), SkiesVillageBiomes.SUNSET_MAPLE_FOREST.toString(), new JigsawConfiguration(() -> SkiesVillagePools.SUNSET_MAPLE_FOREST, 6), SkiesVillageBiomes.CRYSTAL_DUNES.toString(), new JigsawConfiguration(() -> SkiesVillagePools.CRYSTAL_DUNES, 6)}), (GenerationStep.Decoration)GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static StructureFeature<?>[] dungeons = new StructureFeature[0];

    public static void init(RegistryEvent.Register<StructureFeature<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        SkiesStructureProcessors.init();
        Processors.init();
        FrozenBunkerPools.init();
        FROZEN_BUNKER.handleForge(registry);
        EVERBRIGHT_BLINDING_DUNGEON.handleForge(registry);
        EVERDAWN_BLINDING_DUNGEON.handleForge(registry);
        NATURE_DUNGEON.handleForge(registry);
        POISON_DUNGEON.handleForge(registry);
        GatekeeperHousePools.init();
        GATEKEEPER_HOUSE.handleForge(registry);
        SkiesVillagePools.init();
        BLUE_SKIES_VILLAGE.handleForge(registry);
        dungeons = new StructureFeature[]{EVERBRIGHT_BLINDING_DUNGEON.getStructure(), EVERDAWN_BLINDING_DUNGEON.getStructure(), NATURE_DUNGEON.getStructure(), POISON_DUNGEON.getStructure()};
    }

    public static class Processors {
        public static final StructureProcessorList DECAY_TURQUOISE_STONEBRICK = Processors.register("decay_turquoise_stonebrick", new StructureProcessorList((List)ImmutableList.of((Object)new RandomBlockSwapProcessor(SkiesBlocks.turquoise_stonebrick, 0.1f, SkiesBlocks.mossy_turquoise_stonebrick), (Object)new RandomBlockSwapProcessor(SkiesBlocks.turquoise_stonebrick, 0.2f, SkiesBlocks.cracked_turquoise_stonebrick))));
        public static final StructureProcessorList REMOVE_SNOW = Processors.register("remove_snow", RemoveSnowStructureProcessor.INSTANCE);
        public static final StructureProcessorList SWAP_PORTAL = Processors.register("swap_portal", (StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.lunar_stonebrick, SkiesBlocks.turquoise_stonebrick));
        public static final StructureProcessorList MODIFY_GRASS = Processors.register("modify_grass", (StructureProcessor)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_50440_), (RuleTest)new BlockMatchTest(Blocks.f_50069_), Blocks.f_50069_.m_49966_()), (Object)new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_50440_), (RuleTest)new BlockMatchTest(Blocks.f_49994_), Blocks.f_50069_.m_49966_()), (Object)new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_50440_), (RuleTest)new BlockMatchTest(Blocks.f_50016_), Blocks.f_50069_.m_49966_()))));
        public static final StructureProcessorList MODIFY_PATH = Processors.register("modify_path", (StructureProcessor)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_152481_), (RuleTest)new BlockMatchTest(Blocks.f_49990_), Blocks.f_50705_.m_49966_()), (Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_152481_, 0.2f), (RuleTest)AlwaysTrueTest.f_73954_, Blocks.f_50440_.m_49966_()), (Object)new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_50440_), (RuleTest)new BlockMatchTest(Blocks.f_49990_), Blocks.f_49990_.m_49966_()), (Object)new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_50493_), (RuleTest)new BlockMatchTest(Blocks.f_49990_), Blocks.f_50705_.m_49966_()))));
        public static final StructureProcessorList SWAP_PORTAL_MODIFY_GRASS = Processors.register("swap_portal_modify_grass", RegistryHelper.combineProcessors((StructureProcessorList[])new StructureProcessorList[]{SWAP_PORTAL, MODIFY_GRASS}));
        public static final StructureProcessorList SWAP_PORTAL_REMOVE_SNOW = Processors.register("swap_portal_remove_snow", RegistryHelper.combineProcessors((StructureProcessorList[])new StructureProcessorList[]{SWAP_PORTAL, REMOVE_SNOW}));
        public static final StructureProcessorList CALMING_SKIES_STREET = Processors.register("calming_skies_street", (StructureProcessor)Processors.makeVillagePath(SkiesBlocks.coarse_turquoise_dirt, SkiesBlocks.turquoise_dirt, SkiesBlocks.turquoise_grass_block, SkiesBlocks.bluebright_planks));
        public static final StructureProcessorList BRIGHTLANDS_STREET = Processors.register("brightlands_street", (StructureProcessor)Processors.makeVillagePath(SkiesBlocks.coarse_turquoise_dirt, SkiesBlocks.turquoise_dirt, SkiesBlocks.turquoise_grass_block, SkiesBlocks.starlit_planks));
        public static final StructureProcessorList SLUSHLANDS_STREET = Processors.register("slushlands_street", (StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.frostbright_planks, 0.2f, SkiesBlocks.stripped_frostbright_wood));
        public static final StructureProcessorList SHADED_WOODLANDS_STREET = Processors.register("shaded_woodlands_street", (StructureProcessor)Processors.makeVillagePath(SkiesBlocks.coarse_lunar_dirt, SkiesBlocks.lunar_dirt, SkiesBlocks.lunar_grass_block, SkiesBlocks.lunar_planks));
        public static final StructureProcessorList SUNSET_MAPLE_FOREST_STREET = Processors.register("sunset_maple_forest_street", (StructureProcessor)Processors.makeVillagePath(SkiesBlocks.coarse_lunar_dirt, SkiesBlocks.lunar_dirt, SkiesBlocks.lunar_grass_block, SkiesBlocks.maple_planks));
        public static final StructureProcessorList CRYSTAL_DUNES = Processors.register("crystal_dunes_street", new StructureProcessorList((List)ImmutableList.of()));

        public static void init() {
        }

        private static StructureProcessorList register(String key, StructureProcessor processor) {
            return RegistryHelper.registerProcessor((ResourceLocation)BlueSkies.locate(key), (StructureProcessor)processor);
        }

        private static StructureProcessorList register(String key, StructureProcessorList processorList) {
            return RegistryHelper.registerProcessor((ResourceLocation)BlueSkies.locate(key), (StructureProcessorList)processorList);
        }

        private static RuleProcessor makeVillagePath(Block path, Block dirt, Block grassBlock, Block bridgeMaterial) {
            return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockMatchTest(path), (RuleTest)new BlockMatchTest(Blocks.f_49990_), bridgeMaterial.m_49966_()), (Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest(path, 0.2f), (RuleTest)AlwaysTrueTest.f_73954_, grassBlock.m_49966_()), (Object)new ProcessorRule((RuleTest)new BlockMatchTest(grassBlock), (RuleTest)new BlockMatchTest(Blocks.f_49990_), Blocks.f_49990_.m_49966_()), (Object)new ProcessorRule((RuleTest)new BlockMatchTest(dirt), (RuleTest)new BlockMatchTest(Blocks.f_49990_), bridgeMaterial.m_49966_())));
        }
    }
}

