/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.structure_gel.api.registry.RegistryHelper;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class SkiesPoiTypes {
    public static final PoiType STAR_EMITTER = SkiesPoiTypes.createPOI("star_emitter", SkiesPoiTypes.getAllStates(SkiesBlocks.star_emitter), 1, 1);
    public static final PoiType TROUGH = SkiesPoiTypes.createPOI("trough", SkiesPoiTypes.getAllStates(SkiesBlocks.trough), 1, 1);
    public static final PoiType TOOL_BOX = SkiesPoiTypes.createPOI("tool_box", SkiesPoiTypes.getAllStates(SkiesBlocks.tool_box), 1, 1);
    public static final PoiType BAG_OF_SPOILS = SkiesPoiTypes.createPOI("bag_of_spoils", SkiesPoiTypes.getAllStates(SkiesBlocks.bag_of_spoils), 1, 1);
    public static final PoiType SUMMONING_TABLE = SkiesPoiTypes.createPOI("summoning_table", SkiesPoiTypes.getAllStates(SkiesBlocks.summoning_table), 1, 1);
    public static final PoiType ALCHEMY_TABLE = SkiesPoiTypes.createPOI("alchemy_table", SkiesPoiTypes.getAllStates(SkiesBlocks.alchemy_table), 1, 1);
    public static final PoiType EMPTY_WORKSTATION = SkiesPoiTypes.createPOI("empty_workstation", (Set<BlockState>)ImmutableSet.of(), 1, 1);
    public static final PoiType EVERBRIGHT_PORTAL = SkiesPoiTypes.createPOI("everbright_portal", SkiesPoiTypes.getAllStates((Block)SkiesBlocks.everbright_portal), 0, 1);
    public static final PoiType EVERDAWN_PORTAL = SkiesPoiTypes.createPOI("everdawn_portal", SkiesPoiTypes.getAllStates((Block)SkiesBlocks.everdawn_portal), 0, 1);
    public static final PoiType SPIDER_NEST = SkiesPoiTypes.createPOI("spider_nest", SkiesPoiTypes.getAllStates(SkiesBlocks.spider_nest), 0, 1);
    public static final PoiType KEYSTONE = SkiesPoiTypes.createPOI("keystone", SkiesPoiTypes.getAllStates(SkiesBlocks.bright_blinding_keystone, SkiesBlocks.dawn_blinding_keystone, SkiesBlocks.nature_keystone, SkiesBlocks.poison_keystone), 0, 1);
    public static final PoiType WARDING_PEARL = SkiesPoiTypes.createPOI("warding_pearl", SkiesPoiTypes.getAllStates(SkiesBlocks.warding_pearl, SkiesBlocks.wall_warding_pearl), 0, 1);

    public static void init(RegistryEvent.Register<PoiType> event) {
        SkiesPoiTypes.register((IForgeRegistry<PoiType>)event.getRegistry(), STAR_EMITTER);
        SkiesPoiTypes.register((IForgeRegistry<PoiType>)event.getRegistry(), TROUGH);
        SkiesPoiTypes.register((IForgeRegistry<PoiType>)event.getRegistry(), TOOL_BOX);
        SkiesPoiTypes.register((IForgeRegistry<PoiType>)event.getRegistry(), BAG_OF_SPOILS);
        SkiesPoiTypes.register((IForgeRegistry<PoiType>)event.getRegistry(), SUMMONING_TABLE);
        SkiesPoiTypes.register((IForgeRegistry<PoiType>)event.getRegistry(), ALCHEMY_TABLE);
        SkiesPoiTypes.register((IForgeRegistry<PoiType>)event.getRegistry(), EMPTY_WORKSTATION);
        SkiesPoiTypes.register((IForgeRegistry<PoiType>)event.getRegistry(), EVERBRIGHT_PORTAL);
        SkiesPoiTypes.register((IForgeRegistry<PoiType>)event.getRegistry(), EVERDAWN_PORTAL);
        SkiesPoiTypes.register((IForgeRegistry<PoiType>)event.getRegistry(), SPIDER_NEST);
        SkiesPoiTypes.register((IForgeRegistry<PoiType>)event.getRegistry(), KEYSTONE);
        SkiesPoiTypes.register((IForgeRegistry<PoiType>)event.getRegistry(), WARDING_PEARL);
    }

    private static void register(IForgeRegistry<PoiType> registry, PoiType poiType) {
        RegistryHelper.registerPOI(registry, (PoiType)poiType);
    }

    public static PoiType createPOI(String key, Set<BlockState> states, int maxFreeTickets, int validRange) {
        return new PoiType(BlueSkies.find(key), states, maxFreeTickets, validRange);
    }

    private static Set<BlockState> getAllStates(Block block) {
        return PoiType.m_27372_((Block)block);
    }

    private static Set<BlockState> getAllStates(Block ... blocks) {
        return Arrays.stream(blocks).flatMap(b -> SkiesPoiTypes.getAllStates(b).stream()).collect(Collectors.toSet());
    }
}

