/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.client.gui.menu.AlchemyTableMenu;
import com.legacy.blue_skies.client.gui.menu.ArcsMenu;
import com.legacy.blue_skies.client.gui.menu.BagOfSpoilsMenu;
import com.legacy.blue_skies.client.gui.menu.FoodPrepMenu;
import com.legacy.blue_skies.client.gui.menu.HorizoniteForgeMenu;
import com.legacy.blue_skies.client.gui.menu.MountInventoryMenu;
import com.legacy.blue_skies.client.gui.menu.SnowcapOvenMenu;
import com.legacy.blue_skies.client.gui.menu.SummoningTableMenu;
import com.legacy.blue_skies.client.gui.menu.ToolboxMenu;
import com.legacy.blue_skies.registries.SkiesRegistry;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.IForgeRegistry;

public class SkiesContainers {
    public static final MenuType<ArcsMenu> ARC_INVENTORY = SkiesContainers.make((id, inv) -> new ArcsMenu(id, inv, inv.f_35978_));
    public static final MenuType<MountInventoryMenu> MOUNT_INVENTORY = SkiesContainers.makePacket((id, inv, buffer) -> new MountInventoryMenu(id, inv, buffer));
    public static final MenuType<HorizoniteForgeMenu> HORIZONITE_FORGE = SkiesContainers.make(HorizoniteForgeMenu::new);
    public static final MenuType<SnowcapOvenMenu> SNOWCAP_OVEN = SkiesContainers.make(SnowcapOvenMenu::new);
    public static final MenuType<SummoningTableMenu> SUMMONING_TABLE = SkiesContainers.make(SummoningTableMenu::new);
    public static final MenuType<AlchemyTableMenu> ALCHEMY_TABLE = SkiesContainers.make(AlchemyTableMenu::new);
    public static final MenuType<ToolboxMenu> TOOLBOX = SkiesContainers.make(ToolboxMenu::new);
    public static final MenuType<FoodPrepMenu> FOOD_PREP_TABLE = SkiesContainers.make(FoodPrepMenu::new);
    public static final MenuType<BagOfSpoilsMenu> BAG_OF_SPOILS = SkiesContainers.make(BagOfSpoilsMenu::new);

    private static <T extends AbstractContainerMenu> MenuType<T> makePacket(IContainerFactory<T> factory) {
        return new MenuType(factory);
    }

    private static <T extends AbstractContainerMenu> MenuType<T> make(MenuType.MenuSupplier<T> factory) {
        return new MenuType(factory);
    }

    public static void init(RegistryEvent.Register<MenuType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        SkiesRegistry.register(registry, "arc_inventory", ARC_INVENTORY);
        SkiesRegistry.register(registry, "mount_inventory", MOUNT_INVENTORY);
        SkiesRegistry.register(registry, "horizonite_forge", HORIZONITE_FORGE);
        SkiesRegistry.register(registry, "snowcap_oven", SNOWCAP_OVEN);
        SkiesRegistry.register(registry, "summoning_table", SUMMONING_TABLE);
        SkiesRegistry.register(registry, "alchemy_table", ALCHEMY_TABLE);
        SkiesRegistry.register(registry, "toolbox", TOOLBOX);
        SkiesRegistry.register(registry, "food_prep_table", FOOD_PREP_TABLE);
        SkiesRegistry.register(registry, "bag_of_spoils", BAG_OF_SPOILS);
    }
}

