/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.c_to_s;

import com.legacy.blue_skies.capability.SkiesPlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class GetClientMotionPacket {
    private double motionX;
    private double motionZ;

    public GetClientMotionPacket(double motionXIn, double motionZIn) {
        this.motionX = motionXIn;
        this.motionZ = motionZIn;
    }

    public static void encoder(GetClientMotionPacket packet, FriendlyByteBuf buff) {
        buff.writeDouble(packet.motionX);
        buff.writeDouble(packet.motionZ);
    }

    public static GetClientMotionPacket decoder(FriendlyByteBuf buff) {
        return new GetClientMotionPacket(buff.readDouble(), buff.readDouble());
    }

    public static void handler(GetClientMotionPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> GetClientMotionPacket.handlePacket(packet, (Player)((NetworkEvent.Context)context.get()).getSender()));
        context.get().setPacketHandled(true);
    }

    private static void handlePacket(GetClientMotionPacket packet, Player player) {
        SkiesPlayer.ifPresent(player, skyPlayer -> skyPlayer.setSavedClientMotion(packet.motionX, 0.0, packet.motionZ));
    }
}

