/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.mod_compat.jei.category;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.objects.alchemy.AlchemyRecipe;
import com.legacy.blue_skies.data.objects.alchemy.CatylistRecipe;
import com.legacy.blue_skies.mod_compat.jei.category.SkiesCategory;
import com.legacy.blue_skies.registries.SkiesBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AlchemyCategory
extends SkiesCategory<AlchemyRecipe> {
    public static final ResourceLocation ID = BlueSkies.locate("alchemy");
    private static final ResourceLocation TEXTURE = BlueSkies.locate("textures/gui/jei/alchemy.png");

    public AlchemyCategory(IGuiHelper guiHelper) {
        super(guiHelper, (ItemLike)SkiesBlocks.alchemy_table, TEXTURE, 99, 54);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends AlchemyRecipe> getRecipeClass() {
        return AlchemyRecipe.class;
    }

    public void setIngredients(AlchemyRecipe recipe, IIngredients ingredients) {
        List results = recipe.getResults().stream().map(ItemStack::new).collect(Collectors.toList());
        if (recipe instanceof CatylistRecipe) {
            CatylistRecipe catylistRecipe = (CatylistRecipe)recipe;
            List<ItemStack> inputs = Arrays.asList(new ItemStack((ItemLike)catylistRecipe.getInput()), new ItemStack((ItemLike)catylistRecipe.getCatylist()));
            ingredients.setInputs(VanillaTypes.ITEM, inputs);
            ingredients.setOutputLists(VanillaTypes.ITEM, Arrays.asList(results));
        } else {
            ingredients.setInputLists(VanillaTypes.ITEM, Arrays.asList(results));
            ArrayList outputs = new ArrayList(results);
            outputs.add(0, (ItemStack)outputs.remove(outputs.size() - 1));
            ingredients.setOutputLists(VanillaTypes.ITEM, Arrays.asList(outputs));
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, AlchemyRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 10, 9);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        if (ingredients.getInputs(VanillaTypes.ITEM).size() >= 2 && !((List)ingredients.getInputs(VanillaTypes.ITEM).get(1)).isEmpty()) {
            recipeLayout.getItemStacks().init(1, true, 10, 28);
            recipeLayout.getItemStacks().set(1, (List)ingredients.getInputs(VanillaTypes.ITEM).get(1));
        }
        recipeLayout.getItemStacks().init(2, false, 74, 18);
        recipeLayout.getItemStacks().set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

