/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.util;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.asm_hooks.PlayerHooks;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.util.EntityUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SkiesEntityHooks {
    public static float nerfDamage(DamageSource source, float amount) {
        Player player;
        Entity entity = source.m_7640_();
        if (entity instanceof Player && SkiesDimensions.inSkyDimension((Entity)(player = (Player)entity))) {
            float def = Math.min(7.0f, amount * 0.3f);
            ItemStack weapon = player.m_21205_();
            return SkiesPlayer.getIfPresent(player, skyPlayer -> {
                if (!EntityUtil.hasPlayerCompletedProgression(skyPlayer) && !weapon.m_41720_().getRegistryName().m_135827_().equals("blue_skies") && player.m_21133_(Attributes.f_22281_) > 1.0 && PlayerHooks.isNerfableTool(weapon, null)) {
                    player.m_5661_((Component)new TranslatableComponent("gui.blue_skies.tooltip.invalid_weapon"), true);
                    return Float.valueOf(def);
                }
                return Float.valueOf(amount);
            }, () -> {
                BlueSkies.LOGGER.error("Blue Skies' player capability wasn't present for {} when trying to do damage progression checks. This should be reported if happening consistently!", (Object)player.m_142081_().toString());
                return Float.valueOf(def);
            }).floatValue();
        }
        return amount;
    }

    public static float nerfIndirectDamage(DamageSource source, float amount) {
        Entity entity;
        float def = Math.min(5.0f, amount);
        if (source.m_7639_() != null && (entity = source.m_7639_()) instanceof Player) {
            Player player = (Player)entity;
            if (SkiesDimensions.inSkyDimension(source.m_7639_())) {
                ResourceLocation name = source.m_7640_().m_6095_().getRegistryName();
                return SkiesPlayer.getIfPresent(player, skyPlayer -> {
                    if (!EntityUtil.hasPlayerCompletedProgression(skyPlayer) && (name == null || name != null && !name.m_135827_().equals("blue_skies"))) {
                        return Float.valueOf(def);
                    }
                    return Float.valueOf(amount);
                }, () -> {
                    BlueSkies.LOGGER.error("Blue Skies' player capability wasn't present for {} when trying to do indirect damage progression checks. This should be reported if happening consistently!", (Object)player.m_142081_().toString());
                    return Float.valueOf(def);
                }).floatValue();
            }
        }
        return def;
    }
}

