/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.blocks.misc.TrophyBlock;
import com.legacy.blue_skies.data.objects.SkiesEntityTags;
import com.legacy.blue_skies.entities.hostile.SpewterEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ent.EntRootEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ent.EntWallEntity;
import com.legacy.blue_skies.entities.passive.SnowOwlEntity;
import com.legacy.blue_skies.entities.projectile.EntLeafEntity;
import com.legacy.blue_skies.entities.projectile.SpearEntity;
import com.legacy.blue_skies.entities.util.SkiesDungeonType;
import com.legacy.blue_skies.entities.util.StarlitCrusherSpinSound;
import com.legacy.blue_skies.entities.util.StunnableLookController;
import com.legacy.blue_skies.entities.util.StunnedEntitySound;
import com.legacy.blue_skies.entities.util.base.SkiesBossEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.entities.util.interfaces.IStunnableMob;
import com.legacy.blue_skies.items.LootBagItem;
import com.legacy.blue_skies.items.tools.SkyAxeItem;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.DirectionUtil;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;

public class StarlitCrusherEntity
extends SkiesBossEntity
implements IStunnableMob {
    public static final Predicate<SnowOwlEntity> OWL_HOSTILE = owl -> owl.isOwlHostile();
    protected static final EntityDataAccessor<Boolean> ROOTED = SynchedEntityData.m_135353_(StarlitCrusherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> TIME_STUNNED = SynchedEntityData.m_135353_(StarlitCrusherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> SPIN_COOLDOWN = SynchedEntityData.m_135353_(StarlitCrusherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> SPINNING = SynchedEntityData.m_135353_(StarlitCrusherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int attackTimer;
    public int spinTimer;
    public int smashTimer;
    private int rootWaveCooldown;
    private int regrowWallsTimer;
    private int owlSpawnCooldown = 400;
    private int deathTicks;
    private int meleeCooldown;
    public byte rootingTime;
    public boolean canShake = false;
    public static Set<Item> SPEARS = ImmutableSet.of((Object)SkiesItems.bluebright_spear, (Object)SkiesItems.lunar_spear, (Object)SkiesItems.starlit_spear, (Object)SkiesItems.dusk_spear, (Object)SkiesItems.frostbright_spear, (Object)SkiesItems.maple_spear, (Object[])new Item[]{SkiesItems.cherry_spear, SkiesItems.soulbound_spear});
    @OnlyIn(value=Dist.CLIENT)
    private SoundInstance stunSound;
    @OnlyIn(value=Dist.CLIENT)
    private SoundInstance spinSound;

    public StarlitCrusherEntity(EntityType<? extends StarlitCrusherEntity> type, Level worldIn) {
        super((EntityType<? extends SkiesBossEntity>)type, worldIn);
        this.f_21365_ = new StunnableLookController((Mob)this);
        this.f_21364_ = 40;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false).m_26146_(6000));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new GrowWoodenWallsGoal());
        this.f_21345_.m_25352_(3, (Goal)new DirectRootAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new SurroundingRootAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new SmashGroundAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new SpinAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new SpewLeavesAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new OwlSpawnAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new SpewterSpawnAttackGoal());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ROOTED, (Object)false);
        this.f_19804_.m_135372_(TIME_STUNNED, (Object)0);
        this.f_19804_.m_135372_(SPIN_COOLDOWN, (Object)400);
        this.f_19804_.m_135372_(SPINNING, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22278_, 100.0);
    }

    @Override
    public double getBossHealth() {
        return 500.0 + (double)this.getExtraPlayers() * 150.0;
    }

    @Override
    public float getHealAmount() {
        return 30.0f;
    }

    @Override
    public LootBagItem getLootBag() {
        return SkiesItems.loot_bag_starlit_crusher;
    }

    @Override
    public TrophyBlock getTrophy() {
        return SkiesBlocks.starlit_crusher_trophy;
    }

    @Override
    public float getMaxReach() {
        return 4.15f;
    }

    @Override
    public void m_6478_(MoverType type, Vec3 vec) {
        if (!this.isBossInvul() && !this.isStunned() && !this.isRooted() && this.m_6084_()) {
            super.m_6478_(type, vec);
        } else {
            super.m_6478_(type, new Vec3(0.0, vec.f_82480_, 0.0));
        }
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.TRIGGERED && this.getHome() != null) {
            this.f_19853_.m_46961_(this.getHome(), false);
        }
        if (!this.f_19853_.f_46443_) {
            this.m_21051_(Attributes.f_22281_).m_22100_(this.getDifficultyID() >= ISkyBoss.BossLevel.GOLD.getId() ? 12.0 : (this.getDifficultyID() == ISkyBoss.BossLevel.SILVER.getId() ? 10.0 : 8.0));
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.setRooted(compound.m_128471_("IsRooted"));
        this.setStunTime(compound.m_128451_("StunTime"));
        this.setSpinCooldown(compound.m_128451_("SpinCooldown"));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsRooted", this.isRooted());
        compound.m_128405_("StunTime", this.getStunTime());
        compound.m_128405_("SpinCooldown", this.getSpinCooldown());
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return effect.m_19544_() == MobEffects.f_19620_ || effect.m_19544_() == MobEffects.f_19597_ ? false : super.m_7301_(effect);
    }

    public void m_6710_(LivingEntity living) {
        if (living == null) {
            this.f_19853_.m_7605_((Entity)this, (byte)6);
            this.canShake = false;
        }
        super.m_6710_(living);
    }

    @Override
    public void m_8119_() {
        double distanceToHome;
        super.m_8119_();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.smashTimer > 0) {
            --this.smashTimer;
        }
        if (this.meleeCooldown > 0) {
            --this.meleeCooldown;
        }
        if (this.rootWaveCooldown > 0) {
            --this.rootWaveCooldown;
        }
        if (this.owlSpawnCooldown > 0 && this.getOwlsInDungeonArea().isEmpty()) {
            --this.owlSpawnCooldown;
        }
        this.spinTimer = this.isSpinning() ? ++this.spinTimer : 0;
        double d = distanceToHome = this.getHome() != null ? (double)this.getDistanceToPos(this.getHome()) : 0.0;
        if (this.m_5448_() != null && this.getSpinCooldown() > 0 && !this.isStunned() && !this.isSpinning() && distanceToHome <= 5.0) {
            this.setSpinCooldown(this.getSpinCooldown() - 1);
        }
        if (this.getWallsInDungeonArea(5.0).size() < 4 && this.regrowWallsTimer > 0) {
            --this.regrowWallsTimer;
        }
        if (this.m_21525_() || !this.m_6084_()) {
            return;
        }
        if (this.isStunned()) {
            this.setStunTime(this.getStunTime() - 1);
            if (this.getStunTime() == 1) {
                this.regrowWallsTimer = 0;
            }
        } else if (!this.isBossInvul()) {
            double distanceForPlayer;
            double d2 = distanceForPlayer = this.getWallsInDungeonArea(5.0).size() < 4 ? 2.75 : 2.1;
            if (!this.f_19853_.f_46443_) {
                if (this.meleeCooldown <= 0 && this.f_19797_ > 20) {
                    for (LivingEntity living : this.f_19853_.m_6443_(LivingEntity.class, this.m_142469_().m_82400_(distanceForPlayer), this.canSeeAndAttackPredicate())) {
                        this.m_7327_((Entity)living);
                        if (!this.isSpinning()) {
                            this.meleeCooldown = 20;
                        }
                        if (this.m_5448_() != null) continue;
                        this.m_6710_(living);
                    }
                }
                if ((this.m_5448_() == null || this.isSecondPhase() && this.getSpinCooldown() > 0 || !this.isSecondPhase()) && (this.getWallsInDungeonArea(5.0).size() >= 4 || this.getWallsInDungeonArea(5.0).isEmpty())) {
                    if (distanceToHome > 5.0) {
                        this.m_21573_().m_26519_((double)this.getHome().m_123341_(), (double)this.getHome().m_123342_(), (double)this.getHome().m_123343_(), 1.5);
                    } else if (distanceToHome > 0.5) {
                        this.m_21566_().m_6849_((double)((float)this.getHome().m_123341_() + 0.5f), (double)this.getHome().m_123342_(), (double)((float)this.getHome().m_123343_() + 0.5f), 1.0);
                    }
                }
            }
        }
        if (!this.f_19853_.f_46443_ && this.m_5448_() == null) {
            this.setSpinCooldown(400);
            this.setSpinning(false);
        }
        if (this.isRooted() && this.f_19797_ % 40 == 0) {
            if (this.m_21223_() >= this.m_21233_() && this.owlSpawnCooldown > 0) {
                this.setRooted(false);
            }
            if (this.getDifficultyID() != ISkyBoss.BossLevel.PLATINUM.getId() && this.f_19796_.nextFloat() < 0.3f || this.getDifficultyID() == ISkyBoss.BossLevel.PLATINUM.getId()) {
                this.m_5634_(this.f_19796_.nextInt(2) + 1);
                this.m_5496_(SkiesSounds.ENTITY_STARLIT_CRUSHER_HEAL, 0.8f, 1.0f);
            }
        }
        if (!(this.f_19853_.f_46443_ || this.m_5448_() == null || EntityUtil.CAN_ATTACK.test((Entity)this.m_5448_()) && this.m_5448_().m_6084_())) {
            this.m_6710_(null);
        }
        if (this.isSpinning() && this.f_19853_ instanceof ServerLevel) {
            for (int i = 0; i < 2; ++i) {
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, this.m_142469_().m_82362_() / 4.0, 0.1, this.m_142469_().m_82385_() / 4.0, 0.05);
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.f_19853_.m_8055_(this.m_142538_().m_7495_())), this.m_20185_(), this.m_20186_(), this.m_20189_(), 3, this.m_142469_().m_82362_() / 4.0, 0.1, this.m_142469_().m_82385_() / 4.0, 0.05);
            }
        }
    }

    @Override
    public void invulnerableTick() {
        super.invulnerableTick();
        if (this.f_19853_ instanceof ServerLevel) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)SkiesParticles.FALLING_LEAF, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() + (double)0.1f, this.m_20189_(), 1, this.m_142469_().m_82362_() / 2.0, (double)0.1f, this.m_142469_().m_82385_() / 2.0, 0.05);
        }
    }

    protected void m_6153_() {
        if (this.isStunned()) {
            this.setStunned(false);
        }
        boolean flag = this.f_19853_.m_46469_().m_46207_(GameRules.f_46135_);
        for (EntWallEntity walls : this.getWallsInDungeonArea(5.0)) {
            walls.playDamageEffect();
            walls.m_146870_();
        }
        for (SpewterEntity spewters : this.getSpewtersInDungeonArea()) {
            spewters.m_21373_();
            spewters.m_146870_();
        }
        for (SnowOwlEntity owls : this.getOwlsInDungeonArea()) {
            owls.m_21373_();
            owls.m_146870_();
        }
        ++this.deathTicks;
        if (this.deathTicks < 19) {
            super.m_6153_();
        }
        float money = this.f_21364_;
        if (this.deathTicks > 30 && this.deathTicks % 5 == 0 && flag) {
            this.dropExperience(Mth.m_14143_((float)(money * 0.08f)));
        }
        if (this.deathTicks >= 100 && !this.f_19853_.f_46443_) {
            if (this.deathTicks >= 120) {
                if (this.isDungeonSpawned() && this.getHome() != null && this.getHome() != BlockPos.f_121853_) {
                    this.f_19853_.m_46597_(this.getHome(), SkiesBlocks.potted_starlit_sapling.m_49966_());
                } else {
                    this.f_19853_.m_46597_(this.m_142538_(), SkiesBlocks.potted_starlit_sapling.m_49966_());
                }
                this.m_146870_();
            }
            if (this.deathTicks % 2 == 0) {
                for (int i = 0; i < 20; ++i) {
                    this.f_19853_.m_7605_((Entity)this, (byte)9);
                }
            }
        }
        if (this.deathTicks % 5 == 0 && this.f_19853_ instanceof ServerLevel) {
            for (int i = 0; i < 4; ++i) {
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, SkiesBlocks.starlit_log.m_49966_()), this.m_20185_(), this.m_20186_() + (double)0.1f, this.m_20189_(), 40, this.m_142469_().m_82362_() / 4.0, this.m_142469_().m_82376_() / 4.0, this.m_142469_().m_82385_() / 4.0, 0.05);
            }
        }
    }

    private void dropExperience(int amount) {
        while (amount > 0) {
            int i = ExperienceOrb.m_20782_((int)amount);
            amount -= i;
            this.f_19853_.m_7967_((Entity)new ExperienceOrb(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), i));
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public void m_6074_() {
        for (EntWallEntity walls : this.getWallsInDungeonArea(5.0)) {
            walls.playDamageEffect();
            walls.m_146870_();
        }
        for (SpewterEntity spewters : this.getSpewtersInDungeonArea()) {
            spewters.m_21373_();
            spewters.m_146870_();
        }
        for (SnowOwlEntity owls : this.getOwlsInDungeonArea()) {
            owls.m_21373_();
            owls.m_146870_();
        }
        this.m_146870_();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.isRooted() || this.isStunned() ? 1.3f : 2.3f;
    }

    public boolean m_7327_(Entity entityIn) {
        if (entityIn instanceof Player) {
            ItemStack playerItem;
            Player playerentity = (Player)entityIn;
            ItemStack itemStack = playerItem = playerentity.m_6117_() ? playerentity.m_21211_() : ItemStack.f_41583_;
            if (!playerItem.m_41619_() && playerItem.canPerformAction(ToolActions.SHIELD_BLOCK) && !this.isStunned()) {
                if (playerentity instanceof ServerPlayer) {
                    playerItem.m_41629_(this.f_19796_.nextInt(5) + 5, this.f_19796_, (ServerPlayer)playerentity);
                }
                playerentity.m_36384_(true);
                playerentity.m_36335_().m_41524_(Items.f_42740_, 800);
                this.f_19853_.m_7605_((Entity)playerentity, (byte)30);
            }
        }
        if (!this.isSpinning()) {
            this.m_5496_(SkiesSounds.ENTITY_STARLIT_CRUSHER_ATTACK, 1.0f, 1.0f);
            this.attackTimer = 10;
            this.f_19853_.m_7605_((Entity)this, (byte)4);
            entityIn.m_20334_(this.m_20252_(1.0f).m_7096_() * 3.0, 0.5, this.m_20252_(1.0f).m_7094_() * 3.0);
        } else {
            entityIn.m_20334_(this.m_20252_(1.0f).m_7096_() * 5.0, 0.5, this.m_20252_(1.0f).m_7094_() * 5.0);
        }
        return super.m_7327_(entityIn);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        ItemStack stack;
        if (source == DamageSource.f_19317_) {
            return super.m_6469_(source, amount);
        }
        if (this.getInvulTime() > 0 || this.isSpinning() || !source.m_19390_() && this.getWallsInDungeonArea(5.0).size() >= 4) {
            return false;
        }
        if (this.f_20916_ <= 0 && this.f_19853_ instanceof ServerLevel) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)SkiesParticles.FALLING_LEAF, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() + (double)0.1f, this.m_20189_(), 60, this.m_142469_().m_82362_() / 2.0, (double)0.1f, this.m_142469_().m_82385_() / 2.0, 0.05);
        }
        if (!this.f_19853_.f_46443_ && this.getWallsInDungeonArea(5.0).size() < 4 && this.f_19797_ > 140 && source.m_19360_() && source.m_7640_() instanceof SpearEntity) {
            if (!this.isStunned()) {
                this.setStunned(true);
                this.setRooted(false);
                return super.m_6469_(source, Math.min(this.m_21223_(), amount / 2.0f));
            }
            return super.m_6469_(source, amount * 0.3f);
        }
        if (source.m_19390_()) {
            ItemStack stack2;
            if (source.m_7639_() instanceof Player && (stack2 = ((LivingEntity)source.m_7639_()).m_21205_()).m_41720_() == Items.f_42751_) {
                return false;
            }
            return super.m_6469_(source, amount);
        }
        if (source.m_7640_() instanceof LivingEntity && (stack = ((LivingEntity)source.m_7640_()).m_21205_()).m_41720_() instanceof SkyAxeItem) {
            if (this.isStunned()) {
                return super.m_6469_(source, amount);
            }
            return super.m_6469_(source, amount * 0.3f);
        }
        if (source.m_7640_() instanceof Player) {
            ((Player)source.m_7640_()).m_5661_((Component)new TranslatableComponent("gui.blue_skies.tooltip.invalid_ent_weapon"), true);
        }
        return super.m_6469_(source, Math.min(5.0f, amount * 0.1f));
    }

    protected SoundEvent m_7515_() {
        return this.isStunned() ? null : SkiesSounds.ENTITY_STARLIT_CRUSHER_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_STARLIT_CRUSHER_HURT;
    }

    protected SoundEvent m_5592_() {
        this.m_5496_(SkiesSounds.ENTITY_STARLIT_CRUSHER_DEATH, this.m_6121_(), 1.0f);
        return null;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        if (this.isStunned() || this.isSpinning() || this.isRooted()) {
            return;
        }
        this.m_5496_(SkiesSounds.ENTITY_STARLIT_CRUSHER_STEP, 0.25f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        switch (id) {
            case 4: {
                if (!this.isSpinning()) {
                    this.m_5496_(SkiesSounds.ENTITY_STARLIT_CRUSHER_ATTACK, 1.0f, 1.0f);
                }
                this.attackTimer = 10;
                break;
            }
            case 5: {
                this.smashTimer = 21;
                break;
            }
            case 6: {
                this.owlSpawnCooldown = 400;
                this.canShake = false;
                break;
            }
            case 7: {
                this.canShake = true;
                break;
            }
            case 8: {
                this.canShake = false;
                break;
            }
            case 9: {
                this.spawnParticles((ParticleOptions)ParticleTypes.f_123759_);
                break;
            }
            case 10: {
                this.playStunSound();
            }
            case 11: {
                this.playSpinSound();
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public void m_5997_(double x, double y, double z) {
    }

    public boolean isRooted() {
        return (Boolean)this.f_19804_.m_135370_(ROOTED);
    }

    public void setRooted(boolean rooted) {
        if (rooted) {
            this.m_5496_(SkiesSounds.ENTITY_STARLIT_CRUSHER_ROOT, this.m_6121_(), this.m_6100_());
        }
        this.f_19804_.m_135381_(ROOTED, (Object)rooted);
    }

    @Override
    public boolean isStunned() {
        return this.getStunTime() > 0;
    }

    public void setStunned(boolean stunned) {
        this.setStunned(stunned, this.getDifficultyID() >= ISkyBoss.BossLevel.GOLD.getId() ? 120 : 130);
    }

    public void setStunned(boolean stunned, int time) {
        if (stunned) {
            this.setSpinning(false);
            this.setStunTime(time);
            this.f_19853_.m_7605_((Entity)this, (byte)10);
            for (Player players : this.getPlayersInDungeonArea()) {
                players.m_5810_();
                SPEARS.forEach(spear -> players.m_36335_().m_41524_(spear, time * 3));
            }
        } else {
            this.setStunTime(0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playStunSound() {
        if (!this.m_20067_()) {
            SoundManager soundHandler = Minecraft.m_91087_().m_91106_();
            if (this.stunSound == null || this.stunSound != null && !soundHandler.m_120403_(this.stunSound)) {
                this.stunSound = new StunnedEntitySound((LivingEntity)this, SkiesSounds.ENTITY_STARLIT_CRUSHER_STUNNED, this.m_6121_());
                soundHandler.m_120367_(this.stunSound);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playSpinSound() {
        if (!this.m_20067_()) {
            SoundManager soundHandler = Minecraft.m_91087_().m_91106_();
            if (this.spinSound == null || this.spinSound != null && !soundHandler.m_120403_(this.spinSound)) {
                this.spinSound = new StarlitCrusherSpinSound(this, SkiesSounds.ENTITY_STARLIT_CRUSHER_SPIN, this.m_6121_());
                soundHandler.m_120367_(this.spinSound);
            }
        }
    }

    public int getStunTime() {
        return (Integer)this.f_19804_.m_135370_(TIME_STUNNED);
    }

    public void setStunTime(int time) {
        if (time <= 0) {
            this.meleeCooldown = 15;
        }
        this.f_19804_.m_135381_(TIME_STUNNED, (Object)time);
    }

    public int getSpinCooldown() {
        return (Integer)this.f_19804_.m_135370_(SPIN_COOLDOWN);
    }

    public void setSpinCooldown(int time) {
        this.f_19804_.m_135381_(SPIN_COOLDOWN, (Object)time);
    }

    public boolean isSpinning() {
        return (Boolean)this.f_19804_.m_135370_(SPINNING);
    }

    public void setSpinning(boolean spin) {
        if (spin != this.isSpinning() && spin && !this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)11);
        }
        this.spinTimer = 0;
        this.f_19804_.m_135381_(SPINNING, (Object)spin);
    }

    public int getDeathTicks() {
        return this.deathTicks;
    }

    public boolean canWallsGoUp() {
        double distance = this.getWallsInDungeonArea(5.0).size() < 4 ? 4.1 : 3.6;
        Player closePlayer = this.f_19853_.m_45924_(this.m_20185_(), this.m_20186_(), this.m_20189_(), distance, true);
        return !this.isSpinning() && this.getHome() != null && (double)this.getDistanceToPos(this.getHome()) <= 1.5 && (closePlayer != null && !this.m_21574_().m_148306_((Entity)closePlayer) || closePlayer == null || closePlayer != null && this.m_21574_().m_148306_((Entity)closePlayer));
    }

    public boolean m_7337_(Entity entityIn) {
        return StarlitCrusherEntity.canCollideWithEntity((Entity)this, entityIn);
    }

    public static boolean canCollideWithEntity(Entity currentEntity, Entity collidingEntity) {
        return (collidingEntity.m_5829_() || collidingEntity.m_6094_()) && !currentEntity.m_20365_(collidingEntity) && !collidingEntity.m_7307_(currentEntity);
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    public List<EntWallEntity> getWallsInDungeonArea(double distance) {
        if (!this.f_19853_.f_46443_ && this.getHome() != null && this.getHome() != BlockPos.f_121853_) {
            return this.f_19853_.m_45976_(EntWallEntity.class, new AABB((double)this.getHome().m_123341_() - distance, (double)this.getHome().m_123342_() - 1.0, (double)this.getHome().m_123343_() - distance, (double)this.getHome().m_123341_() + distance, (double)this.getHome().m_123342_() + 10.0, (double)this.getHome().m_123343_() + distance));
        }
        return ImmutableList.of();
    }

    public List<EntRootEntity> getRootsInDungeonArea(double distance) {
        if (!this.f_19853_.f_46443_ && this.getHome() != null && this.getHome() != BlockPos.f_121853_) {
            return this.f_19853_.m_45976_(EntRootEntity.class, new AABB((double)this.getHome().m_123341_() - distance, (double)this.getHome().m_123342_() - 1.0, (double)this.getHome().m_123343_() - distance, (double)this.getHome().m_123341_() + distance, (double)this.getHome().m_123342_() + 10.0, (double)this.getHome().m_123343_() + distance));
        }
        return ImmutableList.of();
    }

    public List<SnowOwlEntity> getOwlsInDungeonArea() {
        double distance = 20.0;
        if (!this.f_19853_.f_46443_ && this.getHome() != null && this.getHome() != BlockPos.f_121853_) {
            return this.f_19853_.m_6443_(SnowOwlEntity.class, new AABB((double)this.getHome().m_123341_() - distance, (double)this.getHome().m_123342_() - 1.0, (double)this.getHome().m_123343_() - distance, (double)this.getHome().m_123341_() + distance, (double)this.getHome().m_123342_() + 15.0, (double)this.getHome().m_123343_() + distance), OWL_HOSTILE);
        }
        return ImmutableList.of();
    }

    public List<SpewterEntity> getSpewtersInDungeonArea() {
        double distance = 10.0;
        if (!this.f_19853_.f_46443_ && this.getHome() != null && this.getHome() != BlockPos.f_121853_) {
            return this.f_19853_.m_45976_(SpewterEntity.class, new AABB((double)this.getHome().m_123341_() - distance, (double)this.getHome().m_123342_() - 1.0, (double)this.getHome().m_123343_() - distance, (double)this.getHome().m_123341_() + distance, (double)this.getHome().m_123342_() + 10.0, (double)this.getHome().m_123343_() + distance));
        }
        return ImmutableList.of();
    }

    @Override
    public BossEvent.BossBarColor getBossBarColor() {
        return BossEvent.BossBarColor.GREEN;
    }

    @Override
    public SkiesDungeonType getBossType() {
        return SkiesDungeonType.NATURE;
    }

    @Override
    public int getProgression() {
        return 2;
    }

    @Override
    public boolean isEverbrightBoss() {
        return true;
    }

    public boolean m_7307_(Entity entityIn) {
        if (entityIn instanceof EntRootEntity) {
            return this.m_7307_((Entity)((EntRootEntity)entityIn).getCaster());
        }
        if (entityIn.m_6095_().m_20609_(SkiesEntityTags.NATURE_ALLIES)) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return super.m_7307_(entityIn) && entityIn != null && entityIn != this;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_19943_(Tag<Fluid> fluidTag, double p_210500_2_) {
        return this.isDungeonSpawned() ? false : super.m_19943_(fluidTag, p_210500_2_);
    }

    public void spawnRoots(double xPos, double zPos, double minimumY, double yPos, float rotationIn, int warmupDelay) {
        BlockPos blockpos = new BlockPos(xPos, yPos, zPos);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = this.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)this.f_19853_, blockpos1, Direction.UP)) continue;
            if (this.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minimumY) - 1);
        if (flag && this.f_19853_.m_45772_(new AABB(blockpos)) && (this.getDifficultyID() != ISkyBoss.BossLevel.BRONZE.getId() || this.getDifficultyID() == ISkyBoss.BossLevel.BRONZE.getId() && this.f_19853_.f_46441_.nextFloat() < 0.7f)) {
            this.f_19853_.m_7967_((Entity)new EntRootEntity(this.f_19853_, xPos, (double)blockpos.m_123342_() + d0, zPos, rotationIn, warmupDelay, (LivingEntity)this, this.isSecondPhase()));
        }
    }

    public void spawnLeaf(LivingEntity target) {
        double d0 = target.m_20185_();
        double d1 = target.m_142469_().f_82289_ + (double)(target.m_20206_() / 2.0f);
        double d2 = target.m_20189_();
        this.spawnLeafAtPos(new Vec3i(d0, d1, d2));
    }

    public void spawnLeafAtPos(Vec3i pos) {
        EntLeafEntity leaf = new EntLeafEntity(SkiesEntityTypes.ENT_LEAF, (LivingEntity)this, this.f_19853_);
        leaf.m_6034_(this.m_20185_() - (double)(this.m_20205_() + 1.0f) * 0.5 * (double)Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180))), this.m_20186_() + (double)this.m_20192_() + 1.0, this.m_20189_() + (double)(this.m_20205_() + 1.0f) * 0.5 * (double)Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180))));
        double d0 = (double)pos.m_123341_() - this.m_20185_();
        double d1 = (double)pos.m_123342_() - leaf.m_20186_();
        double d2 = (double)pos.m_123343_() - this.m_20189_();
        float f = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2))) * 0.2f;
        leaf.m_6686_(d0, d1 + (double)f, d2, 1.0f, 10.0f);
        this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SkiesSounds.ENTITY_STARLIT_CRUSHER_FLING_LEAF, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f);
        this.f_19853_.m_7967_((Entity)leaf);
    }

    public void checkAndSpawnSpewters() {
        BlockPos pos;
        SpewterEntity spewter;
        if (this.f_19853_.f_46443_) {
            return;
        }
        BlockPos home = this.getHome();
        if (this.getSpewtersInSpot(home.m_142082_(8, 0, 8)).isEmpty()) {
            spewter = new SpewterEntity((EntityType<? extends SpewterEntity>)SkiesEntityTypes.SPEWTER, this.f_19853_);
            pos = home.m_142082_(8, 0, 8);
            spewter.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            this.f_19853_.m_7967_((Entity)spewter);
            spewter.m_5496_(SkiesSounds.ENTITY_SPEWTER_GROW, 1.0f, this.m_6100_());
            spewter.setGrown(true);
        }
        if (this.getSpewtersInSpot(home.m_142082_(-8, 0, -8)).isEmpty()) {
            spewter = new SpewterEntity((EntityType<? extends SpewterEntity>)SkiesEntityTypes.SPEWTER, this.f_19853_);
            pos = home.m_142082_(-8, 0, -8);
            spewter.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            this.f_19853_.m_7967_((Entity)spewter);
            spewter.m_5496_(SkiesSounds.ENTITY_SPEWTER_GROW, 1.0f, this.m_6100_());
            spewter.setGrown(true);
        }
        if (this.getSpewtersInSpot(home.m_142082_(8, 0, -8)).isEmpty()) {
            spewter = new SpewterEntity((EntityType<? extends SpewterEntity>)SkiesEntityTypes.SPEWTER, this.f_19853_);
            pos = home.m_142082_(8, 0, -8);
            spewter.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            this.f_19853_.m_7967_((Entity)spewter);
            spewter.m_5496_(SkiesSounds.ENTITY_SPEWTER_GROW, 1.0f, this.m_6100_());
            spewter.setGrown(true);
        }
        if (this.getSpewtersInSpot(home.m_142082_(-8, 0, 8)).isEmpty()) {
            spewter = new SpewterEntity((EntityType<? extends SpewterEntity>)SkiesEntityTypes.SPEWTER, this.f_19853_);
            pos = home.m_142082_(-8, 0, 8);
            spewter.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            this.f_19853_.m_7967_((Entity)spewter);
            spewter.m_5496_(SkiesSounds.ENTITY_SPEWTER_GROW, 1.0f, this.m_6100_());
            spewter.setGrown(true);
        }
    }

    public List<SpewterEntity> getSpewtersInSpot(BlockPos pos) {
        return this.f_19853_.m_45976_(SpewterEntity.class, new AABB(pos).m_82400_(1.0));
    }

    class GrowWoodenWallsGoal
    extends SkiesBossEntity.AbstractBossGoal {
        private final StarlitCrusherEntity boss;
        private int chargeTime;

        public GrowWoodenWallsGoal() {
            super(StarlitCrusherEntity.this);
            this.boss = StarlitCrusherEntity.this;
        }

        public boolean m_8036_() {
            if (this.boss.getSpinCooldown() <= 0) {
                return false;
            }
            return this.boss.canWallsGoUp() && !this.boss.isStunned() && this.boss.m_5448_() != null && !this.boss.isBossInvul() && (this.boss.regrowWallsTimer <= 0 || this.boss.getWallsInDungeonArea(5.0).isEmpty());
        }

        public boolean m_8045_() {
            if (this.boss.isSecondPhase() && this.boss.getSpinCooldown() <= 0) {
                return false;
            }
            return this.boss.canWallsGoUp() && this.boss.m_5448_() != null && this.chargeTime > 0 && !this.boss.isStunned();
        }

        public void m_8056_() {
            this.boss.randomizeAttackTarget(this.boss.f_19796_.nextBoolean());
            for (SnowOwlEntity owl : this.boss.getOwlsInDungeonArea()) {
                owl.m_21373_();
                owl.m_146870_();
            }
            this.chargeTime = 20;
            this.boss.m_5496_(SkiesSounds.ENTITY_STARLIT_CRUSHER_PREPARE_LARGE_GROWTH, this.boss.m_6121_(), this.boss.m_6100_());
        }

        public void m_8037_() {
            Level world = this.boss.f_19853_;
            if (this.boss.hasAttackTarget()) {
                this.boss.m_21563_().m_24960_((Entity)this.boss.m_5448_(), 30.0f, 30.0f);
            }
            if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            if (!world.f_46443_ && this.chargeTime == 1) {
                BlockPos home = this.boss.getHome();
                if (!this.boss.getWallsInDungeonArea(5.0).isEmpty()) {
                    for (EntWallEntity walls : this.boss.getWallsInDungeonArea(5.0)) {
                        walls.m_21153_(walls.m_21233_());
                    }
                }
                if (this.getWallsInSpot(home.m_142082_(3, 0, 0)).isEmpty()) {
                    EntWallEntity wallx = new EntWallEntity(world, home.m_123341_() + 3, home.m_123342_(), home.m_123343_(), (LivingEntity)this.boss);
                    wallx.setFacingZ(false);
                    wallx.m_21153_(wallx.m_21233_());
                    world.m_7967_((Entity)wallx);
                    wallx.m_5496_(SkiesSounds.ENTITY_STARLIT_WALL_GROW, 1.0f, this.boss.m_6100_());
                }
                if (this.getWallsInSpot(home.m_142082_(-3, 0, 0)).isEmpty()) {
                    EntWallEntity wallx2 = new EntWallEntity(world, home.m_123341_() - 3, home.m_123342_(), home.m_123343_(), (LivingEntity)this.boss);
                    wallx2.setFacingZ(false);
                    wallx2.m_21153_(wallx2.m_21233_());
                    world.m_7967_((Entity)wallx2);
                    wallx2.m_5496_(SkiesSounds.ENTITY_STARLIT_WALL_GROW, 1.0f, this.boss.m_6100_());
                }
                if (this.getWallsInSpot(home.m_142082_(0, 0, 3)).isEmpty()) {
                    EntWallEntity wallz = new EntWallEntity(world, home.m_123341_(), home.m_123342_(), home.m_123343_() + 3, (LivingEntity)this.boss);
                    wallz.setFacingZ(true);
                    wallz.m_21153_(wallz.m_21233_());
                    world.m_7967_((Entity)wallz);
                    wallz.m_5496_(SkiesSounds.ENTITY_STARLIT_WALL_GROW, 1.0f, this.boss.m_6100_());
                }
                if (this.getWallsInSpot(home.m_142082_(0, 0, -3)).isEmpty()) {
                    EntWallEntity wallz2 = new EntWallEntity(world, home.m_123341_(), home.m_123342_(), home.m_123343_() - 3, (LivingEntity)this.boss);
                    wallz2.setFacingZ(true);
                    wallz2.m_21153_(wallz2.m_21233_());
                    world.m_7967_((Entity)wallz2);
                    wallz2.m_5496_(SkiesSounds.ENTITY_STARLIT_WALL_GROW, 1.0f, this.boss.m_6100_());
                }
                this.boss.regrowWallsTimer = 100;
            }
        }

        public List<EntWallEntity> getWallsInSpot(BlockPos pos) {
            return this.boss.f_19853_.m_45976_(EntWallEntity.class, new AABB(pos).m_82400_(1.0));
        }
    }

    class DirectRootAttackGoal
    extends SkiesBossEntity.AbstractBossGoal {
        private final StarlitCrusherEntity boss;
        private int chargeTime;

        public DirectRootAttackGoal() {
            super(StarlitCrusherEntity.this);
            this.boss = StarlitCrusherEntity.this;
        }

        public boolean m_8036_() {
            return this.boss.owlSpawnCooldown > 0 && this.boss.getOwlsInDungeonArea().isEmpty() && !this.boss.isSpinning() && this.boss.canWallsGoUp() && !this.boss.isStunned() && this.boss.m_5448_() != null && !this.boss.isBossInvul() && this.boss.getWallsInDungeonArea(5.0).size() >= 4 && this.boss.regrowWallsTimer > 0;
        }

        public boolean m_8045_() {
            return this.boss.owlSpawnCooldown > 0 && this.boss.getOwlsInDungeonArea().isEmpty() && this.boss.m_5448_() != null && this.chargeTime > 0 && !this.boss.isStunned() && this.boss.getWallsInDungeonArea(5.0).size() >= 4 && this.boss.regrowWallsTimer > 0;
        }

        public void m_8056_() {
            List playersInDungeon = this.boss.getPlayersInDungeonArea();
            for (Player players : playersInDungeon) {
                if (players == this.boss.m_5448_() || !this.boss.f_19796_.nextBoolean() || playersInDungeon.size() <= 1 || players.m_7500_() || players.m_5833_()) continue;
                this.boss.m_6710_((LivingEntity)players);
            }
            this.chargeTime = 160;
            this.boss.m_5496_(SkiesSounds.ENTITY_STARLIT_CRUSHER_PREPARE_SMALL_GROWTH, 2.0f, this.boss.m_6100_());
        }

        public void m_8037_() {
            if (!this.boss.hasAttackTarget()) {
                return;
            }
            this.boss.m_21563_().m_24960_((Entity)this.boss.m_5448_(), 30.0f, 30.0f);
            if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            if (this.chargeTime >= 70 && this.chargeTime % 10 == 0) {
                if (!(this.boss.m_5448_() instanceof Player)) {
                    LivingEntity livingentity = this.boss.m_5448_();
                    double d0 = Math.min(livingentity.m_20186_(), this.boss.m_20186_());
                    double d1 = Math.max(livingentity.m_20186_(), this.boss.m_20186_()) + 1.0;
                    float f = (float)Mth.m_14136_((double)(livingentity.m_20189_() - this.boss.m_20189_()), (double)(livingentity.m_20185_() - this.boss.m_20185_()));
                    for (int l = 0; l < 16; ++l) {
                        double d2 = 1.25 * (double)(l + 3);
                        int j = 1 * l;
                        this.boss.spawnRoots(this.boss.m_20185_() + (double)Mth.m_14089_((float)f) * d2, this.boss.m_20189_() + (double)Mth.m_14031_((float)f) * d2, d0, d1, f, j);
                    }
                }
                if (!this.boss.getPlayersInDungeonArea().isEmpty()) {
                    for (Player players : this.boss.getPlayersInDungeonArea()) {
                        double d0 = Math.min(players.m_20186_(), this.boss.m_20186_());
                        double d1 = Math.max(players.m_20186_(), this.boss.m_20186_()) + 1.0;
                        float f = (float)Mth.m_14136_((double)(players.m_20189_() - this.boss.m_20189_()), (double)(players.m_20185_() - this.boss.m_20185_()));
                        for (int l = 0; l < 16; ++l) {
                            double d2 = 1.25 * (double)(l + 3);
                            int j = 1 * l;
                            this.boss.spawnRoots(this.boss.m_20185_() + (double)Mth.m_14089_((float)f) * d2, this.boss.m_20189_() + (double)Mth.m_14031_((float)f) * d2, d0, d1, f, j);
                        }
                    }
                }
            }
        }
    }

    class SurroundingRootAttackGoal
    extends SkiesBossEntity.AbstractBossGoal {
        private final StarlitCrusherEntity boss;
        private int chargeTime;

        public SurroundingRootAttackGoal() {
            super(StarlitCrusherEntity.this);
            this.boss = StarlitCrusherEntity.this;
        }

        public boolean m_8036_() {
            return !this.boss.isSpinning() && this.boss.canWallsGoUp() && !this.boss.isStunned() && this.boss.m_5448_() != null && !this.boss.isStunned() && !this.boss.isBossInvul() && this.boss.getWallsInDungeonArea(5.0).size() >= 4 && this.boss.rootWaveCooldown <= 0 && this.boss.regrowWallsTimer > 0;
        }

        public boolean m_8045_() {
            return this.boss.canWallsGoUp() && this.boss.m_5448_() != null && this.chargeTime > 0 && !this.boss.isStunned() && this.boss.getWallsInDungeonArea(5.0).size() >= 4 && this.boss.regrowWallsTimer > 0;
        }

        public void m_8056_() {
            List playersInDungeon = this.boss.getPlayersInDungeonArea();
            for (Player players : playersInDungeon) {
                if (players == this.boss.m_5448_() || !this.boss.f_19796_.nextBoolean() || playersInDungeon.size() <= 1 || players.m_7500_() || players.m_5833_()) continue;
                this.boss.m_6710_((LivingEntity)players);
            }
            this.chargeTime = 100;
        }

        public void m_8037_() {
            if (!this.boss.hasAttackTarget()) {
                return;
            }
            Level world = this.boss.f_19853_;
            this.boss.m_21563_().m_24960_((Entity)this.boss.m_5448_(), 30.0f, 30.0f);
            if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            LivingEntity livingentity = this.boss.m_5448_();
            double d0 = Math.min(livingentity.m_20186_(), this.boss.m_20186_());
            double d1 = Math.max(livingentity.m_20186_(), this.boss.m_20186_()) + 1.0;
            float f = (float)Mth.m_14136_((double)(livingentity.m_20189_() - this.boss.m_20189_()), (double)(livingentity.m_20185_() - this.boss.m_20185_()));
            switch (this.chargeTime) {
                case 80: {
                    double distance = 5.5;
                    int amount = 16;
                    for (int k = 0; k < amount; ++k) {
                        float f2 = f + (float)k * (float)Math.PI * 2.0f / (float)amount + 9.05f;
                        this.boss.spawnRoots(this.boss.m_20185_() + (double)Mth.m_14089_((float)f2) * distance + (double)(world.f_46441_.nextInt(2) - 1), this.boss.m_20189_() + (double)Mth.m_14031_((float)f2) * distance + (double)(world.f_46441_.nextInt(2) - 1), d0, d1, f2, 3);
                    }
                    break;
                }
                case 60: {
                    double distance = 7.5;
                    int amount = 20;
                    for (int k = 0; k < amount; ++k) {
                        float f2 = f + (float)k * (float)Math.PI * 2.0f / (float)amount + 9.05f;
                        this.boss.spawnRoots(this.boss.m_20185_() + (double)Mth.m_14089_((float)f2) * distance + (double)(world.f_46441_.nextInt(2) - 1), this.boss.m_20189_() + (double)Mth.m_14031_((float)f2) * distance + (double)(world.f_46441_.nextInt(2) - 1), d0, d1, f2, 3);
                    }
                    break;
                }
                case 40: {
                    double distance = 9.5;
                    int amount = 24;
                    for (int k = 0; k < amount; ++k) {
                        float f2 = f + (float)k * (float)Math.PI * 2.0f / (float)amount + 9.05f;
                        this.boss.spawnRoots(this.boss.m_20185_() + (double)Mth.m_14089_((float)f2) * distance + (double)(world.f_46441_.nextInt(2) - 1), this.boss.m_20189_() + (double)Mth.m_14031_((float)f2) * distance + (double)(world.f_46441_.nextInt(2) - 1), d0, d1, f2, 3);
                    }
                    break;
                }
                case 20: {
                    double distance = 11.5;
                    int amount = 28;
                    for (int k = 0; k < amount; ++k) {
                        float f2 = f + (float)k * (float)Math.PI * 2.0f / (float)amount + 9.05f;
                        this.boss.spawnRoots(this.boss.m_20185_() + (double)Mth.m_14089_((float)f2) * distance + (double)(world.f_46441_.nextInt(2) - 1), this.boss.m_20189_() + (double)Mth.m_14031_((float)f2) * distance + (double)(world.f_46441_.nextInt(2) - 1), d0, d1, f2, 3);
                    }
                    break;
                }
            }
            if (this.chargeTime == 1) {
                this.boss.rootWaveCooldown = 40;
            }
        }
    }

    class SmashGroundAttackGoal
    extends SkiesBossEntity.AbstractBossGoal {
        private final StarlitCrusherEntity boss;
        private int chargeTime;

        public SmashGroundAttackGoal() {
            super(StarlitCrusherEntity.this);
            this.boss = StarlitCrusherEntity.this;
        }

        public boolean m_8036_() {
            return !this.boss.isStunned() && this.boss.m_5448_() != null && !this.boss.isStunned() && !this.boss.isBossInvul() && this.boss.regrowWallsTimer > 0 && this.boss.getWallsInDungeonArea(5.0).size() < 4 && !this.boss.getWallsInDungeonArea(5.0).isEmpty();
        }

        public boolean m_8045_() {
            return this.boss.canWallsGoUp() && this.boss.m_5448_() != null && this.chargeTime > 0 && !this.boss.isStunned() && this.boss.regrowWallsTimer > 0;
        }

        public void m_8056_() {
            this.boss.randomizeAttackTarget(this.boss.f_19796_.nextBoolean());
            this.chargeTime = 110;
            if (this.boss.isRooted()) {
                this.boss.setRooted(false);
            }
        }

        public void m_8037_() {
            Level world = this.boss.f_19853_;
            if (this.boss.hasAttackTarget()) {
                this.boss.m_21563_().m_24960_((Entity)this.boss.m_5448_(), 30.0f, 30.0f);
            }
            if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            if (this.chargeTime >= 20) {
                if (this.chargeTime < 100 && this.chargeTime % 20 == 0) {
                    AABB hitbox = this.boss.m_142469_().m_82377_(15.0, 0.0, 15.0);
                    this.boss.m_5496_(SkiesSounds.ENTITY_STARLIT_CRUSHER_HAMMER_SMASH, 1.0f, this.boss.m_6100_());
                    if (world instanceof ServerLevel) {
                        for (int i = 0; i < 20; ++i) {
                            ((ServerLevel)world).m_8767_((ParticleOptions)SkiesParticles.CRUSHER_DUST, this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), 10, 0.0, 0.0, 0.0, 0.05);
                            ((ServerLevel)world).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, SkiesBlocks.nature_stone.m_49966_()), this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), 20, hitbox.m_82362_() / 4.0, 0.1, hitbox.m_82385_() / 4.0, 0.05);
                        }
                    }
                    for (Entity entity : world.m_45933_((Entity)this.boss, hitbox)) {
                        LivingEntity living;
                        if (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).m_20096_() || !(living.m_21051_(Attributes.f_22278_).m_22135_() < 1.0) || !living.m_6469_(EntityUtil.DamageSources.causeSlamDamage((Entity)this.boss), 3.0f)) continue;
                        living.m_20334_(living.m_20184_().m_7096_(), 0.7, living.m_20184_().m_7094_());
                        if (!(living instanceof Player)) continue;
                        ((Player)living).f_19864_ = true;
                    }
                }
                if (this.chargeTime % 20 == 13) {
                    this.boss.m_5496_(SkiesSounds.ENTITY_STARLIT_CRUSHER_PREPARE_HAMMER, 1.0f, 1.0f);
                    this.boss.smashTimer = 21;
                    world.m_7605_((Entity)this.boss, (byte)5);
                }
            }
        }
    }

    class SpinAttackGoal
    extends SkiesBossEntity.AbstractBossGoal {
        private final StarlitCrusherEntity boss;
        protected List<BlockPos> outsidePos;
        private int chargeTime;
        private BlockPos posToExitAt;

        public SpinAttackGoal() {
            super(StarlitCrusherEntity.this);
            this.boss = StarlitCrusherEntity.this;
            this.outsidePos = new ArrayList<BlockPos>();
        }

        public boolean m_8036_() {
            if (this.boss.getDifficultyID() != ISkyBoss.BossLevel.PLATINUM.getId() && this.boss.regrowWallsTimer > 0 && !this.boss.getWallsInDungeonArea(15.0).isEmpty()) {
                return false;
            }
            return this.boss.getSpinCooldown() <= 0 && this.boss.isSecondPhase() && this.boss.m_5448_() != null && !this.boss.isStunned() && !this.boss.isBossInvul();
        }

        public boolean m_8045_() {
            return this.boss.getSpinCooldown() <= 0 && this.boss.m_5448_() != null && !this.boss.isStunned() && this.chargeTime > 0;
        }

        public void m_8056_() {
            this.outsidePos.clear();
            this.outsidePos.addAll(EntityUtil.createDiamondOffsetsFromPos(this.boss.getHome(), 7));
            Player closestPlayer = this.boss.f_19853_.m_45930_((Entity)this.boss, 30.0);
            if (closestPlayer != null && !closestPlayer.m_7500_() && !closestPlayer.m_5833_()) {
                this.posToExitAt = EntityUtil.getClosestPosInList(closestPlayer.m_142538_(), this.outsidePos);
                this.boss.m_6710_((LivingEntity)closestPlayer);
            }
            this.chargeTime = 300;
            if (this.boss.isRooted()) {
                this.boss.setRooted(false);
            }
            if (this.boss.owlSpawnCooldown < 100) {
                this.boss.owlSpawnCooldown = 100;
            }
        }

        public void m_8037_() {
            if (!this.boss.hasAttackTarget()) {
                return;
            }
            BlockPos spinStartPos = this.boss.getHome() != null && this.posToExitAt != null ? this.posToExitAt : this.boss.m_142538_();
            this.boss.m_21563_().m_24960_((Entity)this.boss.m_5448_(), 30.0f, 30.0f);
            double distance = this.boss.getDistanceToPos(spinStartPos);
            if (this.chargeTime >= 270) {
                if (this.chargeTime == 300) {
                    this.boss.m_5496_(SkiesSounds.ENTITY_STARLIT_CRUSHER_PREPARE_HAMMER, 1.0f, 1.0f);
                    this.boss.smashTimer = 21;
                    this.boss.f_19853_.m_7605_((Entity)this.boss, (byte)5);
                }
                if (this.chargeTime == 285) {
                    this.boss.m_5496_(SkiesSounds.ENTITY_STARLIT_CRUSHER_HAMMER_SMASH, this.boss.m_6121_(), 1.0f);
                    for (EntWallEntity walls : this.boss.getWallsInDungeonArea(5.0)) {
                        walls.playDamageEffect();
                        walls.m_146870_();
                    }
                }
                --this.chargeTime;
                return;
            }
            if (!this.boss.isSpinning()) {
                if (distance > 3.0) {
                    this.boss.m_21573_().m_26519_((double)spinStartPos.m_123341_(), (double)spinStartPos.m_123342_(), (double)spinStartPos.m_123343_(), 2.0);
                }
                if (distance <= 3.0) {
                    this.boss.m_5496_(SkiesSounds.ENTITY_STARLIT_CRUSHER_PREPARE_SPIN, this.boss.m_6121_(), this.boss.m_6100_());
                    this.boss.setSpinning(true);
                }
            } else {
                float spinSpeed;
                float f = this.boss.getDifficultyID() == ISkyBoss.BossLevel.PLATINUM.getId() ? 1.65f : (spinSpeed = this.boss.getDifficultyID() == ISkyBoss.BossLevel.GOLD.getId() ? 1.55f : 1.45f);
                if (this.boss.m_21574_().m_148306_((Entity)this.boss.m_5448_())) {
                    this.boss.m_21566_().m_6849_(this.boss.m_5448_().m_20185_(), this.boss.m_5448_().m_20186_(), this.boss.m_5448_().m_20189_(), (double)spinSpeed);
                } else {
                    this.boss.m_21573_().m_26519_(this.boss.m_5448_().m_20185_(), this.boss.m_5448_().m_20186_(), this.boss.m_5448_().m_20189_(), (double)spinSpeed);
                }
                if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
            }
            if (this.chargeTime == 1) {
                this.boss.setSpinCooldown(800);
                this.boss.setStunned(true, 80);
                this.posToExitAt = null;
            }
        }
    }

    class SpewLeavesAttackGoal
    extends SkiesBossEntity.AbstractBossGoal {
        private final StarlitCrusherEntity boss;
        private int chargeTime;

        public SpewLeavesAttackGoal() {
            super(StarlitCrusherEntity.this);
            this.boss = StarlitCrusherEntity.this;
        }

        public boolean m_8036_() {
            return this.boss.getSpinCooldown() <= 0 && !this.boss.isSecondPhase() && this.boss.m_5448_() != null && !this.boss.isStunned() && !this.boss.isBossInvul() && this.boss.regrowWallsTimer <= 0 && !this.boss.getWallsInDungeonArea(15.0).isEmpty();
        }

        public boolean m_8045_() {
            return this.boss.getSpinCooldown() <= 0 && this.boss.m_5448_() != null && !this.boss.isStunned() && this.chargeTime > 0;
        }

        public void m_8056_() {
            for (EntWallEntity walls : this.boss.getWallsInDungeonArea(5.0)) {
                walls.playDamageEffect();
                walls.m_146870_();
            }
            this.chargeTime = 260;
            this.boss.m_5496_(SkiesSounds.ENTITY_STARLIT_CRUSHER_PREPARE_SPIN, this.boss.m_6121_(), this.boss.m_6100_());
        }

        public void m_8037_() {
            if (!this.boss.hasAttackTarget()) {
                return;
            }
            this.boss.m_21563_().m_24960_((Entity)this.boss.m_5448_(), 30.0f, 30.0f);
            if (!this.boss.isSpinning()) {
                this.boss.setSpinning(true);
            } else {
                if (this.boss.f_19797_ % 2 == 0) {
                    LivingEntity target = this.boss.m_5448_();
                    this.boss.spawnLeaf(target);
                    for (Direction dir : DirectionUtil.HORIZONTAL) {
                        this.boss.spawnLeafAtPos((Vec3i)this.boss.getHome().m_5484_(dir, 10).m_6630_(2));
                    }
                }
                if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
            }
            if (this.chargeTime == 1) {
                this.boss.setSpinCooldown(400);
                this.boss.setStunned(true, 50);
            }
        }
    }

    class OwlSpawnAttackGoal
    extends SkiesBossEntity.AbstractBossGoal {
        private final StarlitCrusherEntity boss;
        private int chargeTime;
        protected List<BlockPos> outsidePos;
        private BlockPos posToExitAt;

        public OwlSpawnAttackGoal() {
            super(StarlitCrusherEntity.this);
            this.boss = StarlitCrusherEntity.this;
            this.outsidePos = new ArrayList<BlockPos>();
        }

        public boolean m_8036_() {
            return this.boss.getOwlsInDungeonArea().isEmpty() && this.boss.owlSpawnCooldown <= 0 && !this.boss.isSpinning() && this.boss.canWallsGoUp() && !this.boss.isStunned() && this.boss.m_5448_() != null && !this.boss.isStunned() && !this.boss.isBossInvul() && this.boss.getWallsInDungeonArea(5.0).size() >= 4 && this.boss.regrowWallsTimer > 0;
        }

        public boolean m_8045_() {
            return this.boss.m_5448_() != null && this.chargeTime > 0 && !this.boss.isStunned() && this.boss.getWallsInDungeonArea(5.0).size() >= 4 && this.boss.regrowWallsTimer > 0;
        }

        public void m_8056_() {
            this.outsidePos.clear();
            for (int i = 0; i < 4; ++i) {
                this.outsidePos.add(this.boss.getHome().m_5484_(Direction.m_122407_((int)i), 7).m_6630_(8));
            }
            this.boss.randomizeAttackTarget(this.boss.f_19796_.nextBoolean());
            this.chargeTime = 80;
            this.boss.setRooted(true);
            this.boss.f_19853_.m_7605_((Entity)this.boss, (byte)7);
            this.boss.canShake = true;
            this.boss.m_5496_(SkiesSounds.ENTITY_STARLIT_CRUSHER_PREPARE_OWLS, 2.0f, 1.0f);
        }

        public void m_8037_() {
            Level world = this.boss.f_19853_;
            if (this.boss.hasAttackTarget()) {
                this.boss.m_21563_().m_24960_((Entity)this.boss.m_5448_(), 30.0f, 30.0f);
            }
            if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            if (this.chargeTime == 20) {
                Player closestPlayer = this.boss.f_19853_.m_45930_((Entity)this.boss, 30.0);
                if (closestPlayer != null && !closestPlayer.m_7500_() && !closestPlayer.m_5833_()) {
                    this.posToExitAt = EntityUtil.getClosestPosInList(closestPlayer.m_142538_(), this.outsidePos);
                }
                ArrayList targets = new ArrayList();
                targets.addAll(this.boss.getPlayersInDungeonArea());
                for (int i = 0; i < this.getMaxOwlsBasedOnPlayerCount(); ++i) {
                    SnowOwlEntity owl = (SnowOwlEntity)SkiesEntityTypes.SNOW_OWL.m_20615_(world);
                    owl.setOwlHostile(true);
                    owl.m_6034_(this.boss.m_20185_() + (double)(this.boss.m_20205_() / 2.0f), this.boss.m_20186_() + (double)this.boss.m_20206_() + 0.5, this.boss.m_20189_() + (double)(this.boss.m_20205_() / 2.0f));
                    owl.m_20256_(owl.m_20184_().m_82520_(0.0, (double)0.4f, 0.0));
                    owl.m_21051_(Attributes.f_22277_).m_22100_(25.0);
                    owl.m_21051_(Attributes.f_22276_).m_22100_(12.0);
                    if (!targets.isEmpty()) {
                        Player player = (Player)targets.get(0);
                        owl.m_6710_((LivingEntity)player);
                        targets.remove(0);
                    } else if (!this.boss.getPlayersInDungeonArea().isEmpty()) {
                        owl.m_6710_((LivingEntity)this.boss.getPlayersInDungeonArea().get(world.f_46441_.nextInt(this.boss.getPlayersInDungeonArea().size())));
                    } else if (this.boss.m_5448_() != null) {
                        owl.m_6710_(this.boss.m_5448_());
                    }
                    owl.exitPos = this.posToExitAt != null ? this.posToExitAt : null;
                    world.m_7967_((Entity)owl);
                }
                this.boss.m_5496_(SoundEvents.f_12019_, this.boss.m_6121_(), EntityUtil.getSoundPitchWithStart(this.boss.f_19853_.f_46441_, 0.6f));
                this.boss.checkAndSpawnSpewters();
            } else if (this.chargeTime == 1) {
                world.m_7605_((Entity)this.boss, (byte)6);
                this.boss.canShake = false;
                this.boss.owlSpawnCooldown = 400;
            }
        }

        public int getMaxOwlsBasedOnPlayerCount() {
            int difficultyAmp = this.boss.getDifficultyID() == ISkyBoss.BossLevel.SILVER.getId() ? 4 : (this.boss.getDifficultyID() >= ISkyBoss.BossLevel.GOLD.getId() ? 5 : 3);
            int extraPlayers = Math.max(0, this.boss.getPlayersInDungeonArea().size() - 1);
            return difficultyAmp + extraPlayers;
        }
    }

    class SpewterSpawnAttackGoal
    extends SkiesBossEntity.AbstractBossGoal {
        private final StarlitCrusherEntity boss;
        private int chargeTime;

        public SpewterSpawnAttackGoal() {
            super(StarlitCrusherEntity.this);
            this.boss = StarlitCrusherEntity.this;
        }

        public boolean m_8036_() {
            return this.boss.getSpewtersInDungeonArea().size() <= 2 && this.boss.isRooted() && !this.boss.isSpinning() && this.boss.canWallsGoUp() && !this.boss.isStunned() && this.boss.hasAttackTarget() && !this.boss.isBossInvul() && this.boss.getWallsInDungeonArea(5.0).size() >= 4 && this.boss.regrowWallsTimer > 0;
        }

        public boolean m_8045_() {
            return this.boss.m_5448_() != null && this.chargeTime > 0 && !this.boss.isStunned() && this.boss.getWallsInDungeonArea(5.0).size() >= 4 && this.boss.regrowWallsTimer > 0;
        }

        public void m_8056_() {
            this.boss.randomizeAttackTarget(this.boss.f_19796_.nextBoolean());
            this.chargeTime = 60;
            this.boss.f_19853_.m_7605_((Entity)this.boss, (byte)7);
            this.boss.canShake = true;
        }

        public void m_8037_() {
            Level world = this.boss.f_19853_;
            if (this.boss.hasAttackTarget()) {
                this.boss.m_21563_().m_24960_((Entity)this.boss.m_5448_(), 30.0f, 30.0f);
            }
            if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            if (this.chargeTime == 20) {
                this.boss.checkAndSpawnSpewters();
            } else if (this.chargeTime == 1) {
                world.m_7605_((Entity)this.boss, (byte)8);
                this.boss.canShake = false;
            }
        }
    }

    public static enum EntLegPosition {
        NONE,
        SPINNING,
        ROOTED,
        STUNNED,
        DYING;


        public static EntLegPosition getEntPosition(StarlitCrusherEntity ent) {
            if (ent.getDeathTicks() > 0) {
                return DYING;
            }
            if (ent.isSpinning()) {
                return SPINNING;
            }
            if (ent.isRooted()) {
                return ROOTED;
            }
            if (ent.isStunned()) {
                return STUNNED;
            }
            return NONE;
        }
    }
}

