/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.capability.util.ISkiesPlayer;
import com.legacy.blue_skies.entities.util.MovingEntitySound;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import com.legacy.blue_skies.util.StringUtil;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SupporterPetEntity
extends TamableAnimal {
    private static final EntityDataAccessor<Byte> TYPE_ID = SynchedEntityData.m_135353_(SupporterPetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    @OnlyIn(value=Dist.CLIENT)
    private SoundInstance flapSound;

    public SupporterPetEntity(Level worldIn, byte typeId) {
        this(SkiesEntityTypes.SUPPORTER_PET, worldIn);
        this.setTypeID(typeId);
    }

    public SupporterPetEntity(EntityType<? extends SupporterPetEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8045_() {
                return !SupporterPetEntity.this.m_21566_().m_24995_() && super.m_8045_();
            }
        });
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE_ID, (Object)0);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            Player owner = this.getPlayerOwner();
            if (owner != null) {
                ISkiesPlayer skyPlayer;
                if (!BlueSkies.ML_SUPPORTER.getRank(owner).hasPerks()) {
                    BlueSkies.LOGGER.info(owner.m_5446_().getString() + " is no longer ranked. Despawning their pet.");
                    this.m_146870_();
                }
                if ((skyPlayer = SkiesPlayer.get(owner)) != null) {
                    if (skyPlayer.getSupporterPet() == null) {
                        skyPlayer.setSupporterPet((LivingEntity)this);
                    }
                    if (!(this.f_19797_ <= 1 || skyPlayer.getSupporterPet().m_142081_() == this.m_142081_() && skyPlayer.isSupporterPetEnabled())) {
                        this.m_146870_();
                    }
                    if (this.f_19797_ > 1 && !owner.f_19853_.m_46472_().m_135782_().equals((Object)this.f_19853_.m_46472_().m_135782_())) {
                        skyPlayer.setSupporterPet(null);
                        this.m_146870_();
                    }
                    float distFromOwner = this.m_20270_((Entity)owner);
                    if (this.getTypeID() == 0) {
                        this.m_20242_(true);
                        if (distFromOwner > 25.0f || !this.m_21574_().m_148306_((Entity)owner) && distFromOwner > 15.0f) {
                            this.m_6021_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_());
                        } else if (distFromOwner > 7.0f) {
                            Vec3 targetEyes = owner.m_20299_(1.0f);
                            this.f_21342_.m_6849_(targetEyes.f_82479_, targetEyes.f_82480_ - 0.3, targetEyes.f_82481_, 1.0);
                            this.m_21563_().m_24960_((Entity)owner, 40.0f, 40.0f);
                        } else if (this.f_19853_.m_8055_(this.m_142538_().m_7495_()).m_60815_()) {
                            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.001, 0.0));
                        }
                        if (!this.f_21342_.m_24995_()) {
                            this.m_20256_(this.m_20184_().m_82542_((double)0.95f, (double)0.9f, (double)0.95f));
                        }
                    } else if (distFromOwner > 25.0f) {
                        this.m_6021_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_());
                    } else if (distFromOwner > 7.0f) {
                        this.m_21573_().m_5624_((Entity)owner, 1.0);
                        this.m_21563_().m_24960_((Entity)owner, 40.0f, 40.0f);
                    }
                } else {
                    this.m_146870_();
                }
                boolean playerInDim = owner.f_19853_.m_46472_().m_135782_().equals((Object)this.f_19853_.m_46472_().m_135782_());
                if (this.f_19797_ > 1 && !playerInDim) {
                    this.m_146870_();
                }
                if (this.f_19797_ == 1) {
                    this.f_19853_.m_7605_((Entity)this, (byte)4);
                }
            } else if (this.f_19797_ > 20 && owner == null) {
                this.m_146870_();
            }
        }
        if (this.getTypeID() == 0 && this.f_19853_.f_46443_) {
            this.playFlightSound();
        }
        this.m_6210_();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        Player owner = this.getPlayerOwner();
        if (owner != null) {
            SkiesPlayer.ifPresent(owner, skyPlayer -> skyPlayer.setSupporterPet((LivingEntity)this));
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        super.m_142687_(reason);
    }

    public boolean m_6090_() {
        return true;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("GetTypeId", this.getTypeID());
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.setTypeID(compound.m_128445_("GetTypeId"));
    }

    public void setTypeID(byte id) {
        if (id == 0) {
            this.f_21342_ = new FlyingMovementController(this);
        } else {
            this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
            this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        }
        this.f_19804_.m_135381_(TYPE_ID, (Object)id);
    }

    public byte getTypeID() {
        return (Byte)this.f_19804_.m_135370_(TYPE_ID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        switch (id) {
            case 4: {
                for (int i = 0; i < 20; ++i) {
                    double dx = this.f_19796_.nextGaussian() * 0.02;
                    double dy = this.f_19796_.nextGaussian() * 0.02;
                    double dz = this.f_19796_.nextGaussian() * 0.02;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.f_19796_.nextFloat() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), dx, dy, dz);
                }
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    protected void m_20157_() {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    protected void m_7324_(Entity entityIn) {
    }

    protected void m_6138_() {
    }

    protected SoundEvent m_7515_() {
        if (this.shouldGangster()) {
            return SkiesSounds.GANGSTER;
        }
        switch (this.getTypeID()) {
            case 1: {
                return SkiesSounds.ENTITY_STONELET_IDLE;
            }
        }
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        switch (this.getTypeID()) {
            case 0: {
                return SkiesSounds.ENTITY_NYCTOFLY_HURT;
            }
            case 1: {
                return SkiesSounds.ENTITY_STONELET_HURT;
            }
            case 2: {
                return SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_HURT;
            }
        }
        return super.m_7975_(damageSourceIn);
    }

    protected SoundEvent m_5592_() {
        switch (this.getTypeID()) {
            case 0: {
                return SkiesSounds.ENTITY_NYCTOFLY_DEATH;
            }
            case 1: {
                return SkiesSounds.ENTITY_STONELET_DEATH;
            }
            case 2: {
                return SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_DEATH;
            }
        }
        return super.m_5592_();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        switch (this.getTypeID()) {
            case 0: {
                return;
            }
            case 1: {
                this.m_5496_(SoundEvents.f_11834_, 0.1f, 1.4f);
                break;
            }
            case 2: {
                this.m_5496_(SoundEvents.f_12010_, 0.5f, 1.4f);
                break;
            }
            default: {
                super.m_7355_(pos, blockIn);
            }
        }
    }

    public boolean shouldGangster() {
        return this.m_8077_() && StringUtil.toLower(this.m_7770_().getString()).equals("gangster");
    }

    public float m_6100_() {
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + (this.shouldGangster() ? 1.0f : 1.5f);
    }

    public int m_8100_() {
        return this.shouldGangster() ? 360 : super.m_8100_();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        switch (this.getTypeID()) {
            case 0: {
                return sizeIn.f_20378_ / 2.0f;
            }
            case 2: {
                return 0.7f;
            }
        }
        return super.m_6431_(poseIn, sizeIn);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source == DamageSource.f_19317_) {
            return super.m_6469_(source, amount);
        }
        return false;
    }

    @Nullable
    public Player getPlayerOwner() {
        LivingEntity owner = this.m_142480_();
        if (owner != null && owner instanceof Player) {
            return (Player)owner;
        }
        return null;
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playFlightSound() {
        if (!this.m_20067_() && this.f_19853_.f_46443_) {
            SoundManager soundHandler = Minecraft.m_91087_().m_91106_();
            if (this.flapSound == null && !soundHandler.m_120403_(this.flapSound) || this.flapSound != null && !soundHandler.m_120403_(this.flapSound)) {
                this.flapSound = new MovingEntitySound((LivingEntity)this, SkiesSounds.ENTITY_NYCTOFLY_FLYING, 0.3f, 1.5f);
                soundHandler.m_120367_(this.flapSound);
            }
        }
    }

    class FlyingMovementController
    extends MoveControl {
        private SupporterPetEntity nycto;

        public FlyingMovementController(SupporterPetEntity bug) {
            super((Mob)bug);
            this.nycto = SupporterPetEntity.this;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 difference = new Vec3(this.f_24975_ - this.nycto.m_20185_(), this.f_24976_ - this.nycto.m_20186_(), this.f_24977_ - this.nycto.m_20189_());
                double d0 = difference.m_82553_();
                if (d0 < this.nycto.m_142469_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.nycto.m_20256_(this.nycto.m_20184_().m_82490_(0.5));
                } else {
                    this.nycto.m_20256_(this.nycto.m_20184_().m_82549_(difference.m_82490_(this.m_24999_() * 0.05 / d0)));
                    double d4 = this.f_24975_ - this.nycto.m_20185_();
                    double d5 = this.f_24977_ - this.nycto.m_20189_();
                    this.nycto.m_146922_(-((float)Mth.m_14136_((double)d4, (double)d5)) * 57.295776f);
                    this.nycto.m_5618_(this.nycto.m_146908_());
                }
                BlockPos blockPos = new BlockPos(this.f_24975_, this.f_24976_, this.f_24977_);
                if (EntityUtil.getDistanceToPos((Vec3i)this.nycto.m_142538_(), (Vec3i)blockPos) < 3.0f) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.nycto.m_20256_(this.nycto.m_20184_().m_82490_(0.5));
                }
            }
        }

        public double m_24999_() {
            return 0.6;
        }
    }
}

