/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.providers;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.blocks.natural.LargeFlowerBlock;
import com.legacy.blue_skies.data.objects.SkiesBlockTags;
import com.legacy.blue_skies.data.objects.SkiesEntityTags;
import com.legacy.blue_skies.data.objects.SkiesItemTags;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class SkiesTagProv {

    public static class EntityTagProv
    extends EntityTypeTagsProvider {
        public EntityTagProv(DataGenerator generatorIn, ExistingFileHelper existingFileHelper) {
            super(generatorIn, "blue_skies", existingFileHelper);
        }

        protected void m_6577_() {
            this.blueSkies();
            this.vanilla();
            this.forge();
        }

        public void m_6865_(HashCache cache) {
            super.m_6865_(cache);
            SkiesEntityTags.init();
        }

        private void blueSkies() {
            this.m_126548_((Tag.Named)SkiesEntityTags.FROST_SPIRITS).m_126584_((Object[])new EntityType[]{SkiesEntityTypes.FROST_SPIRIT, SkiesEntityTypes.ARMORED_FROST_SPIRIT, SkiesEntityTypes.CRYNOCEROUS});
            this.m_126548_((Tag.Named)SkiesEntityTags.BOSSES).m_126584_((Object[])new EntityType[]{SkiesEntityTypes.SUMMONER, SkiesEntityTypes.ALCHEMIST, SkiesEntityTypes.STARLIT_CRUSHER, SkiesEntityTypes.ARACHNARCH}).m_176839_(BlueSkies.locate("armored_maw"));
            this.m_126548_((Tag.Named)SkiesEntityTags.NATURE_ALLIES).m_126584_((Object[])new EntityType[]{SkiesEntityTypes.STARLIT_CRUSHER, SkiesEntityTypes.SPEWTER, SkiesEntityTypes.SNOW_OWL, SkiesEntityTypes.ENT_WALL, SkiesEntityTypes.ENT_ROOT, SkiesEntityTypes.ENT_LEAF, SkiesEntityTypes.STONELET});
            this.m_126548_((Tag.Named)SkiesEntityTags.POISON_ALLIES).m_126584_((Object[])new EntityType[]{SkiesEntityTypes.ARACHNARCH, SkiesEntityTypes.NESTED_SPIDER, SkiesEntityTypes.VENOM_SPIT, SkiesEntityTypes.VENOM_SPIDER, EntityType.f_20479_, EntityType.f_20554_});
        }

        private void vanilla() {
            this.m_126548_(EntityTypeTags.f_13121_).m_126584_((Object[])new EntityType[]{SkiesEntityTypes.SUMMONER, SkiesEntityTypes.ALCHEMIST});
        }

        private void forge() {
        }

        public String m_6055_() {
            return "Blue Skies EntityType Tags";
        }
    }

    public static class ItemTagProv
    extends ItemTagsProvider {
        public ItemTagProv(DataGenerator generatorIn, BlockTagsProvider blocktagProvIn, ExistingFileHelper existingFileHelper) {
            super(generatorIn, blocktagProvIn, "blue_skies", existingFileHelper);
        }

        protected void m_6577_() {
            this.blueSkies();
            this.vanilla();
            this.forge();
        }

        public void m_6865_(HashCache cache) {
            super.m_6865_(cache);
            SkiesItemTags.init();
        }

        private void blueSkies() {
            this.m_126533_((Tag.Named)SkiesBlockTags.BOOKSHELVES, (Tag.Named)SkiesItemTags.BOOKSHELVES);
            this.m_126533_((Tag.Named)SkiesBlockTags.CRAFTING_TABLES, (Tag.Named)SkiesItemTags.CRAFTING_TABLES);
            this.m_126533_((Tag.Named)SkiesBlockTags.LADDERS, (Tag.Named)SkiesItemTags.LADDERS);
            this.m_126533_((Tag.Named)SkiesBlockTags.VINES, (Tag.Named)SkiesItemTags.VINES);
            this.m_126533_((Tag.Named)SkiesBlockTags.BLUEBRIGHT_LOGS, (Tag.Named)SkiesItemTags.BLUEBRIGHT_LOGS);
            this.m_126533_((Tag.Named)SkiesBlockTags.STARLIT_LOGS, (Tag.Named)SkiesItemTags.STARLIT_LOGS);
            this.m_126533_((Tag.Named)SkiesBlockTags.FROSTBRIGHT_LOGS, (Tag.Named)SkiesItemTags.FROSTBRIGHT_LOGS);
            this.m_126533_((Tag.Named)SkiesBlockTags.LUNAR_LOGS, (Tag.Named)SkiesItemTags.LUNAR_LOGS);
            this.m_126533_((Tag.Named)SkiesBlockTags.DUSK_LOGS, (Tag.Named)SkiesItemTags.DUSK_LOGS);
            this.m_126533_((Tag.Named)SkiesBlockTags.MAPLE_LOGS, (Tag.Named)SkiesItemTags.MAPLE_LOGS);
            this.m_126533_((Tag.Named)SkiesBlockTags.CHERRY_LOGS, (Tag.Named)SkiesItemTags.CHERRY_LOGS);
            this.m_126533_((Tag.Named)SkiesBlockTags.CRYSTALLIZED_LOGS, (Tag.Named)SkiesItemTags.CRYSTALLIZED_LOGS);
            this.m_126533_((Tag.Named)SkiesBlockTags.COBBLESTONES, (Tag.Named)SkiesItemTags.COBBLESTONES);
            this.m_126533_((Tag.Named)SkiesBlockTags.STONES, (Tag.Named)SkiesItemTags.STONES);
            this.m_126533_((Tag.Named)SkiesBlockTags.BLINDING_STONES, (Tag.Named)SkiesItemTags.BLINDING_STONES);
            this.m_126533_((Tag.Named)SkiesBlockTags.POISON_STONES, (Tag.Named)SkiesItemTags.POISON_STONES);
            this.m_126533_((Tag.Named)SkiesBlockTags.NATURE_STONES, (Tag.Named)SkiesItemTags.NATURE_STONES);
            this.m_126533_((Tag.Named)SkiesBlockTags.AQUATIC_STONES, (Tag.Named)SkiesItemTags.AQUATIC_STONES);
            this.m_126533_((Tag.Named)SkiesBlockTags.LIFE_STONES, (Tag.Named)SkiesItemTags.LIFE_STONES);
            this.m_126533_((Tag.Named)SkiesBlockTags.MOONSTONE_ORES, (Tag.Named)SkiesItemTags.MOONSTONE_ORES);
            this.m_126533_((Tag.Named)SkiesBlockTags.PYROPE_ORES, (Tag.Named)SkiesItemTags.PYROPE_ORES);
            this.m_126533_((Tag.Named)SkiesBlockTags.DIOPSIDE_ORES, (Tag.Named)SkiesItemTags.DIOPSIDE_ORES);
            this.m_126533_((Tag.Named)SkiesBlockTags.AQUITE_ORES, (Tag.Named)SkiesItemTags.AQUITE_ORES);
            this.m_126533_((Tag.Named)SkiesBlockTags.CHAROITE_ORES, (Tag.Named)SkiesItemTags.CHAROITE_ORES);
            this.m_126533_((Tag.Named)SkiesBlockTags.HORIZONITE_ORES, (Tag.Named)SkiesItemTags.HORIZONITE_ORES);
            this.m_126533_((Tag.Named)SkiesBlockTags.FALSITE_ORES, (Tag.Named)SkiesItemTags.FALSITE_ORES);
            this.m_126533_((Tag.Named)SkiesBlockTags.VENTIUM_ORES, (Tag.Named)SkiesItemTags.VENTIUM_ORES);
            this.m_126533_((Tag.Named)SkiesBlockTags.MOONSTONE_BLOCKS, (Tag.Named)SkiesItemTags.MOONSTONE_BLOCKS);
            this.m_126533_((Tag.Named)SkiesBlockTags.PYROPE_BLOCKS, (Tag.Named)SkiesItemTags.PYROPE_BLOCKS);
            this.m_126533_((Tag.Named)SkiesBlockTags.DIOPSIDE_BLOCKS, (Tag.Named)SkiesItemTags.DIOPSIDE_BLOCKS);
            this.m_126533_((Tag.Named)SkiesBlockTags.AQUITE_BLOCKS, (Tag.Named)SkiesItemTags.AQUITE_BLOCKS);
            this.m_126533_((Tag.Named)SkiesBlockTags.CHAROITE_BLOCKS, (Tag.Named)SkiesItemTags.CHAROITE_BLOCKS);
            this.m_126533_((Tag.Named)SkiesBlockTags.HORIZONITE_BLOCKS, (Tag.Named)SkiesItemTags.HORIZONITE_BLOCKS);
            this.m_126533_((Tag.Named)SkiesBlockTags.FALSITE_BLOCKS, (Tag.Named)SkiesItemTags.FALSITE_BLOCKS);
            this.m_126533_((Tag.Named)SkiesBlockTags.VENTIUM_BLOCKS, (Tag.Named)SkiesItemTags.VENTIUM_BLOCKS);
            this.m_126533_((Tag.Named)SkiesBlockTags.RAW_AQUITE_BLOCKS, (Tag.Named)SkiesItemTags.RAW_AQUITE_BLOCKS);
            this.m_126533_((Tag.Named)SkiesBlockTags.RAW_CHAROITE_BLOCKS, (Tag.Named)SkiesItemTags.RAW_CHAROITE_BLOCKS);
            this.m_126533_((Tag.Named)SkiesBlockTags.RAW_HORIZONITE_BLOCKS, (Tag.Named)SkiesItemTags.RAW_HORIZONITE_BLOCKS);
            this.m_126533_((Tag.Named)SkiesBlockTags.RAW_FALSITE_BLOCKS, (Tag.Named)SkiesItemTags.RAW_FALSITE_BLOCKS);
            this.m_126533_((Tag.Named)SkiesBlockTags.RAW_VENTIUM_BLOCKS, (Tag.Named)SkiesItemTags.RAW_VENTIUM_BLOCKS);
            this.m_126533_((Tag.Named)SkiesBlockTags.ILLAGER_TELEPORTABLE, (Tag.Named)SkiesItemTags.ILLAGER_TELEPORTABLE);
            this.m_126548_((Tag.Named)SkiesItemTags.WOODEN_PICKAXES).m_126584_((Object[])new Item[]{SkiesItems.bluebright_pickaxe, SkiesItems.starlit_pickaxe, SkiesItems.frostbright_pickaxe, SkiesItems.lunar_pickaxe, SkiesItems.dusk_pickaxe, SkiesItems.maple_pickaxe, SkiesItems.cherry_pickaxe});
            this.m_126548_((Tag.Named)SkiesItemTags.WOODEN_SHOVELS).m_126584_((Object[])new Item[]{SkiesItems.bluebright_shovel, SkiesItems.starlit_shovel, SkiesItems.frostbright_shovel, SkiesItems.lunar_shovel, SkiesItems.dusk_shovel, SkiesItems.maple_shovel, SkiesItems.cherry_shovel});
            this.m_126548_((Tag.Named)SkiesItemTags.WOODEN_AXES).m_126584_((Object[])new Item[]{SkiesItems.bluebright_axe, SkiesItems.starlit_axe, SkiesItems.frostbright_axe, SkiesItems.lunar_axe, SkiesItems.dusk_axe, SkiesItems.maple_axe, SkiesItems.cherry_axe});
            this.m_126548_((Tag.Named)SkiesItemTags.WOODEN_HOES).m_126584_((Object[])new Item[]{SkiesItems.bluebright_hoe, SkiesItems.starlit_hoe, SkiesItems.frostbright_hoe, SkiesItems.lunar_hoe, SkiesItems.dusk_hoe, SkiesItems.maple_hoe, SkiesItems.cherry_hoe});
            this.m_126548_((Tag.Named)SkiesItemTags.WOODEN_SWORDS).m_126584_((Object[])new Item[]{SkiesItems.bluebright_sword, SkiesItems.starlit_sword, SkiesItems.frostbright_sword, SkiesItems.lunar_sword, SkiesItems.dusk_sword, SkiesItems.maple_sword, SkiesItems.cherry_sword});
            this.m_126548_((Tag.Named)SkiesItemTags.WOODEN_TOOLS).addTags(new Tag.Named[]{SkiesItemTags.WOODEN_PICKAXES, SkiesItemTags.WOODEN_SHOVELS, SkiesItemTags.WOODEN_AXES, SkiesItemTags.WOODEN_HOES, SkiesItemTags.WOODEN_SWORDS});
            this.m_126548_((Tag.Named)SkiesItemTags.HORIZONITE_TOOLS).m_126584_((Object[])new Item[]{SkiesItems.horizonite_pickaxe, SkiesItems.horizonite_axe, SkiesItems.horizonite_shovel, SkiesItems.horizonite_hoe, SkiesItems.horizonite_sword});
            this.m_126548_((Tag.Named)SkiesItemTags.PICKAXES).addTags(new Tag.Named[]{SkiesItemTags.WOODEN_PICKAXES}).m_126584_((Object[])new Item[]{SkiesItems.pyrope_pickaxe, SkiesItems.diopside_pickaxe, SkiesItems.aquite_pickaxe, SkiesItems.charoite_pickaxe, SkiesItems.horizonite_pickaxe});
            this.m_126548_((Tag.Named)SkiesItemTags.AXES).addTags(new Tag.Named[]{SkiesItemTags.WOODEN_AXES}).m_126584_((Object[])new Item[]{SkiesItems.pyrope_axe, SkiesItems.diopside_axe, SkiesItems.aquite_axe, SkiesItems.charoite_axe, SkiesItems.horizonite_axe});
            this.m_126548_((Tag.Named)SkiesItemTags.SHOVELS).addTags(new Tag.Named[]{SkiesItemTags.WOODEN_SHOVELS}).m_126584_((Object[])new Item[]{SkiesItems.pyrope_shovel, SkiesItems.diopside_shovel, SkiesItems.aquite_shovel, SkiesItems.charoite_shovel, SkiesItems.horizonite_shovel});
            this.m_126548_((Tag.Named)SkiesItemTags.HOES).addTags(new Tag.Named[]{SkiesItemTags.WOODEN_HOES}).m_126584_((Object[])new Item[]{SkiesItems.pyrope_hoe, SkiesItems.diopside_hoe, SkiesItems.aquite_hoe, SkiesItems.charoite_hoe, SkiesItems.horizonite_hoe});
            this.m_126548_((Tag.Named)SkiesItemTags.SWORDS).addTags(new Tag.Named[]{SkiesItemTags.WOODEN_SWORDS}).m_126584_((Object[])new Item[]{SkiesItems.turquoise_stone_sword, SkiesItems.lunar_stone_sword, SkiesItems.pyrope_sword, SkiesItems.diopside_sword, SkiesItems.aquite_sword, SkiesItems.charoite_sword, SkiesItems.horizonite_sword, SkiesItems.infused_arc_sword, SkiesItems.different_sword});
            this.m_126548_((Tag.Named)SkiesItemTags.TOOLS).addTags(new Tag.Named[]{SkiesItemTags.PICKAXES, SkiesItemTags.AXES, SkiesItemTags.SHOVELS, SkiesItemTags.HOES, SkiesItemTags.SWORDS});
            this.m_126548_((Tag.Named)SkiesItemTags.MOONSTONE).m_126582_((Object)SkiesBlocks.moonstone.m_5456_());
            this.m_126548_((Tag.Named)SkiesItemTags.MOONSTONE_SHARD).m_126582_((Object)SkiesItems.moonstone_shard);
            this.m_126548_((Tag.Named)SkiesItemTags.PYROPE).m_126582_((Object)SkiesItems.pyrope_gem);
            this.m_126548_((Tag.Named)SkiesItemTags.AQUITE).m_126582_((Object)SkiesItems.aquite);
            this.m_126548_((Tag.Named)SkiesItemTags.DIOPSIDE).m_126582_((Object)SkiesItems.diopside_gem);
            this.m_126548_((Tag.Named)SkiesItemTags.CHAROITE).m_126582_((Object)SkiesItems.charoite);
            this.m_126548_((Tag.Named)SkiesItemTags.HORIZONITE).m_126582_((Object)SkiesItems.horizonite_ingot);
            this.m_126548_((Tag.Named)SkiesItemTags.FALSITE).m_126582_((Object)SkiesItems.falsite_ingot);
            this.m_126548_((Tag.Named)SkiesItemTags.VENTIUM).m_126582_((Object)SkiesItems.ventium_ingot);
            this.m_126548_((Tag.Named)SkiesItemTags.HORIZONITE_NUGGETS).m_126582_((Object)SkiesItems.horizonite_nugget);
            this.m_126548_((Tag.Named)SkiesItemTags.FALSITE_NUGGETS).m_126582_((Object)SkiesItems.falsite_nugget);
            this.m_126548_((Tag.Named)SkiesItemTags.VENTIUM_NUGGETS).m_126582_((Object)SkiesItems.ventium_nugget);
            this.m_126548_((Tag.Named)SkiesItemTags.RAW_MATERIALS_AQUITE).m_126582_((Object)SkiesItems.raw_aquite);
            this.m_126548_((Tag.Named)SkiesItemTags.RAW_MATERIALS_CHAROITE).m_126582_((Object)SkiesItems.raw_charoite);
            this.m_126548_((Tag.Named)SkiesItemTags.RAW_MATERIALS_HORIZONITE).m_126582_((Object)SkiesItems.raw_horizonite);
            this.m_126548_((Tag.Named)SkiesItemTags.RAW_MATERIALS_FALSITE).m_126582_((Object)SkiesItems.raw_falsite);
            this.m_126548_((Tag.Named)SkiesItemTags.RAW_MATERIALS_VENTIUM).m_126582_((Object)SkiesItems.raw_ventium);
            this.m_126548_((Tag.Named)SkiesItemTags.DUNGEON_KEYS).m_126584_((Object[])new Item[]{SkiesItems.blinding_key, SkiesItems.nature_key, SkiesItems.poison_key});
            this.m_126548_((Tag.Named)SkiesItemTags.ARCS).m_126584_((Object[])new Item[]{SkiesItems.ethereal_arc, SkiesItems.dusk_arc, SkiesItems.nature_arc, SkiesItems.poison_arc, SkiesItems.aquatic_arc, SkiesItems.life_arc, SkiesItems.runic_arc});
            this.m_126548_((Tag.Named)SkiesItemTags.CHERRY_GRASS_DROPS);
            this.m_126548_((Tag.Named)SkiesItemTags.TURQUOISE_GRASS_DROPS).m_126584_((Object[])new Item[]{SkiesItems.pine_fruit_seeds, SkiesItems.winter_leaf_seeds});
            this.m_126548_((Tag.Named)SkiesItemTags.LUNAR_GRASS_DROPS).m_126584_((Object[])new Item[]{SkiesItems.scalefruit_seeds, SkiesItems.fiery_bean_seeds});
            this.m_126548_((Tag.Named)SkiesItemTags.TROUGH_FOODS).m_126584_((Object[])new Item[]{Items.f_42405_, Items.f_42619_, SkiesItems.pine_fruit, SkiesItems.scalefruit});
        }

        private void vanilla() {
            this.m_126533_(BlockTags.f_13035_, ItemTags.f_13143_);
            this.m_126533_(BlockTags.f_13106_, ItemTags.f_13182_);
            this.m_126533_(BlockTags.f_13105_, ItemTags.f_13181_);
            this.m_126533_(BlockTags.f_13104_, ItemTags.f_13180_);
            this.m_126533_(BlockTags.f_13031_, ItemTags.f_13139_);
            this.m_126533_(BlockTags.f_13037_, ItemTags.f_13145_);
            this.m_126533_(BlockTags.f_13030_, ItemTags.f_13138_);
            this.m_126533_(BlockTags.f_13032_, ItemTags.f_13140_);
            this.m_126533_(BlockTags.f_13092_, ItemTags.f_13170_);
            this.m_126533_(BlockTags.f_13095_, ItemTags.f_13173_);
            this.m_126533_(BlockTags.f_13103_, ItemTags.f_13179_);
            this.m_126533_(BlockTags.f_13098_, ItemTags.f_13176_);
            this.m_126533_(BlockTags.f_13100_, ItemTags.f_13177_);
            this.m_126533_(BlockTags.f_13097_, ItemTags.f_13175_);
            this.m_126533_(BlockTags.f_13096_, ItemTags.f_13174_);
            this.m_126533_(BlockTags.f_13102_, ItemTags.f_13178_);
            this.m_126533_(BlockTags.f_13036_, ItemTags.f_13144_);
            this.m_126533_(BlockTags.f_13090_, ItemTags.f_13168_);
            this.m_126533_(BlockTags.f_13029_, ItemTags.f_13137_);
            this.m_126533_(BlockTags.f_13066_, ItemTags.f_13157_);
            this.m_126533_(BlockTags.f_144263_, ItemTags.f_144317_);
            this.m_126548_(ItemTags.f_13150_).m_126584_((Object[])new Item[]{SkiesItems.warding_pearl, SkiesItems.soul_fragment});
            this.m_126548_(ItemTags.f_13156_).m_126584_((Object[])new Item[]{SkiesItems.grittle_flatfish, SkiesItems.cooked_grittle_flatfish, SkiesItems.municipal_monkfish, SkiesItems.cooked_municipal_monkfish, SkiesItems.charscale_moki, SkiesItems.cooked_charscale_moki, SkiesItems.horizofin_tunid, SkiesItems.cooked_horizofin_tunid});
            this.m_126548_(ItemTags.f_13164_).m_126584_((Object[])new Item[]{SkiesItems.pyrope_gem, SkiesItems.aquite, SkiesItems.diopside_gem, SkiesItems.charoite, SkiesItems.falsite_ingot, SkiesItems.ventium_ingot, SkiesItems.horizonite_ingot});
            this.addMatching((Tag.Named<Item>)ItemTags.f_13158_, i -> i instanceof RecordItem);
        }

        private void forge() {
            this.m_126533_((Tag.Named)Tags.Blocks.CHESTS_WOODEN, (Tag.Named)Tags.Items.CHESTS_WOODEN);
            this.m_126533_((Tag.Named)Tags.Blocks.COBBLESTONE, (Tag.Named)Tags.Items.COBBLESTONE);
            this.m_126533_((Tag.Named)Tags.Blocks.STONE, (Tag.Named)Tags.Items.STONE);
            this.m_126533_((Tag.Named)SkiesBlockTags.BOOKSHELVES, (Tag.Named)Tags.Items.BOOKSHELVES);
            this.m_126533_((Tag.Named)Tags.Blocks.SAND, (Tag.Named)Tags.Items.SAND);
            this.m_126548_((Tag.Named)Tags.Items.RODS_WOODEN).m_126584_((Object[])new Item[]{SkiesItems.bluebright_stick, SkiesItems.starlit_stick, SkiesItems.frostbright_stick, SkiesItems.lunar_stick, SkiesItems.dusk_stick, SkiesItems.maple_stick, SkiesItems.cherry_stick});
            this.m_126533_((Tag.Named)Tags.Blocks.STAINED_GLASS, (Tag.Named)Tags.Items.STAINED_GLASS);
            this.m_126533_((Tag.Named)Tags.Blocks.GLASS_SILICA, (Tag.Named)Tags.Items.GLASS_SILICA);
            this.m_126533_((Tag.Named)Tags.Blocks.STAINED_GLASS_PANES, (Tag.Named)Tags.Items.STAINED_GLASS_PANES);
            this.m_126533_((Tag.Named)Tags.Blocks.ORES, (Tag.Named)Tags.Items.ORES);
            this.m_126533_((Tag.Named)Tags.Blocks.ORES_EMERALD, (Tag.Named)Tags.Items.ORES_EMERALD);
            this.m_126533_((Tag.Named)Tags.Blocks.SANDSTONE, (Tag.Named)Tags.Items.SANDSTONE);
            this.m_126533_((Tag.Named)Tags.Blocks.STORAGE_BLOCKS, (Tag.Named)Tags.Items.STORAGE_BLOCKS);
            this.m_126533_((Tag.Named)Tags.Blocks.ORE_RATES_SPARSE, (Tag.Named)Tags.Items.ORE_RATES_SPARSE);
            this.m_126533_((Tag.Named)Tags.Blocks.ORE_RATES_SINGULAR, (Tag.Named)Tags.Items.ORE_RATES_SINGULAR);
            this.m_126548_((Tag.Named)Tags.Items.CROPS).m_126584_((Object[])new Item[]{SkiesItems.pine_fruit, SkiesItems.winter_leaves, SkiesItems.cryo_root, SkiesItems.scalefruit, SkiesItems.fiery_beans, SkiesItems.solnut});
            this.m_126548_((Tag.Named)Tags.Items.SEEDS).m_126584_((Object[])new Item[]{SkiesItems.pine_fruit_seeds, SkiesItems.winter_leaf_seeds, SkiesItems.scalefruit_seeds, SkiesItems.fiery_bean_seeds});
            this.m_126548_((Tag.Named)Tags.Items.GEMS).addTags(new Tag.Named[]{SkiesItemTags.PYROPE, SkiesItemTags.DIOPSIDE, SkiesItemTags.AQUITE, SkiesItemTags.CHAROITE});
            this.m_126548_((Tag.Named)Tags.Items.INGOTS).addTags(new Tag.Named[]{SkiesItemTags.HORIZONITE, SkiesItemTags.FALSITE, SkiesItemTags.VENTIUM});
            this.m_126548_((Tag.Named)Tags.Items.NUGGETS).addTags(new Tag.Named[]{SkiesItemTags.HORIZONITE_NUGGETS, SkiesItemTags.FALSITE_NUGGETS, SkiesItemTags.VENTIUM_NUGGETS});
            this.m_126548_((Tag.Named)Tags.Items.RAW_MATERIALS).addTags(new Tag.Named[]{SkiesItemTags.RAW_MATERIALS_AQUITE, SkiesItemTags.RAW_MATERIALS_CHAROITE, SkiesItemTags.RAW_MATERIALS_FALSITE, SkiesItemTags.RAW_MATERIALS_HORIZONITE, SkiesItemTags.RAW_MATERIALS_VENTIUM});
            this.m_126548_((Tag.Named)Tags.Items.ENCHANTING_FUELS).m_126580_(SkiesItemTags.FALSITE_NUGGETS);
        }

        public String m_6055_() {
            return "Blue Skies Item Tags";
        }

        private Stream<Item> getMatching(Function<Item, Boolean> condition) {
            return ForgeRegistries.ITEMS.getValues().stream().filter(block -> block.getRegistryName().m_135827_().equals("blue_skies") && (Boolean)condition.apply((Item)block) != false);
        }

        private void addMatching(Tag.Named<Item> itemTag, Function<Item, Boolean> condition) {
            this.getMatching(condition).forEach(arg_0 -> ((TagsProvider.TagAppender)this.m_126548_(itemTag)).m_126582_(arg_0));
        }
    }

    public static class BlockTagProv
    extends BlockTagsProvider {
        public BlockTagProv(DataGenerator generatorIn, ExistingFileHelper existingFileHelper) {
            super(generatorIn, "blue_skies", existingFileHelper);
        }

        protected void m_6577_() {
            this.blueSkies();
            this.vanilla();
            this.forge();
        }

        public void m_6865_(HashCache cache) {
            super.m_6865_(cache);
            SkiesBlockTags.init();
        }

        private void blueSkies() {
            this.m_126548_((Tag.Named)SkiesBlockTags.BOOKSHELVES).m_126584_((Object[])new Block[]{SkiesBlocks.bluebright_bookshelf, SkiesBlocks.starlit_bookshelf, SkiesBlocks.frostbright_bookshelf, SkiesBlocks.lunar_bookshelf, SkiesBlocks.dusk_bookshelf, SkiesBlocks.maple_bookshelf, SkiesBlocks.cherry_bookshelf});
            this.m_126548_((Tag.Named)SkiesBlockTags.CRAFTING_TABLES).m_126584_((Object[])new Block[]{SkiesBlocks.bluebright_crafting_table, SkiesBlocks.starlit_crafting_table, SkiesBlocks.frostbright_crafting_table, SkiesBlocks.lunar_crafting_table, SkiesBlocks.dusk_crafting_table, SkiesBlocks.maple_crafting_table, SkiesBlocks.cherry_crafting_table});
            this.m_126548_((Tag.Named)SkiesBlockTags.LADDERS).m_126584_((Object[])new Block[]{SkiesBlocks.bluebright_ladder, SkiesBlocks.starlit_ladder, SkiesBlocks.frostbright_ladder, SkiesBlocks.lunar_ladder, SkiesBlocks.dusk_ladder, SkiesBlocks.maple_ladder, SkiesBlocks.cherry_ladder});
            this.m_126548_((Tag.Named)SkiesBlockTags.VINES).m_126584_((Object[])new Block[]{SkiesBlocks.bluebright_vine, SkiesBlocks.starlit_vine, SkiesBlocks.frostbright_vine, SkiesBlocks.lunar_vine, SkiesBlocks.dusk_vine, SkiesBlocks.maple_vine});
            this.m_126548_((Tag.Named)SkiesBlockTags.BLUEBRIGHT_LOGS).m_126584_((Object[])new Block[]{SkiesBlocks.bluebright_log, SkiesBlocks.bluebright_wood, SkiesBlocks.stripped_bluebright_log, SkiesBlocks.stripped_bluebright_wood});
            this.m_126548_((Tag.Named)SkiesBlockTags.STARLIT_LOGS).m_126584_((Object[])new Block[]{SkiesBlocks.starlit_log, SkiesBlocks.starlit_wood, SkiesBlocks.stripped_starlit_log, SkiesBlocks.stripped_starlit_wood});
            this.m_126548_((Tag.Named)SkiesBlockTags.FROSTBRIGHT_LOGS).m_126584_((Object[])new Block[]{SkiesBlocks.frostbright_log, SkiesBlocks.frostbright_wood, SkiesBlocks.stripped_frostbright_log, SkiesBlocks.stripped_frostbright_wood});
            this.m_126548_((Tag.Named)SkiesBlockTags.LUNAR_LOGS).m_126584_((Object[])new Block[]{SkiesBlocks.lunar_log, SkiesBlocks.lunar_wood, SkiesBlocks.stripped_lunar_log, SkiesBlocks.stripped_lunar_wood});
            this.m_126548_((Tag.Named)SkiesBlockTags.DUSK_LOGS).m_126584_((Object[])new Block[]{SkiesBlocks.dusk_log, SkiesBlocks.dusk_wood, SkiesBlocks.stripped_dusk_log, SkiesBlocks.stripped_dusk_wood});
            this.m_126548_((Tag.Named)SkiesBlockTags.MAPLE_LOGS).m_126584_((Object[])new Block[]{SkiesBlocks.maple_log, SkiesBlocks.maple_wood, SkiesBlocks.stripped_maple_log, SkiesBlocks.stripped_maple_wood});
            this.m_126548_((Tag.Named)SkiesBlockTags.CHERRY_LOGS).m_126584_((Object[])new Block[]{SkiesBlocks.cherry_log, SkiesBlocks.cherry_wood, SkiesBlocks.stripped_cherry_log, SkiesBlocks.stripped_cherry_wood});
            this.m_126548_((Tag.Named)SkiesBlockTags.CRYSTALLIZED_LOGS).m_126584_((Object[])new Block[]{SkiesBlocks.crystallized_log, SkiesBlocks.crystallized_wood});
            this.m_126548_((Tag.Named)SkiesBlockTags.COBBLESTONES).m_126584_((Object[])new Block[]{SkiesBlocks.turquoise_cobblestone, SkiesBlocks.lunar_cobblestone});
            this.m_126548_((Tag.Named)SkiesBlockTags.STONES).m_126584_((Object[])new Block[]{SkiesBlocks.turquoise_stone, SkiesBlocks.lunar_stone});
            this.m_126548_((Tag.Named)SkiesBlockTags.BLINDING_STONES).m_126584_((Object[])new Block[]{SkiesBlocks.blinding_stone, SkiesBlocks.glowing_blinding_stone});
            this.m_126548_((Tag.Named)SkiesBlockTags.POISON_STONES).m_126584_((Object[])new Block[]{SkiesBlocks.poison_stone, SkiesBlocks.glowing_poison_stone, SkiesBlocks.poison_stonebrick});
            this.m_126548_((Tag.Named)SkiesBlockTags.NATURE_STONES).m_126584_((Object[])new Block[]{SkiesBlocks.nature_stone, SkiesBlocks.glowing_nature_stone});
            this.m_126548_((Tag.Named)SkiesBlockTags.AQUATIC_STONES).m_126584_((Object[])new Block[]{SkiesBlocks.aquatic_stone, SkiesBlocks.glowing_aquatic_stone});
            this.m_126548_((Tag.Named)SkiesBlockTags.LIFE_STONES).m_126584_((Object[])new Block[]{SkiesBlocks.life_stone, SkiesBlocks.glowing_life_stone});
            this.m_126548_((Tag.Named)SkiesBlockTags.ILLAGER_TELEPORTABLE).m_126584_((Object[])new Block[]{SkiesBlocks.turquoise_stonebrick, SkiesBlocks.mossy_turquoise_stonebrick, SkiesBlocks.cracked_turquoise_stonebrick, SkiesBlocks.lunar_stonebrick, SkiesBlocks.mossy_lunar_stonebrick, SkiesBlocks.cracked_lunar_stonebrick});
            this.m_126548_((Tag.Named)SkiesBlockTags.MOONSTONE_ORES).m_126584_((Object[])new Block[]{SkiesBlocks.everbright_moonstone_ore, SkiesBlocks.everdawn_moonstone_ore});
            this.m_126548_((Tag.Named)SkiesBlockTags.PYROPE_ORES).m_126584_((Object[])new Block[]{SkiesBlocks.everbright_pyrope_ore, SkiesBlocks.everdawn_pyrope_ore});
            this.m_126548_((Tag.Named)SkiesBlockTags.DIOPSIDE_ORES).m_126584_((Object[])new Block[]{SkiesBlocks.everbright_diopside_ore, SkiesBlocks.everdawn_diopside_ore});
            this.m_126548_((Tag.Named)SkiesBlockTags.AQUITE_ORES).m_126584_((Object[])new Block[]{SkiesBlocks.everbright_aquite_ore, SkiesBlocks.everdawn_aquite_ore});
            this.m_126548_((Tag.Named)SkiesBlockTags.CHAROITE_ORES).m_126584_((Object[])new Block[]{SkiesBlocks.everbright_charoite_ore, SkiesBlocks.everdawn_charoite_ore});
            this.m_126548_((Tag.Named)SkiesBlockTags.HORIZONITE_ORES).m_126582_((Object)SkiesBlocks.horizonite_ore);
            this.m_126548_((Tag.Named)SkiesBlockTags.FALSITE_ORES).m_126582_((Object)SkiesBlocks.falsite_ore);
            this.m_126548_((Tag.Named)SkiesBlockTags.VENTIUM_ORES).m_126582_((Object)SkiesBlocks.ventium_ore);
            this.m_126548_((Tag.Named)SkiesBlockTags.MOONSTONE_BLOCKS).m_126582_((Object)SkiesBlocks.moonstone_block);
            this.m_126548_((Tag.Named)SkiesBlockTags.PYROPE_BLOCKS).m_126582_((Object)SkiesBlocks.pyrope_block);
            this.m_126548_((Tag.Named)SkiesBlockTags.DIOPSIDE_BLOCKS).m_126582_((Object)SkiesBlocks.diopside_block);
            this.m_126548_((Tag.Named)SkiesBlockTags.AQUITE_BLOCKS).m_126582_((Object)SkiesBlocks.aquite_block);
            this.m_126548_((Tag.Named)SkiesBlockTags.CHAROITE_BLOCKS).m_126582_((Object)SkiesBlocks.charoite_block);
            this.m_126548_((Tag.Named)SkiesBlockTags.HORIZONITE_BLOCKS).m_126582_((Object)SkiesBlocks.horizonite_block);
            this.m_126548_((Tag.Named)SkiesBlockTags.FALSITE_BLOCKS).m_126582_((Object)SkiesBlocks.falsite_block);
            this.m_126548_((Tag.Named)SkiesBlockTags.VENTIUM_BLOCKS).m_126582_((Object)SkiesBlocks.ventium_block);
            this.m_126548_((Tag.Named)SkiesBlockTags.RAW_AQUITE_BLOCKS).m_126582_((Object)SkiesBlocks.raw_aquite_block);
            this.m_126548_((Tag.Named)SkiesBlockTags.RAW_CHAROITE_BLOCKS).m_126582_((Object)SkiesBlocks.raw_charoite_block);
            this.m_126548_((Tag.Named)SkiesBlockTags.RAW_HORIZONITE_BLOCKS).m_126582_((Object)SkiesBlocks.raw_horizonite_block);
            this.m_126548_((Tag.Named)SkiesBlockTags.RAW_FALSITE_BLOCKS).m_126582_((Object)SkiesBlocks.raw_falsite_block);
            this.m_126548_((Tag.Named)SkiesBlockTags.RAW_VENTIUM_BLOCKS).m_126582_((Object)SkiesBlocks.raw_ventium_block);
        }

        private void vanilla() {
            this.addMatching((Tag.Named<Block>)BlockTags.f_13045_, b -> b instanceof FlowerPotBlock);
            this.m_126548_(BlockTags.f_13049_).m_126584_((Object[])new Block[]{SkiesBlocks.crystal_glass, SkiesBlocks.midnight_glass});
            this.addMatching((Tag.Named<Block>)BlockTags.f_13035_, b -> b instanceof LeavesBlock);
            this.addMatching((Tag.Named<Block>)BlockTags.f_13106_, b -> b instanceof RotatedPillarBlock && b.m_49966_().m_60767_().equals(Material.f_76320_));
            this.m_126548_(BlockTags.f_13106_).m_126584_((Object[])new Block[]{SkiesBlocks.crystallized_log, SkiesBlocks.crystallized_wood});
            this.addMatching((Tag.Named<Block>)BlockTags.f_13105_, b -> b instanceof RotatedPillarBlock && b.m_49966_().m_60767_().equals(Material.f_76320_));
            this.addMatching((Tag.Named<Block>)BlockTags.f_13104_, b -> b instanceof SaplingBlock);
            this.addMatching((Tag.Named<Block>)BlockTags.f_13031_, b -> b instanceof SlabBlock && !b.m_49966_().m_60767_().equals(Material.f_76320_));
            this.addMatching((Tag.Named<Block>)BlockTags.f_13037_, b -> b instanceof FlowerBlock || b instanceof LargeFlowerBlock);
            this.addMatching((Tag.Named<Block>)BlockTags.f_13030_, b -> b instanceof StairBlock && !b.m_49966_().m_60767_().equals(Material.f_76320_));
            this.addMatching((Tag.Named<Block>)BlockTags.f_13048_, b -> b instanceof GrassBlock);
            this.addMatching((Tag.Named<Block>)BlockTags.f_13032_, b -> b instanceof WallBlock);
            this.addMatching((Tag.Named<Block>)BlockTags.f_13092_, b -> b instanceof WoodButtonBlock);
            this.addMatching((Tag.Named<Block>)BlockTags.f_13095_, b -> b instanceof DoorBlock && b.m_49966_().m_60767_().equals(Material.f_76320_));
            this.m_126548_(BlockTags.f_13095_).m_126582_((Object)SkiesBlocks.crystallized_door);
            this.addMatching((Tag.Named<Block>)BlockTags.f_13103_, b -> b instanceof DoorBlock && !b.m_49966_().m_60767_().equals(Material.f_76320_));
            this.addMatching((Tag.Named<Block>)BlockTags.f_13098_, b -> b instanceof FenceBlock && b.m_49966_().m_60767_().equals(Material.f_76320_));
            this.addMatching((Tag.Named<Block>)BlockTags.f_13100_, b -> b instanceof BasePressurePlateBlock && b.m_49966_().m_60767_().equals(Material.f_76320_));
            this.addMatching((Tag.Named<Block>)BlockTags.f_13097_, b -> b instanceof SlabBlock && b.m_49966_().m_60767_().equals(Material.f_76320_));
            this.addMatching((Tag.Named<Block>)BlockTags.f_13096_, b -> b instanceof StairBlock && b.m_49966_().m_60767_().equals(Material.f_76320_));
            this.addMatching((Tag.Named<Block>)BlockTags.f_13102_, b -> b instanceof TrapDoorBlock && b.m_49966_().m_60767_().equals(Material.f_76320_));
            this.addMatching((Tag.Named<Block>)BlockTags.f_13036_, b -> b instanceof TrapDoorBlock && !b.m_49966_().m_60767_().equals(Material.f_76320_));
            this.addMatching((Tag.Named<Block>)BlockTags.f_13066_, b -> b instanceof StandingSignBlock);
            this.addMatching((Tag.Named<Block>)BlockTags.f_13067_, b -> b instanceof WallSignBlock);
            this.m_126548_(BlockTags.f_13042_).m_126584_((Object[])new Block[]{SkiesBlocks.warding_pearl, SkiesBlocks.wall_warding_pearl});
            this.m_126548_(BlockTags.f_13090_).m_126584_((Object[])new Block[]{SkiesBlocks.bluebright_planks, SkiesBlocks.starlit_planks, SkiesBlocks.frostbright_planks, SkiesBlocks.lunar_planks, SkiesBlocks.dusk_planks, SkiesBlocks.maple_planks, SkiesBlocks.cherry_planks});
            this.m_126548_(BlockTags.f_13082_).addTags(new Tag.Named[]{SkiesBlockTags.LADDERS, SkiesBlockTags.VINES});
            this.m_126548_(BlockTags.f_13079_).addTags(new Tag.Named[]{SkiesBlockTags.PYROPE_BLOCKS, SkiesBlockTags.DIOPSIDE_BLOCKS, SkiesBlockTags.AQUITE_BLOCKS, SkiesBlockTags.CHAROITE_BLOCKS, SkiesBlockTags.HORIZONITE_BLOCKS, SkiesBlockTags.FALSITE_BLOCKS, SkiesBlockTags.VENTIUM_BLOCKS});
            this.m_126548_(BlockTags.f_144274_).m_126584_((Object[])new Block[]{SkiesBlocks.turquoise_grass_block, SkiesBlocks.lunar_grass_block, SkiesBlocks.turquoise_dirt, SkiesBlocks.lunar_dirt, SkiesBlocks.coarse_turquoise_dirt, SkiesBlocks.coarse_lunar_dirt, SkiesBlocks.turquoise_cherry_grass_block, SkiesBlocks.lunar_cherry_grass_block});
            this.m_126548_(BlockTags.f_13081_).m_126582_((Object)SkiesBlocks.moonstone);
            this.m_126548_(BlockTags.f_13029_).m_126584_((Object[])new Block[]{SkiesBlocks.crystal_sand, SkiesBlocks.midnight_sand});
            this.m_126548_(BlockTags.f_144263_).m_126584_((Object[])new Block[]{SkiesBlocks.everbright_emerald_ore, SkiesBlocks.everdawn_emerald_ore});
            this.m_126548_(BlockTags.f_144276_).m_126580_(SkiesBlockTags.STONES);
            Set<Material> pickaxeMaterials = Set.of(Material.f_76278_, Material.f_76279_);
            this.addMatching((Tag.Named<Block>)BlockTags.f_144282_, b -> pickaxeMaterials.contains(b.m_49966_().m_60767_()));
            Set<Material> axeMaterials = Set.of(Material.f_76320_, Material.f_76321_, Material.f_76300_, Material.f_76302_, Material.f_76271_, Material.f_76285_);
            this.addMatching((Tag.Named<Block>)BlockTags.f_144280_, b -> axeMaterials.contains(b.m_49966_().m_60767_()));
            Set<Material> shovelMaterials = Set.of(Material.f_76314_, Material.f_76317_, Material.f_76315_);
            this.addMatching((Tag.Named<Block>)BlockTags.f_144283_, b -> shovelMaterials.contains(b.m_49966_().m_60767_()));
            this.addMatching((Tag.Named<Block>)BlockTags.f_144281_, b -> b.m_49966_().m_60767_().equals(Material.f_76274_));
            this.m_126548_(BlockTags.f_144282_).m_126584_((Object[])new Block[]{SkiesBlocks.moonstone_crystal, SkiesBlocks.sunstone_crystal, SkiesBlocks.turquoise_stone_button, SkiesBlocks.lunar_stone_button, SkiesBlocks.crystallized_button, SkiesBlocks.food_prep_table});
            this.m_126548_(BlockTags.f_144280_).remove((Object)SkiesBlocks.crystallized_log);
            this.m_126548_(BlockTags.f_144281_).m_126584_((Object[])new Block[]{SkiesBlocks.sea_moss, SkiesBlocks.sea_moss_block, SkiesBlocks.sea_moss_carpet});
            this.m_126548_(BlockTags.f_144286_).addTags(new Tag.Named[]{SkiesBlockTags.PYROPE_ORES, SkiesBlockTags.PYROPE_BLOCKS, SkiesBlockTags.AQUITE_ORES, SkiesBlockTags.AQUITE_BLOCKS, SkiesBlockTags.VENTIUM_ORES, SkiesBlockTags.VENTIUM_BLOCKS, SkiesBlockTags.FALSITE_ORES, SkiesBlockTags.FALSITE_BLOCKS, SkiesBlockTags.HORIZONITE_BLOCKS, SkiesBlockTags.HORIZONITE_ORES}).m_126584_((Object[])new Block[]{SkiesBlocks.raw_ventium_block, SkiesBlocks.raw_falsite_block, SkiesBlocks.raw_horizonite_block, SkiesBlocks.raw_aquite_block});
            this.m_126548_(BlockTags.f_144285_).addTags(new Tag.Named[]{SkiesBlockTags.DIOPSIDE_BLOCKS, SkiesBlockTags.DIOPSIDE_ORES, SkiesBlockTags.CHAROITE_BLOCKS, SkiesBlockTags.CHAROITE_ORES}).m_126584_((Object[])new Block[]{SkiesBlocks.everbright_emerald_ore, SkiesBlocks.everdawn_emerald_ore, SkiesBlocks.raw_charoite_block});
        }

        private void forge() {
            this.addMatching((Tag.Named<Block>)Tags.Blocks.CHESTS_WOODEN, b -> b instanceof ChestBlock && b.m_49966_().m_60767_().equals(Material.f_76320_));
            this.addMatching((Tag.Named<Block>)Tags.Blocks.FENCE_GATES_WOODEN, b -> b instanceof FenceGateBlock && b.m_49966_().m_60767_().equals(Material.f_76320_));
            this.m_126548_((Tag.Named)Tags.Blocks.COBBLESTONE).addTags(new Tag.Named[]{SkiesBlockTags.COBBLESTONES});
            this.m_126548_((Tag.Named)Tags.Blocks.STONE).addTags(new Tag.Named[]{SkiesBlockTags.STONES});
            this.m_126548_((Tag.Named)Tags.Blocks.STAINED_GLASS).m_126584_((Object[])new Block[]{SkiesBlocks.crystal_glass, SkiesBlocks.midnight_glass});
            this.m_126548_((Tag.Named)Tags.Blocks.GLASS_SILICA).m_126584_((Object[])new Block[]{SkiesBlocks.crystal_glass, SkiesBlocks.midnight_glass});
            this.m_126548_((Tag.Named)Tags.Blocks.STAINED_GLASS_PANES).m_126584_((Object[])new Block[]{SkiesBlocks.crystal_glass_pane, SkiesBlocks.midnight_glass_pane});
            this.m_126548_((Tag.Named)Tags.Blocks.ORE_RATES_SPARSE).m_126584_((Object[])new Block[]{SkiesBlocks.everdawn_moonstone_ore, SkiesBlocks.everbright_moonstone_ore});
            this.m_126548_((Tag.Named)Tags.Blocks.ORE_RATES_SINGULAR).m_126584_((Object[])new Block[]{SkiesBlocks.everdawn_emerald_ore, SkiesBlocks.everbright_emerald_ore, SkiesBlocks.everdawn_pyrope_ore, SkiesBlocks.everbright_pyrope_ore, SkiesBlocks.everdawn_diopside_ore, SkiesBlocks.everbright_diopside_ore, SkiesBlocks.everdawn_aquite_ore, SkiesBlocks.everbright_aquite_ore, SkiesBlocks.everdawn_charoite_ore, SkiesBlocks.everbright_charoite_ore, SkiesBlocks.horizonite_ore, SkiesBlocks.falsite_ore, SkiesBlocks.ventium_ore});
            this.m_126548_((Tag.Named)Tags.Blocks.ORES).addTags(new Tag.Named[]{SkiesBlockTags.MOONSTONE_ORES, SkiesBlockTags.PYROPE_ORES, SkiesBlockTags.DIOPSIDE_ORES, SkiesBlockTags.AQUITE_ORES, SkiesBlockTags.CHAROITE_ORES, SkiesBlockTags.HORIZONITE_ORES, SkiesBlockTags.FALSITE_ORES, SkiesBlockTags.VENTIUM_ORES});
            this.m_126548_((Tag.Named)Tags.Blocks.ORES_EMERALD).m_126584_((Object[])new Block[]{SkiesBlocks.everbright_emerald_ore, SkiesBlocks.everdawn_emerald_ore});
            this.m_126548_((Tag.Named)Tags.Blocks.SANDSTONE).m_126584_((Object[])new Block[]{SkiesBlocks.crystal_sandstone, SkiesBlocks.chiseled_crystal_sandstone, SkiesBlocks.cut_crystal_sandstone, SkiesBlocks.smooth_crystal_sandstone, SkiesBlocks.midnight_sandstone, SkiesBlocks.chiseled_midnight_sandstone, SkiesBlocks.cut_midnight_sandstone});
            this.m_126548_((Tag.Named)Tags.Blocks.STORAGE_BLOCKS).addTags(new Tag.Named[]{SkiesBlockTags.MOONSTONE_BLOCKS, SkiesBlockTags.PYROPE_BLOCKS, SkiesBlockTags.DIOPSIDE_BLOCKS, SkiesBlockTags.AQUITE_BLOCKS, SkiesBlockTags.RAW_AQUITE_BLOCKS, SkiesBlockTags.CHAROITE_BLOCKS, SkiesBlockTags.RAW_CHAROITE_BLOCKS, SkiesBlockTags.HORIZONITE_BLOCKS, SkiesBlockTags.RAW_HORIZONITE_BLOCKS, SkiesBlockTags.FALSITE_BLOCKS, SkiesBlockTags.RAW_FALSITE_BLOCKS, SkiesBlockTags.VENTIUM_BLOCKS, SkiesBlockTags.RAW_VENTIUM_BLOCKS});
            this.m_126548_((Tag.Named)Tags.Blocks.SAND).m_126584_((Object[])new Block[]{SkiesBlocks.crystal_sand, SkiesBlocks.midnight_sand});
        }

        public String m_6055_() {
            return "Blue Skies Block Tags";
        }

        private Stream<Block> getMatching(Function<Block, Boolean> condition) {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block.getRegistryName().m_135827_().equals("blue_skies") && (Boolean)condition.apply((Block)block) != false);
        }

        private void addMatching(Tag.Named<Block> blockTag, Function<Block, Boolean> condition) {
            this.getMatching(condition).forEach(arg_0 -> ((TagsProvider.TagAppender)this.m_126548_(blockTag)).m_126582_(arg_0));
        }
    }
}

