/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.objects.alchemy;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.managers.SkiesDataManager;
import com.legacy.blue_skies.data.objects.alchemy.AlchemyRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class TransmuteRecipe
extends AlchemyRecipe {
    private final List<ResourceLocation> items;
    private final List<Tag<Item>> itemTags;
    private final List<ResourceLocation> resultBlacklist;
    @Nullable
    protected List<Item> cachedResults = null;
    private static final String ITEMS_KEY = "items";
    private static final String TAGS_KEY = "tags";
    private static final String BLACKLIST_KEY = "blacklist";

    public TransmuteRecipe(List<ResourceLocation> items, List<Tag<Item>> itemTags, List<ResourceLocation> resultBlacklist, boolean shouldOverride) {
        super(shouldOverride, BlueSkies.locate("transmute"));
        this.items = items;
        this.itemTags = itemTags;
        this.resultBlacklist = resultBlacklist;
    }

    @Override
    public void mergeRecipe(AlchemyRecipe recipe) {
        if (recipe instanceof TransmuteRecipe) {
            TransmuteRecipe transmute = (TransmuteRecipe)recipe;
            this.items.addAll(transmute.items);
            this.itemTags.addAll(transmute.itemTags);
            this.resultBlacklist.addAll(transmute.resultBlacklist);
        }
    }

    @Override
    public List<Item> getResults(Item inputA, Item inputB) {
        List<Item> results = this.getResults();
        results.remove(inputA);
        results.remove(inputB);
        return results;
    }

    @Override
    public List<Item> getResults() {
        if (this.cachedResults == null) {
            List<Item> results = this.toItemList(this.items);
            if (!this.itemTags.isEmpty()) {
                this.itemTags.forEach(tag -> results.addAll(tag.m_6497_()));
            }
            if (!this.resultBlacklist.isEmpty()) {
                results.removeAll(this.toItemList(this.resultBlacklist));
            }
            ArrayList<Item> noDuplicates = new ArrayList<Item>();
            int size = results.size();
            for (int i = 0; i < size; ++i) {
                Item item = results.get(i);
                if (noDuplicates.contains(item)) continue;
                noDuplicates.add(item);
            }
            this.cachedResults = noDuplicates;
        }
        return new ArrayList<Item>(this.cachedResults);
    }

    @Override
    public List<ImmutableTriple<ItemStack, ItemStack, ItemStack>> getAllCombinations() {
        ArrayList<ImmutableTriple<ItemStack, ItemStack, ItemStack>> data = new ArrayList<ImmutableTriple<ItemStack, ItemStack, ItemStack>>();
        for (Item input : this.getResults()) {
            for (Item output : this.getResults(input, Items.f_41852_)) {
                data.add((ImmutableTriple<ItemStack, ItemStack, ItemStack>)ImmutableTriple.of((Object)new ItemStack((ItemLike)input), (Object)ItemStack.f_41583_, (Object)new ItemStack((ItemLike)output)));
            }
        }
        return data;
    }

    @Override
    public boolean matches(Item itemA, Item itemB) {
        return (itemB == Items.f_41852_ || itemB == null) && this.getResults().contains(itemA);
    }

    @Override
    public TransmuteRecipe fromJson(JsonObject json) {
        ArrayList<ResourceLocation> items = new ArrayList<ResourceLocation>();
        GsonHelper.m_13832_((JsonObject)json, (String)ITEMS_KEY, (JsonArray)new JsonArray()).forEach(element -> items.add(new ResourceLocation(element.getAsString())));
        ArrayList<Tag<Item>> tags = new ArrayList<Tag<Item>>();
        GsonHelper.m_13832_((JsonObject)json, (String)TAGS_KEY, (JsonArray)new JsonArray()).forEach(element -> {
            ResourceLocation name = new ResourceLocation(element.getAsString());
            Tag tag = SerializationTags.m_13199_().m_144458_(Registry.f_122904_, name, tagLocation -> new IllegalStateException("Unknown tag: " + tagLocation));
            if (tag != null) {
                tags.add(tag);
            } else {
                SkiesDataManager.LOGGER.warn("The tag {} was not found.", (Object)name.toString());
            }
        });
        ArrayList<ResourceLocation> resultBlacklist = new ArrayList<ResourceLocation>();
        GsonHelper.m_13832_((JsonObject)json, (String)BLACKLIST_KEY, (JsonArray)new JsonArray()).forEach(element -> resultBlacklist.add(new ResourceLocation(element.getAsString())));
        return new TransmuteRecipe(items, tags, resultBlacklist, GsonHelper.m_13855_((JsonObject)json, (String)"override", (boolean)false));
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type.toString());
        json.addProperty("override", Boolean.valueOf(this.shouldOverride));
        if (!this.items.isEmpty()) {
            JsonArray itemNames = new JsonArray();
            this.items.stream().sorted((a, b) -> a.compareTo(b)).forEach(i -> itemNames.add(i.toString()));
            json.add(ITEMS_KEY, (JsonElement)itemNames);
        }
        if (!this.itemTags.isEmpty()) {
            JsonArray tagNames = new JsonArray();
            Function<Tag, String> getName = t -> SerializationTags.m_13199_().m_144454_(Registry.f_122904_, t, () -> new IllegalStateException("Unknown tag: " + t)).toString();
            this.itemTags.stream().sorted((a, b) -> ((String)getName.apply((Tag)a)).compareTo((String)getName.apply((Tag)b))).forEach(t -> tagNames.add((String)getName.apply((Tag)t)));
            json.add(TAGS_KEY, (JsonElement)tagNames);
        }
        if (!this.resultBlacklist.isEmpty()) {
            JsonArray blacklistNames = new JsonArray();
            this.resultBlacklist.stream().sorted((a, b) -> a.compareTo(b)).forEach(i -> blacklistNames.add(i.toString()));
            json.add(BLACKLIST_KEY, (JsonElement)blacklistNames);
        }
        return json;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final String name;
        private boolean shouldOverride = false;
        private List<ResourceLocation> items = new ArrayList<ResourceLocation>();
        private List<Tag<Item>> itemTags = new ArrayList<Tag<Item>>();
        private List<ResourceLocation> resultBlacklist = new ArrayList<ResourceLocation>();

        private Builder(String name) {
            this.name = name;
        }

        public Builder shouldOverride() {
            this.shouldOverride = true;
            return this;
        }

        public Builder items(ItemLike ... items) {
            for (ItemLike item : items) {
                this.items.add(item.m_5456_().getRegistryName());
            }
            return this;
        }

        public Builder items(List<ItemLike> items) {
            return this.items(items.toArray(new ItemLike[0]));
        }

        public Builder withTag(Tag<Item> itemTag) {
            this.itemTags.add(itemTag);
            return this;
        }

        public Builder resultBlacklist(ItemLike ... items) {
            for (ItemLike item : items) {
                this.resultBlacklist.add(item.m_5456_().getRegistryName());
            }
            return this;
        }

        public Builder resultBlacklist(String modID, String ... itemNames) {
            for (String itemName : itemNames) {
                this.resultBlacklist.add(new ResourceLocation(modID, itemName));
            }
            return this;
        }

        public String getName() {
            return this.name;
        }

        public TransmuteRecipe build() {
            if (this.items.isEmpty() && this.itemTags.isEmpty()) {
                throw new IllegalStateException("Transmute recipe with name " + this.name + " had no items");
            }
            return new TransmuteRecipe(this.items, this.itemTags, this.resultBlacklist, this.shouldOverride);
        }
    }
}

