/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.loot_functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.legacy.blue_skies.items.arcs.IArcItem;
import com.legacy.blue_skies.items.util.IRarityItem;
import com.legacy.blue_skies.registries.SkiesLootFunctions;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetArcRarity
extends LootItemConditionalFunction {
    private final IRarityItem.SkiesRarity bagRarity;

    private SetArcRarity(LootItemCondition[] condition, IRarityItem.SkiesRarity bagRarity) {
        super(condition);
        this.bagRarity = bagRarity;
    }

    public LootItemFunctionType m_7162_() {
        return SkiesLootFunctions.SET_ARC_RARITY;
    }

    public ItemStack m_7372_(ItemStack stack, LootContext context) {
        if (stack.m_41720_() instanceof IArcItem) {
            IArcItem arc = (IArcItem)stack.m_41720_();
            int level = this.bagRarity.getId();
            if (context.m_78933_().nextFloat() < 0.3333f) {
                level = context.m_78933_().nextFloat() < 0.6666f ? --level : ++level;
            }
            arc.setLevel(stack, level);
        }
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> setRarity(IRarityItem.SkiesRarity bagRarity) {
        return SetArcRarity.m_80683_(condition -> new SetArcRarity((LootItemCondition[])condition, bagRarity));
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SetArcRarity> {
        public void serialize(JsonObject json, SetArcRarity function, JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)function, context);
            json.addProperty("rarity", (Number)function.bagRarity.getId());
        }

        public SetArcRarity deserialize(JsonObject json, JsonDeserializationContext context, LootItemCondition[] condition) {
            IRarityItem.SkiesRarity rarity = IRarityItem.SkiesRarity.getFromId(GsonHelper.m_13927_((JsonObject)json, (String)"rarity"));
            return new SetArcRarity(condition, rarity);
        }
    }
}

