/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.init;

import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.blocks.misc.TrophyBlock;
import com.legacy.blue_skies.items.tools.AstrolabeItem;
import com.legacy.blue_skies.items.tools.weapons.InfusedArcSwordItem;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class SkiesItemModelPredicates {
    public static void init() {
        ImmutableSet spears = ImmutableSet.of((Object)SkiesItems.bluebright_spear, (Object)SkiesItems.starlit_spear, (Object)SkiesItems.frostbright_spear, (Object)SkiesItems.lunar_spear, (Object)SkiesItems.dusk_spear, (Object)SkiesItems.maple_spear, (Object[])new Item[]{SkiesItems.soulbound_spear});
        spears.forEach(spear -> SkiesItemModelPredicates.createActivePredicate(spear, "throwing"));
        SkiesItemModelPredicates.createActivePredicate(SkiesItems.moonstone_shield, "blocking");
        SkiesItemModelPredicates.createActivePredicate(SkiesItems.spike_shield, "blocking");
        SkiesItemModelPredicates.createActivePredicate(SkiesItems.venom_sac, "pulling");
        SkiesItemModelPredicates.createUseDurationPredicate(SkiesItems.venom_sac, "pull", 20);
        SkiesItemModelPredicates.createChargedPredicate(SkiesItems.crushing_hammer, "charged", 20);
        ImmutableSet arcs = ImmutableSet.of((Object)SkiesItems.ethereal_arc, (Object)SkiesItems.dusk_arc, (Object)SkiesItems.nature_arc, (Object)SkiesItems.poison_arc, (Object)SkiesItems.aquatic_arc, (Object)SkiesItems.life_arc, (Object[])new Item[]{SkiesItems.runic_arc});
        arcs.forEach(arc -> SkiesItemModelPredicates.createCooldownPredicate(arc, "drained"));
        SkiesItemModelPredicates.createInfusedArcSwordPredicate(SkiesItems.infused_arc_sword, "drained");
        SkiesItemModelPredicates.createTrophyPredicate(new Block[]{SkiesBlocks.summoner_trophy, SkiesBlocks.alchemist_trophy, SkiesBlocks.starlit_crusher_trophy, SkiesBlocks.arachnarch_trophy});
        SkiesItemModelPredicates.createAstrolabePredicate(SkiesItems.astrolabe, "can_use");
    }

    private static void createChargedPredicate(Item item, String predicateName, int maxUseTime) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(predicateName), (stack, world, entity, num) -> entity != null && entity.m_21211_() == stack && entity.m_21212_() <= stack.m_41779_() - maxUseTime ? 1.0f : 0.0f);
    }

    private static void createUseDurationPredicate(Item item, String predicateName, int maxUseTime) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(predicateName), (stack, world, entity, num) -> entity != null && entity.m_21211_() == stack ? (float)(stack.m_41779_() - entity.m_21212_()) / (float)maxUseTime : 0.0f);
    }

    private static void createActivePredicate(Item item, String predicateName) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(predicateName), (stack, world, entity, num) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
    }

    private static void createCooldownPredicate(Item item, String predicateName) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(predicateName), (stack, world, entity, num) -> entity != null && entity instanceof Player && ((Player)entity).m_36335_().m_41519_(stack.m_41720_()) ? 1.0f : 0.0f);
    }

    private static void createInfusedArcSwordPredicate(Item item, String predicateName) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(predicateName), (stack, world, entity, num) -> stack.m_41720_() instanceof InfusedArcSwordItem && InfusedArcSwordItem.getInfusedCooldown(stack) > 0 ? 1.0f : 0.0f);
    }

    private static void createTrophyPredicate(Block ... blocks) {
        for (Block b : blocks) {
            ItemProperties.register((Item)b.m_5456_(), (ResourceLocation)new ResourceLocation("tier"), (stack, world, entity, num) -> {
                CompoundTag tag = stack.m_41783_();
                if (tag != null) {
                    CompoundTag states = tag.m_128469_("BlockStateTag");
                    String tier = states.m_128461_("tier");
                    return TrophyBlock.Tier.from(tier).ordinal();
                }
                return 0.0f;
            });
        }
    }

    private static void createAstrolabePredicate(Item item, String predicateName) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(predicateName), (stack, world, entity, num) -> AstrolabeItem.getTeleportCooldown(stack) == 0 && AstrolabeItem.isWithinDistance(stack, entity, (Level)world) ? 1.0f : 0.0f);
    }
}

