/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.gui.BiomeSearchEntry;
import com.chaosthedude.naturescompass.gui.BiomeSearchList;
import com.chaosthedude.naturescompass.gui.TransparentButton;
import com.chaosthedude.naturescompass.gui.TransparentTextField;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.network.CompassSearchPacket;
import com.chaosthedude.naturescompass.network.TeleportPacket;
import com.chaosthedude.naturescompass.sorting.ISorting;
import com.chaosthedude.naturescompass.sorting.NameSorting;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.chaosthedude.naturescompass.util.CompassState;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NaturesCompassScreen
extends Screen {
    public Level level;
    private Player player;
    private List<Biome> allowedBiomes;
    private List<Biome> biomesMatchingSearch;
    private ItemStack stack;
    private NaturesCompassItem natureCompass;
    private Button startSearchButton;
    private Button teleportButton;
    private Button infoButton;
    private Button cancelButton;
    private Button sortByButton;
    private TransparentTextField searchTextField;
    private BiomeSearchList selectionList;
    private ISorting<?> sortingCategory;

    public NaturesCompassScreen(Level level, Player player, ItemStack stack, NaturesCompassItem natureCompass, List<ResourceLocation> allowedBiomes) {
        super((Component)new TranslatableComponent("string.naturescompass.selectBiome"));
        this.level = level;
        this.player = player;
        this.stack = stack;
        this.natureCompass = natureCompass;
        this.allowedBiomes = new ArrayList<Biome>();
        this.loadAllowedBiomes(allowedBiomes);
        this.sortingCategory = new NameSorting();
        this.biomesMatchingSearch = new ArrayList<Biome>(this.allowedBiomes);
    }

    public boolean m_6050_(double scroll1, double scroll2, double scroll3) {
        return this.selectionList.m_6050_(scroll1, scroll2, scroll3);
    }

    protected void m_7856_() {
        this.f_96541_.f_91068_.m_90926_(true);
        this.setupWidgets();
    }

    public void m_96624_() {
        this.searchTextField.m_94120_();
        boolean bl = this.teleportButton.f_93623_ = this.natureCompass.getState(this.stack) == CompassState.FOUND;
        if (this.allowedBiomes.size() != NaturesCompass.allowedBiomes.size()) {
            this.teleportButton.f_93624_ = NaturesCompass.canTeleport;
            this.m_169411_((GuiEventListener)this.selectionList);
            this.loadAllowedBiomes(NaturesCompass.allowedBiomes);
            this.biomesMatchingSearch = new ArrayList<Biome>(this.allowedBiomes);
            this.selectionList = new BiomeSearchList(this, this.f_96541_, this.f_96543_ + 110, this.f_96544_, 40, this.f_96544_, 45);
            this.m_142416_((GuiEventListener)this.selectionList);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        NaturesCompassScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"string.naturescompass.selectBiome", (Object[])new Object[0]), (int)65, (int)15, (int)0xFFFFFF);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean ret = super.m_7933_(keyCode, scanCode, modifiers);
        if (this.searchTextField.m_93696_()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        boolean ret = super.m_5534_(typedChar, keyCode);
        if (this.searchTextField.m_93696_()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public void m_7379_() {
        super.m_7379_();
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public void selectBiome(BiomeSearchEntry entry) {
        boolean enable;
        this.startSearchButton.f_93623_ = enable = entry != null;
        this.infoButton.f_93623_ = enable;
    }

    public void searchForBiome(Biome biome) {
        if (BiomeUtils.getKeyForBiome(this.level, biome).isPresent()) {
            NaturesCompass.network.sendToServer((Object)new CompassSearchPacket(BiomeUtils.getKeyForBiome(this.level, biome).get(), this.player.m_142538_()));
        }
        this.f_96541_.m_91152_(null);
    }

    public void teleport() {
        NaturesCompass.network.sendToServer((Object)new TeleportPacket());
        this.f_96541_.m_91152_(null);
    }

    public ISorting<?> getSortingCategory() {
        return this.sortingCategory;
    }

    public void processSearchTerm() {
        this.biomesMatchingSearch = new ArrayList<Biome>();
        for (Biome biome : this.allowedBiomes) {
            if (!BiomeUtils.getBiomeNameForDisplay(this.level, biome).toLowerCase().contains(this.searchTextField.m_94155_().toLowerCase())) continue;
            this.biomesMatchingSearch.add(biome);
        }
        this.selectionList.refreshList();
    }

    public List<Biome> sortBiomes() {
        List<Biome> biomes = this.biomesMatchingSearch;
        Collections.sort(biomes, new NameSorting());
        Collections.sort(biomes, this.sortingCategory);
        return biomes;
    }

    private void setupWidgets() {
        this.m_169413_();
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(10, this.f_96544_ - 30, 110, 20, (Component)new TranslatableComponent("gui.cancel"), onPress -> this.f_96541_.m_91152_(null)));
        this.sortByButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(10, 90, 110, 20, (Component)new TextComponent(I18n.m_118938_((String)"string.naturescompass.sortBy", (Object[])new Object[0]) + ": " + this.sortingCategory.getLocalizedName()), onPress -> {
            this.sortingCategory = this.sortingCategory.next();
            this.sortByButton.m_93666_((Component)new TextComponent(I18n.m_118938_((String)"string.naturescompass.sortBy", (Object[])new Object[0]) + ": " + this.sortingCategory.getLocalizedName()));
            this.selectionList.refreshList();
        }));
        this.infoButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(10, 65, 110, 20, (Component)new TranslatableComponent("string.naturescompass.info"), onPress -> {
            if (this.selectionList.hasSelection()) {
                ((BiomeSearchEntry)this.selectionList.m_93511_()).viewInfo();
            }
        }));
        this.startSearchButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(10, 40, 110, 20, (Component)new TranslatableComponent("string.naturescompass.startSearch"), onPress -> {
            if (this.selectionList.hasSelection()) {
                ((BiomeSearchEntry)this.selectionList.m_93511_()).searchForBiome();
            }
        }));
        this.teleportButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(this.f_96543_ - 120, 10, 110, 20, (Component)new TranslatableComponent("string.naturescompass.teleport"), onPress -> this.teleport()));
        this.startSearchButton.f_93623_ = false;
        this.infoButton.f_93623_ = false;
        this.teleportButton.f_93624_ = NaturesCompass.canTeleport;
        this.searchTextField = (TransparentTextField)this.m_142416_((GuiEventListener)new TransparentTextField(this.f_96547_, 130, 10, 140, 20, (Component)new TranslatableComponent("string.naturescompass.search")));
        if (this.selectionList == null) {
            this.selectionList = new BiomeSearchList(this, this.f_96541_, this.f_96543_ + 110, this.f_96544_, 40, this.f_96544_, 45);
        }
        this.m_142416_((GuiEventListener)this.selectionList);
    }

    private void loadAllowedBiomes(List<ResourceLocation> allowedBiomeKeys) {
        this.allowedBiomes = new ArrayList<Biome>();
        for (ResourceLocation biomeKey : allowedBiomeKeys) {
            Optional<Biome> optionalBiome = BiomeUtils.getBiomeForKey(this.level, biomeKey);
            if (!optionalBiome.isPresent()) continue;
            this.allowedBiomes.add(optionalBiome.get());
        }
    }
}

