/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.gui.NaturesCompassScreen;
import com.chaosthedude.naturescompass.gui.TransparentButton;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BiomeInfoScreen
extends Screen {
    private NaturesCompassScreen parentScreen;
    private Biome biome;
    private Button searchButton;
    private Button backButton;
    private String source;
    private String category;
    private String precipitation;
    private String temperature;
    private String rainfall;
    private String highHumidity;

    public BiomeInfoScreen(NaturesCompassScreen parentScreen, Biome biome) {
        super((Component)new TranslatableComponent(BiomeUtils.getBiomeNameForDisplay(parentScreen.level, biome)));
        this.parentScreen = parentScreen;
        this.biome = biome;
        this.source = BiomeUtils.getBiomeSource(parentScreen.level, biome);
        this.category = BiomeUtils.getBiomeCategoryName(parentScreen.level, biome);
        this.precipitation = biome.m_47530_() == Biome.Precipitation.SNOW ? I18n.m_118938_((String)"string.naturescompass.snow", (Object[])new Object[0]) : (biome.m_47530_() == Biome.Precipitation.RAIN ? I18n.m_118938_((String)"string.naturescompass.rain", (Object[])new Object[0]) : I18n.m_118938_((String)"string.naturescompass.none", (Object[])new Object[0]));
        this.temperature = (double)biome.m_47554_() <= 0.5 ? I18n.m_118938_((String)"string.naturescompass.cold", (Object[])new Object[0]) : ((double)biome.m_47554_() <= 1.5 ? I18n.m_118938_((String)"string.naturescompass.medium", (Object[])new Object[0]) : I18n.m_118938_((String)"string.naturescompass.warm", (Object[])new Object[0]));
        this.rainfall = biome.m_47548_() <= 0.0f ? I18n.m_118938_((String)"string.naturescompass.none", (Object[])new Object[0]) : ((double)biome.m_47548_() < 0.2 ? I18n.m_118938_((String)"string.naturescompass.veryLow", (Object[])new Object[0]) : ((double)biome.m_47548_() < 0.3 ? I18n.m_118938_((String)"string.naturescompass.low", (Object[])new Object[0]) : ((double)biome.m_47548_() < 0.5 ? I18n.m_118938_((String)"string.naturescompass.average", (Object[])new Object[0]) : ((double)biome.m_47548_() < 0.85 ? I18n.m_118938_((String)"string.naturescompass.high", (Object[])new Object[0]) : I18n.m_118938_((String)"string.naturescompass.veryHigh", (Object[])new Object[0])))));
        this.highHumidity = biome.m_47533_() ? I18n.m_118938_((String)"gui.yes", (Object[])new Object[0]) : I18n.m_118938_((String)"gui.no", (Object[])new Object[0]);
    }

    public void m_7856_() {
        this.setupWidgets();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        this.f_96547_.m_92889_(poseStack, (Component)new TextComponent(BiomeUtils.getBiomeNameForDisplay(this.parentScreen.level, this.biome)), (float)(this.f_96543_ / 2 - this.f_96547_.m_92895_(BiomeUtils.getBiomeNameForDisplay(this.parentScreen.level, this.biome)) / 2), 20.0f, 0xFFFFFF);
        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("string.naturescompass.source"), (float)(this.f_96543_ / 2 - 100), 40.0f, 0xFFFFFF);
        this.f_96547_.m_92889_(poseStack, (Component)new TextComponent(this.source), (float)(this.f_96543_ / 2 - 100), 50.0f, 0x808080);
        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("string.naturescompass.category"), (float)(this.f_96543_ / 2 + 40), 40.0f, 0xFFFFFF);
        this.f_96547_.m_92889_(poseStack, (Component)new TextComponent(this.category), (float)(this.f_96543_ / 2 + 40), 50.0f, 0x808080);
        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("string.naturescompass.precipitation"), (float)(this.f_96543_ / 2 - 100), 70.0f, 0xFFFFFF);
        this.f_96547_.m_92889_(poseStack, (Component)new TextComponent(this.precipitation), (float)(this.f_96543_ / 2 - 100), 80.0f, 0x808080);
        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("string.naturescompass.rainfall"), (float)(this.f_96543_ / 2 + 40), 70.0f, 0xFFFFFF);
        this.f_96547_.m_92889_(poseStack, (Component)new TextComponent(this.rainfall), (float)(this.f_96543_ / 2 + 40), 80.0f, 0x808080);
        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("string.naturescompass.temperature"), (float)(this.f_96543_ / 2 - 100), 100.0f, 0xFFFFFF);
        this.f_96547_.m_92889_(poseStack, (Component)new TextComponent(this.temperature), (float)(this.f_96543_ / 2 - 100), 110.0f, 0x808080);
        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("string.naturescompass.highHumidity"), (float)(this.f_96543_ / 2 + 40), 100.0f, 0xFFFFFF);
        this.f_96547_.m_92889_(poseStack, (Component)new TextComponent(this.highHumidity), (float)(this.f_96543_ / 2 + 40), 110.0f, 0x808080);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    private void setupWidgets() {
        this.m_169413_();
        this.backButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(10, this.f_96544_ - 30, 110, 20, (Component)new TranslatableComponent("string.naturescompass.back"), onPress -> this.f_96541_.m_91152_((Screen)this.parentScreen)));
        this.searchButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(this.f_96543_ - 120, this.f_96544_ - 30, 110, 20, (Component)new TranslatableComponent("string.naturescompass.search"), onPress -> this.parentScreen.searchForBiome(this.biome)));
    }
}

