/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.utils.value.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIBasedRecipeLayout;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeLayout;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedDisplay;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.LazyLoadedValue;
import org.jetbrains.annotations.Nullable;

public class JEIWrappedCategory<T>
implements DisplayCategory<JEIWrappedDisplay<T>> {
    private final IRecipeCategory<T> backingCategory;
    public final LazyLoadedValue<IDrawable> background;
    private final CategoryIdentifier<? extends JEIWrappedDisplay<T>> identifier;

    public JEIWrappedCategory(IRecipeCategory<T> backingCategory) {
        this.backingCategory = backingCategory;
        this.background = new LazyLoadedValue(backingCategory::getBackground);
        this.identifier = JEIPluginDetector.categoryId(backingCategory.getUid()).cast();
    }

    public Class<? extends T> getRecipeClass() {
        return this.backingCategory.getRecipeClass();
    }

    public boolean handlesRecipe(T recipe) {
        return this.backingCategory.isHandled(recipe);
    }

    @Override
    public Renderer getIcon() {
        IDrawable icon = this.backingCategory.getIcon();
        if (icon != null) {
            return JEIPluginDetector.unwrapRenderer(icon);
        }
        List<EntryIngredient> workstations = CategoryRegistry.getInstance().get(this.getCategoryIdentifier()).getWorkstations();
        if (!workstations.isEmpty()) {
            return Widgets.createSlot(new Point(0, 0)).entries(workstations.get(0)).disableBackground().disableHighlight().disableTooltips();
        }
        FormattedCharSequence title = this.getTitle().m_7532_();
        final FormattedCharSequence titleTrimmed = sink -> title.m_13731_((index, style, codepoint) -> {
            if (index == 0 || index == 1) {
                sink.m_6411_(index, style, codepoint);
                return true;
            }
            return false;
        });
        return new Renderer(){

            @Override
            public void render(PoseStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                Font font = Minecraft.m_91087_().f_91062_;
                font.m_92744_(matrices, titleTrimmed, (float)bounds.getCenterX() - (float)font.m_92724_(titleTrimmed) / 2.0f, (float)bounds.getCenterY() - 4.5f, 0xFFFFFF);
            }

            @Override
            public int getZ() {
                return 0;
            }

            @Override
            public void setZ(int z) {
            }
        };
    }

    @Override
    public Component getTitle() {
        return this.backingCategory.getTitle();
    }

    @Override
    public int getDisplayWidth(JEIWrappedDisplay<T> display) {
        return ((IDrawable)this.background.m_13971_()).getWidth() + 8;
    }

    @Override
    public CategoryIdentifier<? extends JEIWrappedDisplay<T>> getCategoryIdentifier() {
        return this.identifier;
    }

    @Override
    public int getDisplayHeight() {
        return ((IDrawable)this.background.m_13971_()).getHeight() + 8;
    }

    public IRecipeCategory<T> getBackingCategory() {
        return this.backingCategory;
    }

    public JEIRecipeLayout<T> createLayout(JEIWrappedDisplay<T> display, Value<IDrawable> background) {
        return JEIWrappedCategory.createLayout(this.getBackingCategory(), display.getBackingRecipe(), display.getIngredients(), background);
    }

    public static <T> JEIRecipeLayout<T> createLayout(IRecipeCategory<T> category, T recipe, IIngredients ingredients, Value<IDrawable> background) {
        JEIBasedRecipeLayout layout = new JEIBasedRecipeLayout(category, background);
        category.setRecipe(layout, recipe, ingredients);
        return layout;
    }

    @Override
    public List<Widget> setupDisplay(JEIWrappedDisplay<T> display, Rectangle bounds) {
        return JEIWrappedCategory.setupDisplay(this.getBackingCategory(), display.getBackingRecipe(), display.getIngredients(), bounds, this.background);
    }

    public static <T> List<Widget> setupDisplay(final IRecipeCategory<T> category, final T recipe, IIngredients ingredients, final Rectangle bounds, LazyLoadedValue<IDrawable> backgroundLazy) {
        JEIRecipeLayout<T> layout;
        final ArrayList<Widget> widgets = new ArrayList<Widget>();
        final IDrawable[] background = new IDrawable[]{(IDrawable)backgroundLazy.m_13971_()};
        try {
            layout = JEIWrappedCategory.createLayout(category, recipe, ingredients, new Value<IDrawable>(){

                public void accept(IDrawable iDrawable) {
                    background[0] = iDrawable;
                }

                public IDrawable get() {
                    return background[0];
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            widgets.add(Widgets.createRecipeBase(bounds).color(-65536));
            widgets.add(Widgets.createLabel(new Point(bounds.getCenterX(), bounds.getCenterY() - 8), (Component)new TextComponent("Failed to initiate JEI integration setRecipe")));
            widgets.add(Widgets.createLabel(new Point(bounds.getCenterX(), bounds.getCenterY() + 1), (Component)new TextComponent("Check console for error")));
            return widgets;
        }
        widgets.add(Widgets.createRecipeBase(bounds));
        widgets.add(Widgets.withTranslate(Widgets.wrapRenderer(bounds, JEIPluginDetector.unwrapRenderer(background[0])), 4.0, 4.0, 0.0));
        widgets.add(new WidgetWithBounds(){

            @Override
            public Rectangle getBounds() {
                return bounds;
            }

            public void m_6305_(PoseStack arg, int mouseX, int mouseY, float f) {
                arg.m_85836_();
                arg.m_85837_((double)(bounds.x + 4), (double)(bounds.y + 4), (double)this.getZ());
                category.draw(recipe, arg, mouseX - bounds.x, mouseY - bounds.y);
                arg.m_85849_();
                Point mouse = new Point(mouseX, mouseY);
                if (this.containsMouse(mouse)) {
                    for (Slot slot : Widgets.walk(widgets, listener -> listener instanceof Slot)) {
                        if (!slot.containsMouse(mouse) || !slot.isHighlightEnabled() || slot.getCurrentTooltip(mouse) == null) continue;
                        return;
                    }
                    Tooltip tooltip = this.getTooltip(mouse);
                    if (tooltip != null) {
                        tooltip.queue();
                    }
                }
            }

            @Override
            @Nullable
            public Tooltip getTooltip(Point mouse) {
                List<Component> strings = category.getTooltipStrings(recipe, mouse.x - bounds.x - 4, mouse.y - bounds.y - 4);
                if (strings.isEmpty()) {
                    return null;
                }
                return Tooltip.create(mouse, strings);
            }

            public List<? extends GuiEventListener> m_6702_() {
                return Collections.emptyList();
            }

            public boolean m_6375_(double d, double e, int i) {
                return category.handleClick(recipe, d - (double)bounds.x - 4.0, e - (double)bounds.y - 4.0, i) || super.m_6375_(d, e, i);
            }
        });
        layout.addTo(widgets, bounds);
        return widgets;
    }
}

