/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.utils.value.Value;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayCategoryView;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRenderer;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoProvider;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.transfer.info.MenuSerializationContext;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.ingredient.JEIGuiIngredientGroup;
import me.shedaniel.rei.jeicompat.transfer.JEIRecipeTransferData;
import me.shedaniel.rei.jeicompat.transfer.JEITransferMenuInfo;
import me.shedaniel.rei.jeicompat.wrap.JEIGuiHelper;
import me.shedaniel.rei.jeicompat.wrap.JEIJeiHelpers;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeLayout;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeTransferError;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeTransferHandlerHelper;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedCategory;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedDisplay;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappingRecipeLayout;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JEIRecipeTransferRegistration
implements IRecipeTransferRegistration {
    private final Consumer<Runnable> post;

    public JEIRecipeTransferRegistration(Consumer<Runnable> post) {
        this.post = post;
    }

    @Override
    @NotNull
    public IJeiHelpers getJeiHelpers() {
        return JEIJeiHelpers.INSTANCE;
    }

    @Override
    @NotNull
    public IRecipeTransferHandlerHelper getTransferHelper() {
        return JEIRecipeTransferHandlerHelper.INSTANCE;
    }

    @Override
    public <C extends AbstractContainerMenu> void addRecipeTransferHandler(final Class<C> containerClass, final ResourceLocation recipeCategoryUid, final int recipeSlotStart, final int recipeSlotCount, final int inventorySlotStart, final int inventorySlotCount) {
        this.addRecipeTransferHandler(new IRecipeTransferInfo<C, Object>(){

            @Override
            public Class<C> getContainerClass() {
                return containerClass;
            }

            @Override
            public Class<Object> getRecipeClass() {
                return Object.class;
            }

            @Override
            public ResourceLocation getRecipeCategoryUid() {
                return recipeCategoryUid;
            }

            @Override
            public boolean canHandle(C container, Object recipe) {
                return this.getContainerClass().isInstance(container);
            }

            @Override
            public List<Slot> getRecipeSlots(C container, Object recipe) {
                return IntStream.range(recipeSlotStart, recipeSlotStart + recipeSlotCount).mapToObj(arg_0 -> container.m_38853_(arg_0)).collect(Collectors.toList());
            }

            @Override
            public List<Slot> getInventorySlots(C container, Object recipe) {
                return IntStream.range(inventorySlotStart, inventorySlotStart + inventorySlotCount).mapToObj(arg_0 -> container.m_38853_(arg_0)).collect(Collectors.toList());
            }
        });
    }

    @Override
    public <C extends AbstractContainerMenu, R> void addRecipeTransferHandler(final IRecipeTransferInfo<C, R> info) {
        this.post.accept(() -> MenuInfoRegistry.getInstance().register(JEIPluginDetector.categoryId(info.getRecipeCategoryUid()), info.getContainerClass(), new MenuInfoProvider<C, Display>(){

            @Override
            public Optional<MenuInfo<C, Display>> provideClient(Display display, MenuSerializationContext<C, ?, Display> context, C menu) {
                return Optional.of(new JEITransferMenuInfo(display, new JEIRecipeTransferData(info, menu, JEIPluginDetector.jeiValue(display))));
            }

            @Override
            public Optional<MenuInfo<C, Display>> provide(CategoryIdentifier<Display> category, C menu, MenuSerializationContext<C, ?, Display> context, CompoundTag networkTag) {
                Display display = JEIRecipeTransferRegistration.read(category, menu, context, networkTag);
                if (display == null) {
                    return Optional.empty();
                }
                return Optional.of(new JEITransferMenuInfo(display, JEIRecipeTransferData.read(menu, networkTag.m_128469_("REI-JEI-Transfer-Data"))));
            }
        }));
    }

    @Nullable
    private static <D extends Display, T extends AbstractContainerMenu> D read(CategoryIdentifier<D> category, T menu, MenuSerializationContext<T, ?, D> context, CompoundTag networkTag) {
        if (DisplaySerializerRegistry.getInstance().hasSerializer(category)) {
            return DisplaySerializerRegistry.getInstance().read(category, networkTag);
        }
        return null;
    }

    @Override
    public <C extends AbstractContainerMenu, R> void addRecipeTransferHandler(final IRecipeTransferHandler<C, R> recipeTransferHandler, final ResourceLocation recipeCategoryUid) {
        TransferHandlerRegistry.getInstance().register(new TransferHandler(){

            @Override
            public TransferHandler.Result handle(TransferHandler.Context context) {
                if (recipeTransferHandler.getContainerClass().isInstance(context.getMenu())) {
                    Display display = context.getDisplay();
                    if (recipeCategoryUid == null || display.getCategoryIdentifier().getIdentifier().equals((Object)recipeCategoryUid)) {
                        IRecipeTransferError error;
                        JEIRecipeLayout layout;
                        Value<IDrawable> background = new Value<IDrawable>(){

                            public void accept(IDrawable iDrawable) {
                            }

                            public IDrawable get() {
                                return JEIGuiHelper.INSTANCE.createBlankDrawable(0, 0);
                            }
                        };
                        if (display instanceof JEIWrappedDisplay) {
                            layout = ((JEIWrappedDisplay)display).getBackingCategory().createLayout((JEIWrappedDisplay)display, background);
                        } else {
                            DisplayCategory category = CategoryRegistry.getInstance().get(display.getCategoryIdentifier().cast()).getCategory();
                            DisplayCategoryView<Display> categoryView = CategoryRegistry.getInstance().get(display.getCategoryIdentifier().cast()).getView(display);
                            layout = new JEIWrappingRecipeLayout(category, background);
                            List<Widget> widgets2 = categoryView.setupDisplay(display, new Rectangle(0, 0, category.getDisplayWidth(display), category.getDisplayHeight()));
                            JEIRecipeTransferRegistration.this.addToLayout(layout, widgets2, 4, 4);
                        }
                        if (context.isActuallyCrafting()) {
                            context.getMinecraft().m_91152_(context.getContainerScreen());
                        }
                        if ((error = recipeTransferHandler.transferRecipe(context.getMenu(), JEIPluginDetector.jeiValue(context.getDisplay()), layout, (Player)context.getMinecraft().f_91074_, context.isStackedCrafting(), context.isActuallyCrafting())) == null) {
                            return TransferHandler.Result.createSuccessful();
                        }
                        if (error instanceof IRecipeTransferError) {
                            TransferHandler.Result result;
                            IRecipeTransferError.Type type = error.getType();
                            if (type == IRecipeTransferError.Type.INTERNAL) {
                                return TransferHandler.Result.createNotApplicable();
                            }
                            TransferHandler.Result result2 = type == IRecipeTransferError.Type.COSMETIC ? TransferHandler.Result.createSuccessful() : (result = TransferHandler.Result.createFailed((Component)(error instanceof JEIRecipeTransferError ? ((JEIRecipeTransferError)error).getText() : new TextComponent(""))));
                            if (error instanceof JEIRecipeTransferError) {
                                JEIRecipeTransferError transferError = (JEIRecipeTransferError)error;
                                IntArrayList redSlots = transferError.getRedSlots();
                                if (redSlots == null) {
                                    redSlots = new IntArrayList();
                                }
                                return result.renderer(JEIRecipeTransferRegistration.forRedSlots((IntList)redSlots));
                            }
                            return result.overrideTooltipRenderer((point, tooltipSink) -> {}).renderer((matrices, mouseX, mouseY, delta, widgets, bounds, d) -> error.showError(matrices, mouseX, mouseY, layout, bounds.x + 4, bounds.y + 4));
                        }
                    }
                }
                return TransferHandler.Result.createNotApplicable();
            }
        });
    }

    static TransferHandlerRenderer forRedSlots(IntList redSlots) {
        return (matrices, mouseX, mouseY, delta, widgets, bounds, display) -> {
            DisplayCategory<?> category = Objects.requireNonNull(CategoryRegistry.getInstance().get(display.getCategoryIdentifier())).getCategory();
            if (category instanceof JEIWrappedCategory) {
                JEIWrappedCategory wrappedCategory = (JEIWrappedCategory)category;
                for (JEIGuiIngredientGroup.SlotWrapper slotWrapper : Widgets.walk(widgets, widget -> widget instanceof JEIGuiIngredientGroup.SlotWrapper)) {
                    if (slotWrapper.slot.getNoticeMark() != 1 || !redSlots.contains(slotWrapper.index)) continue;
                    matrices.m_85836_();
                    matrices.m_85837_(0.0, 0.0, 400.0);
                    Rectangle innerBounds = slotWrapper.slot.getInnerBounds();
                    GuiComponent.m_93172_((PoseStack)matrices, (int)innerBounds.x, (int)innerBounds.y, (int)innerBounds.getMaxX(), (int)innerBounds.getMaxY(), (int)0x40FF0000);
                    matrices.m_85849_();
                }
            }
        };
    }

    private void addToLayout(IRecipeLayout layout, List<Widget> entries, int xOffset, int yOffset) {
        HashMap<Boolean, List> groups = new HashMap<Boolean, List>();
        for (Widget widget : entries) {
            if (!(widget instanceof me.shedaniel.rei.api.client.gui.widgets.Slot)) continue;
            HashMultimap group = HashMultimap.create();
            List<EntryStack<?>> ingredient = ((me.shedaniel.rei.api.client.gui.widgets.Slot)widget).getEntries();
            for (EntryStack<?> stack : ingredient) {
                group.put(stack.getType(), stack);
            }
            groups.computeIfAbsent(((me.shedaniel.rei.api.client.gui.widgets.Slot)widget).getNoticeMark() != 2, $ -> new ArrayList()).add(Pair.of((Object)((me.shedaniel.rei.api.client.gui.widgets.Slot)widget), (Object)group));
        }
        for (Map.Entry entry : groups.entrySet()) {
            ((List)entry.getValue()).stream().map(Pair::getRight).map(Multimap::keys).flatMap(Collection::stream).distinct().forEach(type -> {
                IGuiIngredientGroup<List<Object>> group = layout.getIngredientsGroup(JEIPluginDetector.jeiType(type.getDefinition()));
                int[] i = new int[]{this.getNextId(group.getGuiIngredients().keySet())};
                for (Pair pair : (List)entry.getValue()) {
                    me.shedaniel.rei.api.client.gui.widgets.Slot slot = (me.shedaniel.rei.api.client.gui.widgets.Slot)pair.getLeft();
                    Collection stacks = ((Multimap)pair.getRight()).get(type);
                    group.set(i[0], CollectionUtils.map(stacks, JEIPluginDetector::jeiValue));
                    group.init(i[0], (Boolean)entry.getKey(), slot.getBounds().x - xOffset, slot.getBounds().y - yOffset);
                    i[0] = i[0] + 1;
                }
            });
        }
    }

    private int getNextId(Set<Integer> keys) {
        int i = 0;
        while (keys.contains(i)) {
            ++i;
        }
        return i;
    }

    @Override
    public <C extends AbstractContainerMenu, R> void addUniversalRecipeTransferHandler(IRecipeTransferHandler<C, R> recipeTransferHandler) {
        this.addRecipeTransferHandler(recipeTransferHandler, null);
    }
}

