/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientListOverlay;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JEIIngredientListOverlay implements IIngredientListOverlay
{
    INSTANCE;


    @Nullable
    public Object getIngredientUnderMouse() {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return null;
        }
        ScreenOverlay overlay = REIRuntime.getInstance().getOverlay().get();
        EntryStack<?> stack = overlay.getEntryList().getFocusedStack();
        if (stack.isEmpty()) {
            return null;
        }
        return JEIPluginDetector.jeiValue(stack);
    }

    @Override
    @Nullable
    public <T> T getIngredientUnderMouse(@NotNull IIngredientType<T> ingredientType) {
        Object underMouse = this.getIngredientUnderMouse();
        if (underMouse == null) {
            return null;
        }
        if (ingredientType.getIngredientClass().isInstance(underMouse.getClass())) {
            return (T)underMouse;
        }
        return null;
    }

    @Override
    public boolean hasKeyboardFocus() {
        return REIRuntime.getInstance().isOverlayVisible() && REIRuntime.getInstance().getSearchTextField().isFocused();
    }

    @NotNull
    public <T> List<T> getVisibleIngredients(IIngredientType<T> ingredientType) {
        if (REIRuntime.getInstance().isOverlayVisible()) {
            EntryType type = JEIPluginDetector.unwrapType(ingredientType);
            ScreenOverlay overlay = REIRuntime.getInstance().getOverlay().get();
            return overlay.getEntryList().getEntries().filter(entryStack -> entryStack.getType() == type).map(JEIPluginDetector::jeiValue).collect(Collectors.toList());
        }
        return null;
    }
}

