/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.unwrap;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIFocus;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.resources.ResourceLocation;

public class JEIDynamicDisplayGenerator
implements DynamicDisplayGenerator<Display> {
    private final IRecipeManagerPlugin plugin;

    public JEIDynamicDisplayGenerator(IRecipeManagerPlugin plugin) {
        this.plugin = plugin;
    }

    private Optional<List<Display>> getDisplays(EntryStack<?> entry, IFocus.Mode mode) {
        JEIFocus focus = new JEIFocus(mode, JEIPluginDetector.jeiValue(entry));
        List<ResourceLocation> categoryIds = this.plugin.getRecipeCategoryUids(focus);
        if (categoryIds.isEmpty()) {
            return Optional.empty();
        }
        List displays = null;
        for (ResourceLocation categoryId : categoryIds) {
            IRecipeCategory<?> category = JEIPluginDetector.wrapCategory(CategoryRegistry.getInstance().get(JEIPluginDetector.categoryId(categoryId)).getCategory());
            List<?> recipes = this.plugin.getRecipes(category, focus);
            if (recipes != null && !recipes.isEmpty()) {
                if (displays == null) {
                    displays = CollectionUtils.flatMap(recipes, JEIPluginDetector::createDisplayFrom);
                } else {
                    displays.addAll(CollectionUtils.flatMap(recipes, JEIPluginDetector::createDisplayFrom));
                }
            }
            if ((recipes = this.plugin.getRecipes(category)) == null || recipes.isEmpty()) continue;
            if (displays == null) {
                displays = new ArrayList(CollectionUtils.flatMap(recipes, JEIPluginDetector::createDisplayFrom));
                continue;
            }
            displays.addAll(CollectionUtils.flatMap(recipes, JEIPluginDetector::createDisplayFrom));
        }
        if (displays == null) {
            return Optional.empty();
        }
        return Optional.of(CollectionUtils.filterToList(displays, Objects::nonNull));
    }

    @Override
    public Optional<List<Display>> getRecipeFor(EntryStack<?> entry) {
        return this.getDisplays(entry, IFocus.Mode.OUTPUT);
    }

    @Override
    public Optional<List<Display>> getUsageFor(EntryStack<?> entry) {
        return this.getDisplays(entry, IFocus.Mode.INPUT);
    }
}

