/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.plugins.REIServerPlugin;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoProvider;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.transfer.info.MenuSerializationContext;
import me.shedaniel.rei.jeicompat.transfer.JEIRecipeTransferData;
import me.shedaniel.rei.jeicompat.transfer.JEITransferMenuInfo;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class JEIExtraPlugin
implements REIServerPlugin {
    @Override
    public void registerMenuInfo(MenuInfoRegistry registry) {
        if (Platform.getEnvironment() == Env.SERVER) {
            registry.registerGeneric(id -> true, new MenuInfoProvider<AbstractContainerMenu, Display>(){

                @Override
                @OnlyIn(value=Dist.CLIENT)
                public Optional<MenuInfo<AbstractContainerMenu, Display>> provideClient(Display display, MenuSerializationContext<AbstractContainerMenu, ?, Display> context, AbstractContainerMenu menu) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Optional<MenuInfo<AbstractContainerMenu, Display>> provide(CategoryIdentifier<Display> category, AbstractContainerMenu menu, MenuSerializationContext<AbstractContainerMenu, ?, Display> context, CompoundTag networkTag) {
                    Display display = JEIExtraPlugin.read(category, menu, context, networkTag);
                    if (display == null) {
                        return Optional.empty();
                    }
                    JEIRecipeTransferData data = JEIRecipeTransferData.read(context.getMenu(), networkTag.m_128469_("REI-JEI-Transfer-Data"));
                    return Optional.of(new JEITransferMenuInfo(display, data));
                }
            });
        }
    }

    private static <D extends Display, T extends AbstractContainerMenu> D read(CategoryIdentifier<D> category, T menu, MenuSerializationContext<T, ?, D> context, CompoundTag networkTag) {
        if (DisplaySerializerRegistry.getInstance().hasSerializer(category)) {
            return DisplaySerializerRegistry.getInstance().read(category, networkTag);
        }
        return null;
    }
}

