/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument.type;

import java.util.ConcurrentModificationException;
import java.util.Locale;
import java.util.StringJoiner;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Unit;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.Mutable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public final class TooltipArgumentType
extends ArgumentType<Unit, String> {
    public static final TooltipArgumentType INSTANCE = new TooltipArgumentType();
    private static final Style STYLE = Style.f_131099_.m_131148_(TextColor.m_131266_((int)16769197));

    @Override
    public String getName() {
        return "tooltip";
    }

    @Override
    @Nullable
    public String getPrefix() {
        return "#";
    }

    @Override
    public Style getHighlightedStyle() {
        return STYLE;
    }

    @Override
    public SearchMode getSearchMode() {
        return ConfigObject.getInstance().getTooltipSearchMode();
    }

    @Override
    public boolean matches(Mutable<String> data, EntryStack<?> stack, String searchText, Unit filterData) {
        String tooltip;
        if (data.getValue() == null) {
            tooltip = TooltipArgumentType.tryGetEntryStackTooltip(stack, 0);
            if (tooltip == null) {
                return false;
            }
            data.setValue((Object)tooltip.toLowerCase(Locale.ROOT));
        }
        return (tooltip = (String)data.getValue()).isEmpty() || tooltip.contains(searchText);
    }

    @Nullable
    public static String tryGetEntryStackTooltip(EntryStack<?> stack, int attempt) {
        try {
            Tooltip tooltip = stack.getTooltip(new Point(), false);
            if (tooltip != null) {
                StringJoiner joiner = new StringJoiner("\n");
                for (Tooltip.Entry entry : tooltip.entries()) {
                    if (!entry.isText()) continue;
                    joiner.add(entry.getAsText().getString());
                }
                return joiner.toString();
            }
            return "";
        }
        catch (Throwable throwable) {
            Throwable temp = throwable;
            while (temp != null) {
                if (!((temp = temp.getCause()) instanceof ConcurrentModificationException)) continue;
                if (attempt < 10) {
                    return TooltipArgumentType.tryGetEntryStackTooltip(stack, attempt + 1);
                }
                return null;
            }
            throw throwable;
        }
    }

    @Override
    public Unit prepareSearchFilter(String searchText) {
        return Unit.INSTANCE;
    }

    private TooltipArgumentType() {
    }
}

