/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument.type;

import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentTypesRegistry;
import me.shedaniel.rei.impl.client.search.result.ArgumentApplicableResult;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.Mutable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public abstract class ArgumentType<T, R> {
    private int index = -1;

    public abstract String getName();

    @Nullable
    public String getPrefix() {
        return null;
    }

    public Style getHighlightedStyle() {
        return Style.f_131099_;
    }

    public SearchMode getSearchMode() {
        return SearchMode.PREFIX;
    }

    public ArgumentApplicableResult checkApplicable(String text, boolean forceGrammar) {
        ArgumentApplicableResult status;
        String prefix = this.getPrefix();
        if (forceGrammar && !prefix.isEmpty() && (status = this.checkApplicable(text, prefix)).isApplicable()) {
            return status;
        }
        if (!forceGrammar && this.getSearchMode() == SearchMode.ALWAYS) {
            status = this.checkApplicable(text, "");
            if (status.isApplicable()) {
                status.notUsingGrammar();
            }
            return status;
        }
        return ArgumentApplicableResult.notApplicable();
    }

    private ArgumentApplicableResult checkApplicable(String text, String prefix) {
        if (prefix == null) {
            return ArgumentApplicableResult.notApplicable();
        }
        if (text.startsWith("-" + prefix)) {
            return ArgumentApplicableResult.applyInverted(text.substring(1 + prefix.length())).grammar(0, prefix.length() + 1);
        }
        if (!prefix.isEmpty() && text.startsWith(prefix + "-")) {
            return ArgumentApplicableResult.applyInverted(text.substring(1 + prefix.length())).grammar(0, prefix.length() + 1);
        }
        if (text.startsWith(prefix)) {
            return ArgumentApplicableResult.apply(text.substring(prefix.length())).grammar(0, prefix.length());
        }
        return ArgumentApplicableResult.notApplicable();
    }

    public abstract boolean matches(Mutable<R> var1, EntryStack<?> var2, String var3, T var4);

    public abstract T prepareSearchFilter(String var1);

    public int getIndex() {
        if (this.index >= 0) {
            return this.index;
        }
        this.index = ArgumentTypesRegistry.ARGUMENT_TYPE_LIST.indexOf(this);
        return this.index;
    }
}

