/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search;

import java.util.List;
import java.util.Objects;
import me.shedaniel.rei.api.client.search.SearchFilter;
import me.shedaniel.rei.api.client.search.SearchProvider;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.search.argument.Argument;
import me.shedaniel.rei.impl.client.search.argument.CompoundArgument;
import me.shedaniel.rei.impl.client.util.CrashReportUtils;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;

public class SearchProviderImpl
implements SearchProvider {
    @Override
    public void startReload() {
    }

    @Override
    public SearchFilter createFilter(String searchTerm) {
        return new SearchFilterImpl(Argument.bakeArguments(searchTerm), searchTerm);
    }

    public static class SearchFilterImpl
    implements SearchFilter {
        private final List<CompoundArgument> arguments;
        private final String filter;

        public SearchFilterImpl(List<CompoundArgument> arguments, String searchTerm) {
            this.arguments = arguments;
            this.filter = searchTerm;
        }

        @Override
        public boolean test(EntryStack<?> stack) {
            try {
                return Argument.matches(stack, this.arguments);
            }
            catch (Throwable throwable) {
                CrashReport report = CrashReportUtils.essential(throwable, "Testing entry with search filter");
                CrashReportCategory category = report.m_127514_("Search entry details");
                try {
                    stack.fillCrashReport(report, category);
                }
                catch (Throwable throwable1) {
                    category.m_128162_("Filling Report", throwable1);
                }
                throw CrashReportUtils.throwReport(report);
            }
        }

        @Override
        public String getFilter() {
            return this.filter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchFilterImpl that = (SearchFilterImpl)o;
            return Objects.equals(this.filter, that.filter);
        }

        public int hashCode() {
            return Objects.hash(this.filter);
        }
    }
}

