/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.basewidgets;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import me.shedaniel.clothconfig2.api.LazyResettable;
import me.shedaniel.math.Color;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.animator.ValueAnimator;
import me.shedaniel.rei.api.client.gui.animator.ValueProvider;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.impl.client.gui.text.TextTransformations;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public final class LabelWidget
extends Label {
    private boolean hovered = false;
    private boolean focused = false;
    private boolean clickable = false;
    private int horizontalAlignment = 0;
    private boolean hasShadow = true;
    private boolean focusable = true;
    private ValueProvider<Color> color = ValueAnimator.ofColor().withConvention(() -> Color.ofTransparent((int)(REIRuntime.getInstance().isDarkThemeEnabled() ? -4473925 : -1)), 50L);
    private ValueProvider<Color> hoveredColor = ValueAnimator.ofColor().withConvention(() -> Color.ofTransparent((int)(REIRuntime.getInstance().isDarkThemeEnabled() ? -1 : -10027060)), 50L);
    private final ValueProvider<Color> finalColor = ValueAnimator.ofColor().withConvention(() -> {
        if (!this.hovered) {
            return this.color.value();
        }
        return this.hoveredColor.value();
    }, ValueAnimator.typicalTransitionTime() / 2L);
    private Point point;
    @Nullable
    private @Nullable Function<Label, @Nullable Component[]> tooltip;
    @Nullable
    private Consumer<Label> onClick;
    @Nullable
    private BiConsumer<PoseStack, Label> onRender;
    private FormattedText text;
    private boolean rainbow;
    private final LazyResettable<FormattedCharSequence> orderedText = new LazyResettable(() -> Language.m_128107_().m_5536_(this.getMessage()));

    public LabelWidget(Point point, FormattedText text) {
        this.point = point;
        Objects.requireNonNull(this.point);
        this.text = text;
        Objects.requireNonNull(this.text);
    }

    @Override
    public final boolean isClickable() {
        return this.clickable;
    }

    @Override
    public final void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    @Override
    @Nullable
    public final Consumer<Label> getOnClick() {
        return this.onClick;
    }

    @Override
    public final void setOnClick(@Nullable Consumer<Label> onClick) {
        this.onClick = onClick;
    }

    @Override
    @Nullable
    public final BiConsumer<PoseStack, Label> getOnRender() {
        return this.onRender;
    }

    @Override
    public final void setOnRender(@Nullable BiConsumer<PoseStack, Label> onRender) {
        this.onRender = onRender;
    }

    @Override
    public final boolean isFocusable() {
        return this.focusable;
    }

    @Override
    public final void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    @Override
    @Nullable
    public final Component[] getTooltipLines() {
        if (this.tooltip == null) {
            return null;
        }
        return this.tooltip.apply(this);
    }

    @Override
    public final void setTooltipFunction(@Nullable @Nullable Function<Label, @Nullable Component[]> tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public final int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public final void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public final boolean hasShadow() {
        return this.hasShadow;
    }

    @Override
    public final void setShadow(boolean hasShadow) {
        this.hasShadow = hasShadow;
    }

    @Override
    public final int getColor() {
        return this.color.value().getColor();
    }

    @Override
    public final void setColor(int color) {
        this.color = ValueProvider.constant(Color.ofTransparent((int)color));
        this.finalColor.completeImmediately();
    }

    @Override
    public Label color(int lightModeColor, int darkModeColor) {
        this.color = ValueAnimator.ofColor().withConvention(() -> Color.ofTransparent((int)(REIRuntime.getInstance().isDarkThemeEnabled() ? darkModeColor : lightModeColor)), ValueAnimator.typicalTransitionTime());
        this.color.completeImmediately();
        this.finalColor.completeImmediately();
        return this;
    }

    @Override
    public final int getHoveredColor() {
        return this.hoveredColor.value().getColor();
    }

    @Override
    public final void setHoveredColor(int hoveredColor) {
        this.hoveredColor = ValueProvider.constant(Color.ofTransparent((int)hoveredColor));
        this.finalColor.completeImmediately();
    }

    @Override
    public final Point getPoint() {
        return this.point;
    }

    @Override
    public final void setPoint(Point point) {
        this.point = Objects.requireNonNull(point);
    }

    @Override
    public FormattedText getMessage() {
        return this.text;
    }

    @Override
    public void setMessage(FormattedText message) {
        this.text = Objects.requireNonNull(message);
        this.orderedText.reset();
    }

    @Override
    public void setRainbow(boolean rainbow) {
        this.rainbow = rainbow;
    }

    @Override
    public final Rectangle getBounds() {
        int width = this.font.m_92852_(this.text);
        Point point = this.getPoint();
        if (this.getHorizontalAlignment() == -1) {
            return new Rectangle(point.x - 1, point.y - 5, width + 2, 14);
        }
        if (this.getHorizontalAlignment() == 1) {
            return new Rectangle(point.x - width - 1, point.y - 5, width + 2, 14);
        }
        return new Rectangle(point.x - width / 2 - 1, point.y - 5, width + 2, 14);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        Component[] tooltip;
        this.color.update(delta);
        this.hoveredColor.update(delta);
        this.finalColor.update(delta);
        if (this.getOnRender() != null) {
            this.getOnRender().accept(matrices, this);
        }
        int color = this.finalColor.value().getColor();
        this.hovered = this.isClickable() && this.isHovered(mouseX, mouseY);
        Point pos = this.getPoint();
        FormattedCharSequence sequence = (FormattedCharSequence)this.orderedText.get();
        if (this.rainbow) {
            sequence = TextTransformations.applyRainbow(sequence, pos.x, pos.y);
        }
        int width = this.font.m_92724_(sequence);
        switch (this.getHorizontalAlignment()) {
            case -1: {
                if (this.hasShadow()) {
                    this.font.m_92744_(matrices, sequence, (float)pos.x, (float)pos.y, color);
                    break;
                }
                this.font.m_92877_(matrices, sequence, (float)pos.x, (float)pos.y, color);
                break;
            }
            case 1: {
                if (this.hasShadow()) {
                    this.font.m_92744_(matrices, sequence, (float)(pos.x - width), (float)pos.y, color);
                    break;
                }
                this.font.m_92877_(matrices, sequence, (float)(pos.x - width), (float)pos.y, color);
                break;
            }
            default: {
                if (this.hasShadow()) {
                    this.font.m_92744_(matrices, sequence, (float)pos.x - (float)width / 2.0f, (float)pos.y, color);
                    break;
                }
                this.font.m_92877_(matrices, sequence, (float)pos.x - (float)width / 2.0f, (float)pos.y, color);
            }
        }
        if (this.isHovered(mouseX, mouseY) && (tooltip = this.getTooltipLines()) != null) {
            if (!this.focused && this.containsMouse(mouseX, mouseY)) {
                Tooltip.create(tooltip).queue();
            } else if (this.focused) {
                Tooltip.create(this.point, tooltip).queue();
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isClickable() && this.containsMouse(mouseX, mouseY)) {
            Widgets.produceClickSound();
            if (this.onClick != null) {
                this.onClick.accept(this);
            }
            return true;
        }
        return false;
    }

    public boolean m_7933_(int int_1, int int_2, int int_3) {
        if (!(this.isClickable() && this.isFocusable() && this.focused)) {
            return false;
        }
        if (int_1 != 257 && int_1 != 32 && int_1 != 335) {
            return false;
        }
        Widgets.produceClickSound();
        if (this.onClick != null) {
            this.onClick.accept(this);
        }
        return true;
    }

    public boolean m_5755_(boolean boolean_1) {
        if (!this.isClickable() || !this.isFocusable()) {
            return false;
        }
        this.focused = !this.focused;
        return true;
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return this.containsMouse(mouseX, mouseY) || this.focused;
    }

    public List<? extends GuiEventListener> m_6702_() {
        return Collections.emptyList();
    }
}

