/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class QueuedTooltip
implements Tooltip {
    private Point location;
    private List<Tooltip.Entry> entries;
    private List<TooltipComponent> components;
    private EntryStack<?> stack = EntryStack.empty();

    private QueuedTooltip(Point location, Collection<Tooltip.Entry> entries) {
        this.location = location;
        if (this.location == null) {
            this.location = PointHelper.ofMouse();
        }
        this.entries = Lists.newArrayList(entries);
        this.components = Lists.newArrayList();
    }

    public static QueuedTooltip impl(Point location, Collection<Tooltip.Entry> text) {
        return new QueuedTooltip(location, text);
    }

    @Override
    public int getX() {
        return this.location.x;
    }

    @Override
    public int getY() {
        return this.location.y;
    }

    @Override
    public List<Tooltip.Entry> entries() {
        return this.entries;
    }

    @Override
    public List<TooltipComponent> components() {
        return this.components;
    }

    @Override
    public Tooltip add(Component text) {
        this.entries.add(new TooltipEntryImpl(text));
        return this;
    }

    @Override
    public Tooltip add(ClientTooltipComponent component) {
        this.entries.add(new TooltipEntryImpl(component));
        return this;
    }

    @Override
    public Tooltip add(TooltipComponent component) {
        this.components.add(component);
        return this;
    }

    @Override
    public void queue() {
        Tooltip.super.queue();
    }

    @Override
    public EntryStack<?> getContextStack() {
        return this.stack;
    }

    @Override
    public Tooltip withContextStack(EntryStack<?> stack) {
        this.stack = stack.copy();
        return this;
    }

    public record TooltipEntryImpl(Object obj) implements Tooltip.Entry
    {
        @Override
        public Component getAsText() {
            return (Component)this.obj;
        }

        @Override
        public boolean isText() {
            return this.obj instanceof Component;
        }

        @Override
        public ClientTooltipComponent getAsComponent() {
            return (ClientTooltipComponent)this.obj;
        }
    }
}

