/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.DrawableConsumer;
import me.shedaniel.rei.api.client.gui.widgets.Arrow;
import me.shedaniel.rei.api.client.gui.widgets.BurningFire;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidget;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.impl.client.gui.toast.CopyRecipeIdentifierToast;
import me.shedaniel.rei.impl.client.gui.widget.AutoCraftingEvaluator;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.ArrowWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.BurningFireWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.ButtonWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.DrawableWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.FillRectangleDrawableConsumer;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.LabelWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.PanelWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.TexturedDrawableConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public final class InternalWidgets {
    private InternalWidgets() {
    }

    public static Widget createAutoCraftingButtonWidget(final Rectangle displayBounds, Rectangle rectangle, Component text, final Supplier<Display> displaySupplier, final Supplier<Collection<ResourceLocation>> idsSupplier, final List<Widget> setupDisplay, DisplayCategory<?> category) {
        final Button autoCraftingButton = Widgets.createButton(rectangle, text).focusable(false).onClick(button -> AutoCraftingEvaluator.evaluateAutoCrafting(true, Screen.m_96638_(), (Display)displaySupplier.get(), idsSupplier));
        return new DelegateWidget(autoCraftingButton){
            boolean didJustRender;
            {
                super(widget);
                this.didJustRender = false;
            }

            @Override
            public void m_6305_(PoseStack poses, int mouseX, int mouseY, float delta) {
                this.didJustRender = false;
                AutoCraftingEvaluator.AutoCraftingResult result = AutoCraftingEvaluator.evaluateAutoCrafting(false, false, (Display)displaySupplier.get(), idsSupplier);
                autoCraftingButton.setEnabled(result.successful);
                autoCraftingButton.setTint(result.tint);
                if (result.hasApplicable && (this.containsMouse(mouseX, mouseY) || autoCraftingButton.isFocused()) && result.renderer != null) {
                    result.renderer.render(poses, mouseX, mouseY, delta, setupDisplay, displayBounds, (Display)displaySupplier.get());
                }
                this.renderIf(result.hasApplicable, poses, mouseX, mouseY, delta);
                if (this.didJustRender) {
                    if (!autoCraftingButton.isFocused() && this.containsMouse(mouseX, mouseY)) {
                        this.tryTooltip(result, new Point(mouseX, mouseY));
                    } else if (autoCraftingButton.isFocused()) {
                        Rectangle bounds = autoCraftingButton.getBounds();
                        this.tryTooltip(result, new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2));
                    }
                }
            }

            private void tryTooltip(AutoCraftingEvaluator.AutoCraftingResult result, Point point) {
                if (result.tooltipRenderer != null) {
                    result.tooltipRenderer.accept(point, Tooltip::queue);
                }
            }

            private void renderIf(boolean should, PoseStack poseStack, int mouseX, int mouseY, float delta) {
                if (should) {
                    this.didJustRender = true;
                    this.widget.m_6305_(poseStack, mouseX, mouseY, delta);
                } else if (Minecraft.m_91087_().f_91066_.f_92125_) {
                    this.didJustRender = true;
                    this.widget.m_6305_(poseStack, mouseX, mouseY, delta);
                }
            }

            public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
                if (this.didJustRender && ((Display)displaySupplier.get()).getDisplayLocation().isPresent() && ConfigObject.getInstance().getCopyRecipeIdentifierKeybind().matchesKey(keyCode, scanCode) && this.containsMouse(PointHelper.ofMouse())) {
                    this.minecraft.f_91068_.m_90911_(((Display)displaySupplier.get()).getDisplayLocation().get().toString());
                    if (ConfigObject.getInstance().isToastDisplayedOnCopyIdentifier()) {
                        CopyRecipeIdentifierToast.addToast(I18n.m_118938_((String)"msg.rei.copied_recipe_id", (Object[])new Object[0]), I18n.m_118938_((String)"msg.rei.recipe_id_details", (Object[])new Object[]{((Display)displaySupplier.get()).getDisplayLocation().get().toString()}));
                    }
                    return true;
                }
                return super.m_7933_(keyCode, scanCode, modifiers);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (this.didJustRender && ((Display)displaySupplier.get()).getDisplayLocation().isPresent() && ConfigObject.getInstance().getCopyRecipeIdentifierKeybind().matchesMouse(button) && this.containsMouse(PointHelper.ofMouse())) {
                    this.minecraft.f_91068_.m_90911_(((Display)displaySupplier.get()).getDisplayLocation().get().toString());
                    if (ConfigObject.getInstance().isToastDisplayedOnCopyIdentifier()) {
                        CopyRecipeIdentifierToast.addToast(I18n.m_118938_((String)"msg.rei.copied_recipe_id", (Object[])new Object[0]), I18n.m_118938_((String)"msg.rei.recipe_id_details", (Object[])new Object[]{((Display)displaySupplier.get()).getDisplayLocation().get().toString()}));
                    }
                    return true;
                }
                return super.m_6375_(mouseX, mouseY, button);
            }
        };
    }

    public static WidgetWithBounds wrapLateRenderable(Widget widget) {
        return new LateRenderableWidget(widget);
    }

    public static Widget concatWidgets(Widget widget1, Widget widget2) {
        return new MergedWidget(widget2, widget1);
    }

    public static void attach() {
        ClientInternals.attachInstance(new WidgetsProvider(), ClientInternals.WidgetsProvider.class);
    }

    private static class LateRenderableWidget
    extends DelegateWidget
    implements LateRenderable {
        private LateRenderableWidget(Widget widget) {
            super(widget);
        }
    }

    private static class MergedWidget
    extends Widget {
        private final List<Widget> widgets;

        public MergedWidget(Widget widget1, Widget widget2) {
            this.widgets = Lists.newArrayList((Object[])new Widget[]{Objects.requireNonNull(widget1), Objects.requireNonNull(widget2)});
        }

        public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
            for (Widget widget : this.widgets) {
                widget.setZ(this.getZ());
                widget.m_6305_(matrices, mouseX, mouseY, delta);
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.widgets;
        }

        public boolean m_6050_(double mouseX, double mouseY, double amount) {
            for (Widget widget : this.widgets) {
                if (!widget.m_6050_(mouseX, mouseY, amount)) continue;
                return true;
            }
            return false;
        }
    }

    private static class WidgetsProvider
    implements ClientInternals.WidgetsProvider {
        private WidgetsProvider() {
        }

        @Override
        public boolean isRenderingPanel(Panel panel) {
            return PanelWidget.isRendering(panel);
        }

        @Override
        public Widget createDrawableWidget(DrawableConsumer drawable) {
            return new DrawableWidget(drawable);
        }

        @Override
        public Slot createSlot(Point point) {
            return new EntryWidget(point);
        }

        @Override
        public Slot createSlot(Rectangle bounds) {
            return new EntryWidget(bounds);
        }

        @Override
        public Button createButton(Rectangle bounds, Component text) {
            return new ButtonWidget(bounds, text);
        }

        @Override
        public Panel createPanelWidget(Rectangle bounds) {
            return new PanelWidget(bounds);
        }

        @Override
        public Label createLabel(Point point, FormattedText text) {
            return new LabelWidget(point, text);
        }

        @Override
        public Arrow createArrow(Rectangle rectangle) {
            return new ArrowWidget(rectangle);
        }

        @Override
        public BurningFire createBurningFire(Rectangle rectangle) {
            return new BurningFireWidget(rectangle);
        }

        @Override
        public DrawableConsumer createTexturedConsumer(ResourceLocation texture, int x, int y, int width, int height, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
            return new TexturedDrawableConsumer(texture, x, y, width, height, u, v, uWidth, vHeight, textureWidth, textureHeight);
        }

        @Override
        public DrawableConsumer createFillRectangleConsumer(Rectangle rectangle, int color) {
            return new FillRectangleDrawableConsumer(rectangle, color);
        }
    }
}

