/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.modules.entries;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.config.entry.EntryStackProvider;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.MenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.EntryStackSubsetsMenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.SubMenuEntry;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
@ApiStatus.Internal
public class SubSubsetsMenuEntry
extends SubMenuEntry {
    private Tuple<Integer, Integer> filteredRatio = null;
    private long lastListHash = -1L;
    private boolean clickedBefore = false;

    public SubSubsetsMenuEntry(Component text) {
        this(text, Collections.emptyList());
    }

    public SubSubsetsMenuEntry(Component text, Supplier<List<MenuEntry>> entries) {
        this(text, entries.get());
    }

    public SubSubsetsMenuEntry(Component text, List<MenuEntry> entries) {
        super(text, entries);
    }

    @Override
    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        super.m_6305_(matrices, mouseX, mouseY, delta);
        if (this.isSelected()) {
            if (this.entries.isEmpty()) {
                this.clickedBefore = false;
            }
            if (this.clickedBefore) {
                if (this.isRendering() && mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY <= this.getY() + 12 && !this.entries.isEmpty()) {
                    REIRuntime.getInstance().queueTooltip(Tooltip.create(new Component[]{new TextComponent("Click again to filter everything in this group.")}));
                } else {
                    this.clickedBefore = false;
                }
            }
        } else {
            this.clickedBefore = false;
        }
    }

    @Override
    protected void renderBackground(PoseStack poses, int x, int y, int width, int height) {
        double filteredRatio = this.getFilteredRatio();
        if (filteredRatio > 0.0) {
            filteredRatio = filteredRatio * 0.85 + 0.15;
            SubSubsetsMenuEntry.m_93172_((PoseStack)poses, (int)x, (int)y, (int)(x + width), (int)(y + 12), (int)((0xFF0000 | Mth.m_14165_((double)(filteredRatio * 255.0)) << 24) + (this.isSelected() ? 39321 : 0)));
        } else if (this.isSelected()) {
            SubSubsetsMenuEntry.m_93172_((PoseStack)poses, (int)x, (int)y, (int)(x + width), (int)(y + 12), (int)-12237499);
        }
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int button) {
        if (this.clickedBefore) {
            this.clickedBefore = false;
            List<EntryStackProvider<?>> filteredStacks = ConfigObject.getInstance().getFilteredStackProviders();
            Menu overlay = ((ScreenOverlayImpl)REIRuntime.getInstance().getOverlay().get()).getOverlayMenu();
            this.setFiltered(filteredStacks, overlay, this, !(this.getFilteredRatio() > 0.0));
            ConfigManager.getInstance().saveConfig();
            EntryRegistry.getInstance().refilter();
            if (REIRuntimeImpl.getSearchField() != null) {
                ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
            }
        } else {
            this.clickedBefore = true;
        }
        this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        return true;
    }

    private void setFiltered(List<EntryStackProvider<?>> filteredStacks, Menu subsetsMenu, SubSubsetsMenuEntry subSubsetsMenuEntry, boolean filtered) {
        for (MenuEntry entry : subSubsetsMenuEntry.entries) {
            if (entry instanceof EntryStackSubsetsMenuEntry) {
                EntryStackSubsetsMenuEntry menuEntry = (EntryStackSubsetsMenuEntry)entry;
                if (menuEntry.isFiltered() != filtered) {
                    if (!filtered) {
                        filteredStacks.removeIf(next -> EntryStacks.equalsExact(next.provide(), menuEntry.stack));
                    } else {
                        filteredStacks.add(EntryStackProvider.ofStack(menuEntry.stack.normalize()));
                    }
                }
                if (subsetsMenu == null) continue;
                menuEntry.recalculateFilter(subsetsMenu);
                continue;
            }
            if (!(entry instanceof SubSubsetsMenuEntry)) continue;
            SubSubsetsMenuEntry menuEntry = (SubSubsetsMenuEntry)entry;
            this.setFiltered(filteredStacks, subsetsMenu, menuEntry, filtered);
        }
    }

    public double getFilteredRatio() {
        Tuple<Integer, Integer> pair = this.getFilteredRatioPair();
        return (Integer)pair.m_14419_() == 0 ? 0.0 : (double)((Integer)pair.m_14418_()).intValue() / (double)((Integer)pair.m_14419_()).intValue();
    }

    public Tuple<Integer, Integer> getFilteredRatioPair() {
        List<EntryStackProvider<?>> filteredStacks = ConfigObject.getInstance().getFilteredStackProviders();
        if (this.lastListHash != (long)filteredStacks.hashCode()) {
            int size = 0;
            int filtered = 0;
            for (MenuEntry entry : this.entries) {
                if (entry instanceof EntryStackSubsetsMenuEntry) {
                    ++size;
                    if (!((EntryStackSubsetsMenuEntry)entry).isFiltered()) continue;
                    ++filtered;
                    continue;
                }
                if (!(entry instanceof SubSubsetsMenuEntry)) continue;
                Tuple<Integer, Integer> pair = ((SubSubsetsMenuEntry)entry).getFilteredRatioPair();
                filtered += ((Integer)pair.m_14418_()).intValue();
                size += ((Integer)pair.m_14419_()).intValue();
            }
            this.filteredRatio = new Tuple((Object)filtered, (Object)size);
            this.lastListHash = filteredStacks.hashCode();
        }
        return this.filteredRatio;
    }
}

