/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.credits;

import com.mojang.blaze3d.vertex.PoseStack;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.rei.impl.client.gui.text.TextTransformations;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class CreditsEntryListWidget
extends DynamicNewSmoothScrollingEntryListWidget<CreditsItem> {
    private boolean inFocus;

    public CreditsEntryListWidget(Minecraft client, int width, int height, int startY, int endY) {
        super(client, width, height, startY, endY, GuiComponent.f_93096_);
    }

    public boolean m_5755_(boolean boolean_1) {
        if (!this.inFocus && this.getItemCount() == 0) {
            return false;
        }
        boolean bl = this.inFocus = !this.inFocus;
        if (this.inFocus && this.getFocused() == null && this.getItemCount() > 0) {
            this.moveSelection(1);
        } else if (this.inFocus && this.getFocused() != null) {
            this.moveSelection(0);
        }
        return this.inFocus;
    }

    public void creditsClearEntries() {
        this.clearItems();
    }

    private CreditsItem rei_getEntry(int int_1) {
        return (CreditsItem)((Object)this.m_6702_().get(int_1));
    }

    public void creditsAddEntry(CreditsItem entry) {
        this.addItem(entry);
    }

    public int getItemWidth() {
        return this.width - 80;
    }

    protected int getScrollbarPosition() {
        return this.width - 40;
    }

    public static abstract class CreditsItem
    extends DynamicEntryListWidget.Entry<CreditsItem> {
        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }
    }

    public static class LinkItem
    extends CreditsItem {
        private Component text;
        private List<FormattedCharSequence> textSplit;
        private String link;
        private boolean contains;
        private boolean rainbow;

        public LinkItem(Component text, String link, int width, boolean rainbow) {
            this.text = text;
            this.textSplit = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)text, width);
            this.link = link;
            this.rainbow = rainbow;
        }

        public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            boolean bl = this.contains = mouseX >= x && mouseX <= x + entryWidth && mouseY >= y && mouseY <= y + entryHeight;
            if (this.contains) {
                Minecraft.m_91087_().f_91080_.m_96602_(matrices, (Component)new TextComponent("Click to open link."), mouseX, mouseY);
                int yy = y;
                for (FormattedCharSequence textSp : this.textSplit) {
                    FormattedCharSequence underlined = characterVisitor -> textSp.m_13731_((charIndex, style, codePoint) -> characterVisitor.m_6411_(charIndex, style.m_131157_(ChatFormatting.UNDERLINE), codePoint));
                    if (this.rainbow) {
                        underlined = TextTransformations.applyRainbow(underlined, x + 5, yy);
                    }
                    Minecraft.m_91087_().f_91062_.m_92744_(matrices, underlined, (float)(x + 5), (float)yy, -14695425);
                    yy += 12;
                }
            } else {
                int yy = y;
                for (FormattedCharSequence textSp : this.textSplit) {
                    if (this.rainbow) {
                        textSp = TextTransformations.applyRainbow(textSp, x + 5, yy);
                    }
                    Minecraft.m_91087_().f_91062_.m_92744_(matrices, textSp, (float)(x + 5), (float)yy, -14695425);
                    yy += 12;
                }
            }
        }

        public int getItemHeight() {
            return 12 * this.textSplit.size();
        }

        public boolean m_5755_(boolean boolean_1) {
            return false;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.contains && button == 0) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                try {
                    Util.m_137581_().m_137648_(new URI(this.link));
                    return true;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }

    public static class TranslationCreditsItem
    extends CreditsItem {
        private Component language;
        private List<FormattedCharSequence> translators;
        private int maxWidth;

        public TranslationCreditsItem(Component language, Component translators, int width, int maxWidth) {
            this.language = language;
            this.translators = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)translators, width);
            this.maxWidth = maxWidth;
        }

        public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            Minecraft.m_91087_().f_91062_.m_92744_(matrices, this.language.m_7532_(), (float)(x + 5), (float)(y + 5), -1);
            int yy = y + 5;
            for (FormattedCharSequence translator : this.translators) {
                Minecraft.m_91087_().f_91062_.m_92744_(matrices, translator, (float)(x + 5 + this.maxWidth), (float)yy, -1);
                yy += 12;
            }
        }

        public int getItemHeight() {
            return 12 * this.translators.size();
        }

        public boolean m_5755_(boolean boolean_1) {
            return false;
        }
    }

    public static class TextCreditsItem
    extends CreditsItem {
        private Component text;

        public TextCreditsItem(Component text) {
            this.text = text;
        }

        public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            Minecraft.m_91087_().f_91062_.m_92744_(matrices, this.text.m_7532_(), (float)(x + 5), (float)(y + 5), -1);
        }

        public int getItemHeight() {
            return 12;
        }

        public boolean m_5755_(boolean boolean_1) {
            return false;
        }
    }
}

