/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.hooks.client.screen.ScreenHooks;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.gui.ConfigScreenProvider;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Jankson;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonElement;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonNull;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonObject;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonPrimitive;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.api.DeserializationException;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.GlobalizedClothConfigScreen;
import me.shedaniel.clothconfig2.gui.entries.KeyCodeEntry;
import me.shedaniel.clothconfig2.gui.entries.TextListEntry;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.entry.EntryStackProvider;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.config.DisplayScreenType;
import me.shedaniel.rei.api.client.gui.config.SyntaxHighlightingMode;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.config.entries.FilteringEntry;
import me.shedaniel.rei.impl.client.config.entries.NoFilteringEntry;
import me.shedaniel.rei.impl.client.config.entries.RecipeScreenTypeEntry;
import me.shedaniel.rei.impl.client.config.entries.ReloadPluginsEntry;
import me.shedaniel.rei.impl.client.config.entries.SearchFilterSyntaxHighlightingEntry;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.impl.client.entry.filtering.rules.ManualFilteringRule;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.credits.CreditsScreen;
import me.shedaniel.rei.impl.client.gui.performance.entry.PerformanceEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class ConfigManagerImpl
implements ConfigManager {
    private boolean craftableOnly = false;
    private final Gson gson = new GsonBuilder().create();
    private ConfigObjectImpl object;

    public ConfigManagerImpl() {
        Jankson jankson = Jankson.builder().build();
        AutoConfig.register(ConfigObjectImpl.class, (definition, configClass) -> new JanksonConfigSerializer(definition, configClass, ConfigManagerImpl.buildJankson(Jankson.builder())));
        GuiRegistry guiRegistry = AutoConfig.getGuiRegistry(ConfigObjectImpl.class);
        guiRegistry.registerPredicateProvider((i13n, field, config, defaults, guiProvider) -> {
            if (field.isAnnotationPresent(ConfigEntry.Gui.Excluded.class)) {
                return Collections.emptyList();
            }
            KeyCodeEntry entry = ConfigEntryBuilder.create().startModifierKeyCodeField((Component)new TranslatableComponent(i13n), (ModifierKeyCode)Utils.getUnsafely((Field)field, (Object)config, (Object)ModifierKeyCode.unknown())).setModifierDefaultValue(() -> (ModifierKeyCode)Utils.getUnsafely((Field)field, (Object)defaults)).setModifierSaveConsumer(newValue -> Utils.setUnsafely((Field)field, (Object)config, (Object)newValue)).build();
            return Collections.singletonList(entry);
        }, field -> field.getType() == ModifierKeyCode.class);
        guiRegistry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> {
            ConfigObjectImpl.UsePercentage bounds = field.getAnnotation(ConfigObjectImpl.UsePercentage.class);
            return Collections.singletonList(ConfigEntryBuilder.create().startIntSlider((Component)new TranslatableComponent(i13n), Mth.m_14165_((double)((Double)Utils.getUnsafely((Field)field, (Object)config, (Object)0.0) * 100.0)), Mth.m_14165_((double)(bounds.min() * 100.0)), Mth.m_14165_((double)(bounds.max() * 100.0))).setDefaultValue(() -> Mth.m_14165_((double)((Double)Utils.getUnsafely((Field)field, (Object)defaults) * 100.0))).setSaveConsumer(newValue -> Utils.setUnsafely((Field)field, (Object)config, (Object)((double)newValue.intValue() / 100.0))).setTextGetter(integer -> new TextComponent(bounds.prefix() + String.format("%d%%", integer))).build());
        }, field -> field.getType() == Double.TYPE || field.getType() == Double.class, new Class[]{ConfigObjectImpl.UsePercentage.class});
        guiRegistry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> Collections.singletonList(new RecipeScreenTypeEntry(220, (Component)new TranslatableComponent(i13n), (DisplayScreenType)((Object)((Object)Utils.getUnsafely((Field)field, (Object)config, (Object)((Object)DisplayScreenType.UNSET)))), (DisplayScreenType)((Object)((Object)Utils.getUnsafely((Field)field, (Object)defaults))), type -> Utils.setUnsafely((Field)field, (Object)config, (Object)type))), field -> field.getType() == DisplayScreenType.class, new Class[]{ConfigObjectImpl.UseSpecialRecipeTypeScreen.class});
        guiRegistry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> Collections.singletonList(new SearchFilterSyntaxHighlightingEntry((Component)new TranslatableComponent(i13n), (SyntaxHighlightingMode)((Object)((Object)Utils.getUnsafely((Field)field, (Object)config, (Object)((Object)SyntaxHighlightingMode.COLORFUL)))), (SyntaxHighlightingMode)((Object)((Object)Utils.getUnsafely((Field)field, (Object)defaults))), type -> Utils.setUnsafely((Field)field, (Object)config, (Object)type))), field -> field.getType() == SyntaxHighlightingMode.class, new Class[]{ConfigObjectImpl.UseSpecialSearchFilterSyntaxHighlightingScreen.class});
        guiRegistry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> {
            List<EntryStack<?>> value = CollectionUtils.map((Collection)Utils.getUnsafely((Field)field, (Object)config, new ArrayList()), EntryStackProvider::provide);
            List<EntryStack<?>> defaultValue = CollectionUtils.map((Collection)Utils.getUnsafely((Field)field, (Object)defaults), EntryStackProvider::provide);
            Consumer<List<EntryStack<?>>> saveConsumer = newValue -> Utils.setUnsafely((Field)field, (Object)config, CollectionUtils.map(newValue, EntryStackProvider::ofStack));
            return REIRuntime.getInstance().getPreviousContainerScreen() == null || Minecraft.m_91087_().m_91403_() == null || Minecraft.m_91087_().m_91403_().m_105141_() == null ? Collections.singletonList(new NoFilteringEntry(220, value, defaultValue, saveConsumer)) : Collections.singletonList(new FilteringEntry(220, value, ((ConfigObjectImpl.Advanced.Filtering)config).filteringRules, defaultValue, saveConsumer, list -> {
                ((ConfigObjectImpl.Advanced.Filtering)config).filteringRules = Lists.newArrayList((Iterable)list);
            }));
        }, field -> field.getType() == List.class, new Class[]{ConfigObjectImpl.UseFilteringScreen.class});
        this.saveConfig();
        RoughlyEnoughItemsCore.LOGGER.info("Config loaded.");
    }

    private static Jankson buildJankson(Jankson.Builder builder) {
        builder.registerSerializer(InputConstants.Key.class, (value, marshaller) -> new JsonPrimitive((Object)value.m_84874_()));
        builder.registerDeserializer(String.class, InputConstants.Key.class, (value, marshaller) -> InputConstants.m_84851_((String)value));
        builder.registerSerializer(ModifierKeyCode.class, (value, marshaller) -> {
            JsonObject object = new JsonObject();
            object.put("keyCode", (JsonElement)new JsonPrimitive((Object)value.getKeyCode().m_84874_()));
            object.put("modifier", (JsonElement)new JsonPrimitive((Object)value.getModifier().getValue()));
            return object;
        });
        builder.registerDeserializer(JsonObject.class, ModifierKeyCode.class, (value, marshaller) -> {
            String code = (String)value.get(String.class, "keyCode");
            if (code.endsWith(".unknown")) {
                return ModifierKeyCode.unknown();
            }
            InputConstants.Key keyCode = InputConstants.m_84851_((String)code);
            Modifier modifier = Modifier.of((short)value.getShort("modifier", (short)0));
            return ModifierKeyCode.of((InputConstants.Key)keyCode, (Modifier)modifier);
        });
        builder.registerSerializer(Tag.class, (value, marshaller) -> marshaller.serialize((Object)value.toString()));
        builder.registerDeserializer(String.class, Tag.class, (value, marshaller) -> {
            try {
                return TagParser.m_129359_((String)value);
            }
            catch (CommandSyntaxException e) {
                throw new DeserializationException((Throwable)e);
            }
        });
        builder.registerSerializer(EntryStackProvider.class, (stack, marshaller) -> {
            try {
                return marshaller.serialize((Object)stack.save());
            }
            catch (Exception e) {
                e.printStackTrace();
                return JsonNull.INSTANCE;
            }
        });
        builder.registerDeserializer(Tag.class, EntryStackProvider.class, (value, marshaller) -> EntryStackProvider.defer((CompoundTag)value));
        builder.registerDeserializer(String.class, EntryStackProvider.class, (value, marshaller) -> {
            try {
                return EntryStackProvider.defer(TagParser.m_129359_((String)value));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                return EntryStackProvider.ofStack(EntryStack.empty());
            }
        });
        builder.registerSerializer(FilteringRule.class, (value, marshaller) -> {
            try {
                return marshaller.serialize((Object)FilteringRule.save(value, new CompoundTag()));
            }
            catch (Exception e) {
                e.printStackTrace();
                return JsonNull.INSTANCE;
            }
        });
        builder.registerDeserializer(Tag.class, FilteringRule.class, (value, marshaller) -> {
            try {
                return FilteringRule.read((CompoundTag)value);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        builder.registerDeserializer(String.class, FilteringRule.class, (value, marshaller) -> {
            try {
                return FilteringRule.read(TagParser.m_129359_((String)value));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        builder.registerSerializer(FavoriteEntry.class, (value, marshaller) -> {
            try {
                return marshaller.serialize((Object)value.save(new CompoundTag()));
            }
            catch (Exception e) {
                e.printStackTrace();
                return JsonNull.INSTANCE;
            }
        });
        builder.registerDeserializer(Tag.class, FavoriteEntry.class, (value, marshaller) -> FavoriteEntry.readDelegated((CompoundTag)value));
        builder.registerDeserializer(String.class, FavoriteEntry.class, (value, marshaller) -> {
            try {
                CompoundTag tag = TagParser.m_129359_((String)value);
                return FavoriteEntry.readDelegated(tag);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        return builder.build();
    }

    @Override
    public void startReload() {
    }

    public static ConfigManagerImpl getInstance() {
        return (ConfigManagerImpl)ConfigManager.getInstance();
    }

    @Override
    public void saveConfig() {
        if (this.getConfig().getFavoriteEntries() != null) {
            this.getConfig().getFavoriteEntries().removeIf(Objects::isNull);
        }
        if (this.getConfig().getFilteringRules().stream().noneMatch(filteringRule -> filteringRule instanceof ManualFilteringRule)) {
            this.getConfig().getFilteringRules().add(new ManualFilteringRule());
        }
        AutoConfig.getConfigHolder(ConfigObjectImpl.class).registerLoadListener((configHolder, configObject) -> {
            this.object = configObject;
            return InteractionResult.PASS;
        });
        AutoConfig.getConfigHolder(ConfigObjectImpl.class).save();
    }

    @Override
    public ConfigObjectImpl getConfig() {
        if (this.object == null) {
            this.object = (ConfigObjectImpl)AutoConfig.getConfigHolder(ConfigObjectImpl.class).getConfig();
        }
        return this.object;
    }

    @Override
    public boolean isCraftableOnlyEnabled() {
        return this.craftableOnly;
    }

    @Override
    public void toggleCraftableOnly() {
        this.craftableOnly = !this.craftableOnly;
    }

    @Override
    public Screen getConfigScreen(Screen parent) {
        try {
            ConfigScreenProvider provider = (ConfigScreenProvider)AutoConfig.getConfigScreen(ConfigObjectImpl.class, (Screen)parent);
            provider.setI13nFunction(manager -> "config.roughlyenoughitems");
            provider.setOptionFunction((baseI13n, field) -> field.isAnnotationPresent(ConfigObjectImpl.DontApplyFieldName.class) ? baseI13n : String.format("%s.%s", baseI13n, field.getName()));
            provider.setCategoryFunction((baseI13n, categoryName) -> String.format("%s.%s", baseI13n, categoryName));
            provider.setBuildFunction(builder -> {
                builder.setGlobalized(true);
                builder.setGlobalizedExpanded(false);
                if (Minecraft.m_91087_().m_91403_() != null && Minecraft.m_91087_().m_91403_().m_105141_() != null) {
                    builder.getOrCreateCategory((Component)new TranslatableComponent("config.roughlyenoughitems.advanced")).getEntries().add(0, new ReloadPluginsEntry(220));
                    builder.getOrCreateCategory((Component)new TranslatableComponent("config.roughlyenoughitems.advanced")).getEntries().add(0, new PerformanceEntry(220));
                }
                return builder.setAfterInitConsumer(screen -> {
                    TextListEntry feedbackEntry = ConfigEntryBuilder.create().startTextDescription((Component)new TranslatableComponent("text.rei.feedback", new Object[]{new TranslatableComponent("text.rei.feedback.link").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)-14695425)).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://forms.gle/5tdnK5WN1wng78pV8")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new ImmutableTextComponent("https://forms.gle/5tdnK5WN1wng78pV8"))))}).m_130940_(ChatFormatting.GRAY)).build();
                    feedbackEntry.setScreen((AbstractConfigScreen)screen);
                    ((GlobalizedClothConfigScreen)screen).listWidget.m_6702_().add(0, feedbackEntry);
                    class EmptyEntry
                    extends AbstractConfigListEntry<Object> {
                        private final int height;

                        public EmptyEntry(int height) {
                            super((Component)new TextComponent(UUID.randomUUID().toString()), false);
                            this.height = height;
                        }

                        public int getItemHeight() {
                            return this.height;
                        }

                        public Object getValue() {
                            return null;
                        }

                        public Optional<Object> getDefaultValue() {
                            return Optional.empty();
                        }

                        public boolean isMouseInside(int mouseX, int mouseY, int x, int y, int entryWidth, int entryHeight) {
                            return false;
                        }

                        public void save() {
                        }

                        public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
                        }

                        public List<? extends GuiEventListener> m_6702_() {
                            return Collections.emptyList();
                        }

                        public List<? extends NarratableEntry> narratables() {
                            return Collections.emptyList();
                        }
                    }
                    ((GlobalizedClothConfigScreen)screen).listWidget.m_6702_().add(0, new EmptyEntry(4));
                    ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)new Button(screen.f_96543_ - 104, 4, 100, 20, (Component)new TranslatableComponent("text.rei.credits"), button -> {
                        MutableLong current = new MutableLong(0L);
                        CreditsScreen creditsScreen = new CreditsScreen((Screen)screen);
                        Minecraft.m_91087_().m_91152_((Screen)creditsScreen);
                    }));
                }).setSavingRunnable(() -> {
                    this.saveConfig();
                    EntryRegistry.getInstance().refilter();
                    REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
                    if (REIRuntimeImpl.getSearchField() != null) {
                        ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
                    }
                }).build();
            });
            return provider.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

