/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.transfer.info.simple;

import com.google.common.base.MoreObjects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.transfer.RecipeFinderPopulator;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.clean.InputCleanHandler;
import me.shedaniel.rei.api.common.transfer.info.simple.DumpHandler;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public interface SimplePlayerInventoryMenuInfo<T extends AbstractContainerMenu, D extends Display>
extends MenuInfo<T, D> {
    @Override
    default public RecipeFinderPopulator<T, D> getRecipeFinderPopulator() {
        return (context, finder) -> {
            for (SlotAccessor inventoryStack : this.getInventorySlots(context)) {
                finder.addNormalItem(inventoryStack.getItemStack());
            }
            this.populateRecipeFinder(context.getMenu(), finder);
        };
    }

    @Override
    default public InputCleanHandler<T, D> getInputCleanHandler() {
        return context -> {
            Object container = context.getMenu();
            for (SlotAccessor gridStack : this.getInputSlots(context)) {
                InputCleanHandler.returnSlotsToPlayerInventory(context, this.getDumpHandler(), gridStack);
            }
            this.clearInputSlots(container);
        };
    }

    default public DumpHandler<T, D> getDumpHandler() {
        return (context, stackToDump) -> {
            Iterable<SlotAccessor> inventoryStacks = this.getInventorySlots(context);
            SlotAccessor nextSlot = (SlotAccessor)MoreObjects.firstNonNull((Object)DumpHandler.getOccupiedSlotWithRoomForStack(stackToDump, inventoryStacks), (Object)DumpHandler.getEmptySlot(inventoryStacks));
            if (nextSlot == null) {
                return false;
            }
            ItemStack stack = stackToDump.m_41777_();
            stack.m_41764_(nextSlot.getItemStack().m_41613_() + stack.m_41613_());
            nextSlot.setItemStack(stack);
            return true;
        };
    }

    @Override
    default public Iterable<SlotAccessor> getInventorySlots(MenuInfoContext<T, ?, D> context) {
        Inventory inventory = context.getPlayerEntity().m_150109_();
        return IntStream.range(0, inventory.f_35974_.size()).mapToObj(index -> SlotAccessor.fromContainer((Container)inventory, index)).collect(Collectors.toList());
    }

    default public void populateRecipeFinder(T menu, RecipeFinder finder) {
    }

    default public void clearInputSlots(T menu) {
    }
}

