/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.registry.transfer;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerErrorRenderer;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRenderer;
import me.shedaniel.rei.api.common.display.Display;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public interface TransferHandler
extends Comparable<TransferHandler> {
    default public double getPriority() {
        return 0.0;
    }

    public Result handle(Context var1);

    @Override
    default public int compareTo(TransferHandler o) {
        return Double.compare(this.getPriority(), o.getPriority());
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    @ApiStatus.ScheduledForRemoval
    default public TransferHandlerErrorRenderer provideErrorRenderer(Context context, Object data) {
        return null;
    }

    @ApiStatus.Internal
    public static final class ContextImpl
    implements Context {
        private boolean actuallyCrafting;
        private boolean stackedCrafting;
        private AbstractContainerScreen<?> containerScreen;
        private Supplier<Display> recipeDisplaySupplier;

        private ContextImpl(boolean actuallyCrafting, boolean stackedCrafting, AbstractContainerScreen<?> containerScreen, Supplier<Display> recipeDisplaySupplier) {
            this.actuallyCrafting = actuallyCrafting;
            this.stackedCrafting = stackedCrafting;
            this.containerScreen = containerScreen;
            this.recipeDisplaySupplier = recipeDisplaySupplier;
        }

        @Override
        public boolean isActuallyCrafting() {
            return this.actuallyCrafting;
        }

        @Override
        public boolean isStackedCrafting() {
            return this.stackedCrafting;
        }

        @Override
        public AbstractContainerScreen<?> getContainerScreen() {
            return this.containerScreen;
        }

        @Override
        public Display getDisplay() {
            return this.recipeDisplaySupplier.get();
        }
    }

    @ApiStatus.Internal
    public static final class ResultImpl
    implements Result {
        private boolean successful;
        private boolean applicable;
        private boolean returningToScreen;
        private boolean blocking;
        private Component error;
        private Object errorRenderer;
        private BiConsumer<Point, Result.TooltipSink> tooltipRenderer;
        private int color;

        private ResultImpl() {
            this(true, true);
        }

        public ResultImpl(boolean applicable) {
            this(false, applicable);
        }

        public ResultImpl(boolean successful, boolean applicable) {
            this.successful = successful;
            this.applicable = applicable;
        }

        public ResultImpl(Component error, int color) {
            this.successful = false;
            this.applicable = true;
            this.error = error;
            this.color = color;
        }

        @Override
        public Result blocksFurtherHandling(boolean returningToScreen) {
            this.blocking = true;
            this.returningToScreen = returningToScreen;
            return this;
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public Result color(int color) {
            this.color = color;
            return this;
        }

        @Override
        public Result errorRenderer(Object data) {
            this.errorRenderer = data;
            return this;
        }

        @Override
        public Result renderer(TransferHandlerRenderer renderer) {
            this.errorRenderer = renderer;
            return this;
        }

        @Override
        public Result overrideTooltipRenderer(BiConsumer<Point, Result.TooltipSink> renderer) {
            this.tooltipRenderer = renderer;
            return this;
        }

        @Override
        public boolean isSuccessful() {
            return this.successful;
        }

        @Override
        public boolean isBlocking() {
            return this.successful || this.blocking;
        }

        @Override
        public boolean isApplicable() {
            return this.applicable;
        }

        @Override
        public boolean isReturningToScreen() {
            return this.returningToScreen;
        }

        @Override
        public Component getError() {
            return this.error;
        }

        @Override
        public TransferHandlerRenderer getRenderer(TransferHandler handler, Context context) {
            if (this.errorRenderer == null) {
                return null;
            }
            if (this.errorRenderer instanceof TransferHandlerRenderer) {
                return (TransferHandlerRenderer)this.errorRenderer;
            }
            if (this.isSuccessful()) {
                return null;
            }
            TransferHandlerErrorRenderer renderer = handler.provideErrorRenderer(context, this.errorRenderer);
            return renderer == null ? null : renderer.asNew();
        }

        @Override
        public BiConsumer<Point, Result.TooltipSink> getTooltipRenderer() {
            return this.tooltipRenderer;
        }

        @Override
        public void fillTooltip(List<Component> components) {
            if (!this.isSuccessful() && this.isApplicable()) {
                components.add(this.getError());
            }
        }
    }

    @ApiStatus.NonExtendable
    public static interface Context {
        @Deprecated
        @ApiStatus.ScheduledForRemoval
        public static Context create(boolean actuallyCrafting, @Nullable AbstractContainerScreen<?> containerScreen, Display display) {
            return Context.create(actuallyCrafting, Screen.m_96638_(), containerScreen, display);
        }

        public static Context create(boolean actuallyCrafting, boolean stackedCrafting, @Nullable AbstractContainerScreen<?> containerScreen, Display display) {
            return new ContextImpl(actuallyCrafting, stackedCrafting, containerScreen, () -> display);
        }

        default public Minecraft getMinecraft() {
            return Minecraft.m_91087_();
        }

        public boolean isActuallyCrafting();

        public boolean isStackedCrafting();

        public Display getDisplay();

        @Nullable
        public AbstractContainerScreen<?> getContainerScreen();

        @Nullable
        default public AbstractContainerMenu getMenu() {
            return this.getContainerScreen() == null ? null : this.getContainerScreen().m_6262_();
        }
    }

    @ApiStatus.NonExtendable
    public static interface Result {
        public static Result createSuccessful() {
            return new ResultImpl().color(0);
        }

        public static Result createNotApplicable() {
            return new ResultImpl(false).color(0);
        }

        public static Result createFailed(Component error) {
            return new ResultImpl(error, 1744764928);
        }

        public static Result createFailedCustomButtonColor(Component error, int color) {
            return Result.createFailed(error).color(color);
        }

        default public Result blocksFurtherHandling() {
            return this.blocksFurtherHandling(true);
        }

        public Result blocksFurtherHandling(boolean var1);

        public int getColor();

        public Result color(int var1);

        @Deprecated
        public Result errorRenderer(Object var1);

        public Result renderer(TransferHandlerRenderer var1);

        @ApiStatus.Experimental
        public Result overrideTooltipRenderer(BiConsumer<Point, TooltipSink> var1);

        public boolean isSuccessful();

        public boolean isBlocking();

        public boolean isReturningToScreen();

        public boolean isApplicable();

        public Component getError();

        @OnlyIn(value=Dist.CLIENT)
        @ApiStatus.Internal
        public TransferHandlerRenderer getRenderer(TransferHandler var1, Context var2);

        @OnlyIn(value=Dist.CLIENT)
        @ApiStatus.Internal
        public BiConsumer<Point, TooltipSink> getTooltipRenderer();

        @ApiStatus.Internal
        public void fillTooltip(List<Component> var1);

        @FunctionalInterface
        public static interface TooltipSink {
            public void accept(Tooltip var1);
        }
    }
}

