/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.drag;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface DraggableStackVisitor<T extends Screen>
extends Comparable<DraggableStackVisitor<T>> {
    public static <T extends Screen> DraggableStackVisitor<T> from(final Supplier<Iterable<DraggableStackVisitor<T>>> visitors) {
        return new DraggableStackVisitor<T>(){

            @Override
            public <R extends Screen> boolean isHandingScreen(R screen) {
                for (DraggableStackVisitor visitor : (Iterable)visitors.get()) {
                    if (!visitor.isHandingScreen(screen)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public DraggedAcceptorResult acceptDraggedStack(DraggingContext<T> context, DraggableStack stack) {
                for (DraggableStackVisitor visitor : (Iterable)visitors.get()) {
                    DraggedAcceptorResult result;
                    if (!visitor.isHandingScreen(context.getScreen()) || (result = Objects.requireNonNull(visitor.acceptDraggedStack(context, stack))) == DraggedAcceptorResult.PASS) continue;
                    return result;
                }
                return DraggedAcceptorResult.PASS;
            }

            @Override
            public Stream<BoundsProvider> getDraggableAcceptingBounds(DraggingContext<T> context, DraggableStack stack) {
                return StreamSupport.stream(((Iterable)visitors.get()).spliterator(), false).filter(visitor -> visitor.isHandingScreen(context.getScreen())).flatMap(visitor -> visitor.getDraggableAcceptingBounds(context, stack));
            }
        };
    }

    default public DraggedAcceptorResult acceptDraggedStack(DraggingContext<T> context, DraggableStack stack) {
        return DraggedAcceptorResult.PASS;
    }

    default public Stream<BoundsProvider> getDraggableAcceptingBounds(DraggingContext<T> context, DraggableStack stack) {
        return Stream.empty();
    }

    public <R extends Screen> boolean isHandingScreen(R var1);

    default public DraggingContext<T> getContext() {
        return DraggingContext.getInstance().cast();
    }

    default public double getPriority() {
        return 0.0;
    }

    @Override
    default public int compareTo(DraggableStackVisitor<T> o) {
        return Double.compare(this.getPriority(), o.getPriority());
    }

    @FunctionalInterface
    public static interface BoundsProvider {
        public static VoxelShape fromRectangle(Rectangle bounds) {
            return Shapes.m_83048_((double)bounds.x, (double)bounds.y, (double)0.0, (double)bounds.getMaxX(), (double)bounds.getMaxY(), (double)0.1);
        }

        public static BoundsProvider ofRectangle(Rectangle bounds) {
            return BoundsProvider.ofShape(BoundsProvider.fromRectangle(bounds));
        }

        public static BoundsProvider ofRectangles(Iterable<Rectangle> bounds) {
            VoxelShape shape = StreamSupport.stream(bounds.spliterator(), false).map(BoundsProvider::fromRectangle).reduce(Shapes.m_83040_(), Shapes::m_83110_);
            return BoundsProvider.ofShape(shape);
        }

        public static BoundsProvider ofShape(VoxelShape shape) {
            return () -> shape;
        }

        public static BoundsProvider ofShapes(Iterable<VoxelShape> shapes) {
            VoxelShape shape = StreamSupport.stream(shapes.spliterator(), false).reduce(Shapes.m_83040_(), Shapes::m_83110_);
            return BoundsProvider.ofShape(shape);
        }

        public static BoundsProvider empty() {
            return Shapes::m_83040_;
        }

        public static BoundsProvider concat(Iterable<BoundsProvider> providers) {
            return () -> StreamSupport.stream(providers.spliterator(), false).map(BoundsProvider::bounds).reduce(Shapes.m_83040_(), Shapes::m_83110_);
        }

        public VoxelShape bounds();
    }

    @FunctionalInterface
    public static interface Acceptor {
        public void accept(DraggableStack var1);
    }
}

