/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.lang;

import java.io.Serializable;
import java.math.BigInteger;

public final class UnsignedLong
implements Serializable,
Comparable<UnsignedLong> {
    private static final long serialVersionUID = 1L;
    public static final BigInteger MIN_VALUE = BigInteger.valueOf(0L);
    public static final BigInteger MAX_VALUE;
    public static final UnsignedLong ZERO;
    public static final UnsignedLong ONE;
    private static final BigInteger HIGHEST_BIT_VALUE;
    private final long m_value;

    private UnsignedLong(long value) {
        this.m_value = value;
    }

    public static UnsignedLong valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value == 1L) {
            return ONE;
        }
        return new UnsignedLong(value);
    }

    public static UnsignedLong valueOf(BigInteger value) throws IllegalArgumentException {
        if (value.compareTo(MIN_VALUE) < 0 || value.compareTo(MAX_VALUE) > 0) {
            throw new IllegalArgumentException("Illegal unsigned long value " + value + ". It must be between 0 and " + MAX_VALUE + " (inclusive)");
        }
        return UnsignedLong.valueOf(value.longValue());
    }

    public BigInteger bigIntValue() {
        BigInteger res = BigInteger.valueOf(this.m_value & Long.MAX_VALUE);
        return this.m_value < 0L ? res.add(HIGHEST_BIT_VALUE) : res;
    }

    public long longValue() {
        return this.m_value;
    }

    public byte[] getBigEndianByteArray() {
        byte[] res = new byte[]{(byte)(this.m_value & 0xFFL), (byte)(this.m_value >>> 8 & 0xFFL), (byte)(this.m_value >>> 16 & 0xFFL), (byte)(this.m_value >>> 24 & 0xFFL), (byte)(this.m_value >>> 32 & 0xFFL), (byte)(this.m_value >>> 40 & 0xFFL), (byte)(this.m_value >>> 48 & 0xFFL), (byte)(this.m_value >>> 56 & 0xFFL)};
        return res;
    }

    public static UnsignedLong fromBigEndianByteArray(byte[] barr) throws IllegalArgumentException {
        if (barr.length != 8) {
            throw new IllegalArgumentException("The supplied byte array must be eight bytes long");
        }
        return UnsignedLong.fromBigEndianByteArray(barr, 0);
    }

    public static UnsignedLong fromBigEndianByteArray(byte[] barr, int offset) throws ArrayIndexOutOfBoundsException {
        return UnsignedLong.valueOf(((long)barr[offset] & 0xFFL) + (((long)barr[offset + 1] & 0xFFL) << 8) + (((long)barr[offset + 2] & 0xFFL) << 16) + (((long)barr[offset + 3] & 0xFFL) << 24) + (((long)barr[offset + 4] & 0xFFL) << 32) + (((long)barr[offset + 5] & 0xFFL) << 40) + (((long)barr[offset + 6] & 0xFFL) << 48) + (((long)barr[offset + 7] & 0xFFL) << 56));
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof UnsignedLong) {
            return this.m_value == ((UnsignedLong)o).m_value;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.m_value ^ this.m_value >>> 32);
    }

    @Override
    public int compareTo(UnsignedLong l2) {
        return this.bigIntValue().compareTo(l2.bigIntValue());
    }

    public String toString() {
        return this.bigIntValue().toString();
    }

    static {
        ZERO = new UnsignedLong(0L);
        ONE = new UnsignedLong(1L);
        BigInteger mv = BigInteger.valueOf(2L);
        MAX_VALUE = mv.pow(64).subtract(BigInteger.ONE);
        HIGHEST_BIT_VALUE = mv.pow(63);
    }
}

