/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.lang;

public class SignedLong
implements Comparable<SignedLong> {
    public static final SignedLong ZERO = new SignedLong(0L);
    public static final SignedLong ONE = new SignedLong(1L);
    private final long m_value;

    private SignedLong(long value) {
        this.m_value = value;
    }

    public static SignedLong valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value == 1L) {
            return ONE;
        }
        return new SignedLong(value);
    }

    public long longValue() {
        return this.m_value;
    }

    public byte[] getBigEndianByteArray() {
        byte[] res = new byte[]{(byte)this.m_value, (byte)(this.m_value >> 8), (byte)(this.m_value >> 16), (byte)(this.m_value >> 24), (byte)(this.m_value >> 32), (byte)(this.m_value >> 40), (byte)(this.m_value >> 48), (byte)(this.m_value >> 56)};
        return res;
    }

    public static SignedLong fromBigEndianByteArray(byte[] barr) throws IllegalArgumentException {
        if (barr.length != 8) {
            throw new IllegalArgumentException("Illegal size of supplied byte array: " + barr.length + ". It must be eight bytes long");
        }
        long value = barr[0] & 0xFF;
        value += ((long)barr[1] & 0xFFL) << 8;
        value += ((long)barr[2] & 0xFFL) << 16;
        value += ((long)barr[3] & 0xFFL) << 24;
        value += ((long)barr[4] & 0xFFL) << 32;
        value += ((long)barr[5] & 0xFFL) << 40;
        value += ((long)barr[6] & 0xFFL) << 48;
        return SignedLong.valueOf(value += ((long)barr[7] & 0xFFL) << 56);
    }

    public byte[] getLittleEndianByteArray() {
        byte[] res = new byte[]{(byte)(this.m_value >> 56), (byte)(this.m_value >> 48), (byte)(this.m_value >> 40), (byte)(this.m_value >> 32), (byte)(this.m_value >> 24), (byte)(this.m_value >> 16), (byte)(this.m_value >> 8), (byte)this.m_value};
        return res;
    }

    public static SignedLong fromLittleEndianByteArray(byte[] barr) throws IllegalArgumentException {
        if (barr.length != 8) {
            throw new IllegalArgumentException("Illegal size of supplied byte array: " + barr.length + ". It must be eight bytes long");
        }
        long value = barr[7] & 0xFF;
        value += ((long)barr[6] & 0xFFL) << 8;
        value += ((long)barr[5] & 0xFFL) << 16;
        value += ((long)barr[4] & 0xFFL) << 24;
        value += ((long)barr[3] & 0xFFL) << 32;
        value += ((long)barr[2] & 0xFFL) << 40;
        value += ((long)barr[1] & 0xFFL) << 48;
        return SignedLong.valueOf(value += ((long)barr[0] & 0xFFL) << 56);
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof SignedLong) {
            return this.m_value == ((SignedLong)o).m_value;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.m_value ^ this.m_value >>> 32);
    }

    @Override
    public int compareTo(SignedLong l2) {
        return Long.valueOf(this.m_value).compareTo(l2.m_value);
    }

    public String toString() {
        return "" + this.m_value;
    }
}

