/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.io.IOException;
import java.util.Arrays;
import org.at4j.comp.bzip2.EncodingScratchpad;
import org.at4j.support.io.BitInput;
import org.at4j.support.io.BitOutput;

final class HighValueBranchHuffmanTree {
    private static final int MAX_NO_OF_SYMBOLS = 258;
    private final int m_minLength;
    private final int m_maxLength;
    final int m_numberOfLengths;
    final int[] m_limitsPerLength;
    final int[] m_baseValuesPerLength;
    final int[] m_symbolOffsetPerLength;
    final int[] m_symbolSequenceNos;
    final int[][] m_huffmanCodesAndLengthsPerSymbol;

    private int[] getCodeAndLengthForSymbol(int symbol, int huffmanIndex, int[] codeAndLength) {
        int deltaLen;
        for (deltaLen = 0; deltaLen < this.m_numberOfLengths - 1 && huffmanIndex >= this.m_symbolOffsetPerLength[deltaLen + 1]; ++deltaLen) {
        }
        codeAndLength[0] = this.m_baseValuesPerLength[deltaLen] + (huffmanIndex - this.m_symbolOffsetPerLength[deltaLen]);
        codeAndLength[1] = this.m_minLength + deltaLen;
        return codeAndLength;
    }

    HighValueBranchHuffmanTree(int[] symbolLengths, int minLength, int maxLength, boolean forEncoding) throws IllegalArgumentException {
        int i;
        if (minLength < 0 || maxLength < minLength) {
            throw new IllegalArgumentException("Illegal min or max length, min: " + minLength + ", max: " + maxLength);
        }
        int numberOfSymbols = symbolLengths.length;
        int numberOfLengths = maxLength - minLength + 1;
        this.m_symbolSequenceNos = new int[numberOfSymbols];
        int[] numl = new int[numberOfLengths];
        int index = 0;
        for (i = minLength; i <= maxLength; ++i) {
            numl[i - minLength] = 0;
            for (int j = 0; j < numberOfSymbols; ++j) {
                if (symbolLengths[j] != i) continue;
                this.m_symbolSequenceNos[index++] = j;
                int n = i - minLength;
                numl[n] = numl[n] + 1;
            }
        }
        this.m_symbolOffsetPerLength = new int[numberOfLengths];
        this.m_symbolOffsetPerLength[0] = 0;
        for (i = 0; i < numberOfLengths - 1; ++i) {
            this.m_symbolOffsetPerLength[i + 1] = this.m_symbolOffsetPerLength[i] + numl[i];
        }
        this.m_limitsPerLength = new int[numberOfLengths - 1];
        this.m_baseValuesPerLength = new int[numberOfLengths];
        int prevLimit = 0;
        for (int i2 = minLength; i2 <= maxLength; ++i2) {
            index = i2 - minLength;
            this.m_baseValuesPerLength[index] = prevLimit << 1;
            if (i2 >= maxLength) continue;
            prevLimit = this.m_baseValuesPerLength[index] + numl[index];
            this.m_limitsPerLength[index] = prevLimit - 1;
        }
        this.m_minLength = minLength;
        this.m_maxLength = maxLength;
        this.m_numberOfLengths = (byte)(maxLength - minLength + 1);
        if (forEncoding) {
            int[] huffmanIndexPerSymbol = new int[symbolLengths.length];
            Arrays.fill(huffmanIndexPerSymbol, -1);
            for (int i3 = 0; i3 < this.m_symbolSequenceNos.length; ++i3) {
                huffmanIndexPerSymbol[this.m_symbolSequenceNos[i3]] = i3;
            }
            this.m_huffmanCodesAndLengthsPerSymbol = new int[symbolLengths.length][2];
            int[] codeAndLength = new int[2];
            for (int i4 = 0; i4 < symbolLengths.length; ++i4) {
                codeAndLength = this.getCodeAndLengthForSymbol(i4, huffmanIndexPerSymbol[i4], codeAndLength);
                this.m_huffmanCodesAndLengthsPerSymbol[i4][0] = codeAndLength[0];
                this.m_huffmanCodesAndLengthsPerSymbol[i4][1] = codeAndLength[1];
            }
        } else {
            this.m_huffmanCodesAndLengthsPerSymbol = null;
        }
    }

    private static void upHeap(int[] heap, int[] weight, int nHeap) {
        int tmp = heap[nHeap];
        while (weight[tmp] < weight[heap[nHeap >> 1]]) {
            heap[nHeap] = heap[nHeap >>> 1];
            nHeap >>>= 1;
        }
        heap[nHeap] = tmp;
    }

    private static void downHeap(int[] heap, int[] weight, int nHeap, int n) {
        int yy;
        int tmp = heap[n];
        while ((yy = n << 1) <= nHeap) {
            if (yy < nHeap && weight[heap[yy + 1]] < weight[heap[yy]]) {
                ++yy;
            }
            if (weight[tmp] < weight[heap[yy]]) break;
            heap[n] = heap[yy];
            n = yy;
        }
        heap[n] = tmp;
    }

    private static int addWeights(int w1, int w2) {
        int d1 = w1 & 0xFF;
        int d2 = w2 & 0xFF;
        int ww1 = w1 & 0xFFFFFF00;
        int ww2 = w2 & 0xFFFFFF00;
        return ww1 + ww2 | 1 + Math.max(d1, d2);
    }

    int getMinLength() {
        return this.m_minLength;
    }

    int getMaxLength() {
        return this.m_maxLength;
    }

    int[][] getSortedSymbolSequenceNosAndCodeLengths() {
        int[][] res = new int[this.m_symbolSequenceNos.length][2];
        int length = this.m_minLength;
        for (int i = 0; i < this.m_symbolSequenceNos.length; ++i) {
            while (length < this.m_maxLength && i >= this.m_symbolOffsetPerLength[length - this.m_minLength + 1]) {
                ++length;
            }
            res[i][0] = this.m_symbolSequenceNos[i];
            res[i][1] = length;
        }
        return res;
    }

    int readNext(BitInput in) throws IOException {
        int code = in.readBits(this.m_minLength);
        if (this.m_limitsPerLength.length == 0 || code <= this.m_limitsPerLength[0]) {
            return this.m_symbolSequenceNos[code];
        }
        int codeLength = this.m_minLength;
        int index = 1;
        while (true) {
            code = code << 1 | (in.readBit() ? 1 : 0);
            if (++codeLength == this.m_maxLength || code <= this.m_limitsPerLength[index]) {
                return this.m_symbolSequenceNos[this.m_symbolOffsetPerLength[index] + (code - this.m_baseValuesPerLength[index])];
            }
            ++index;
        }
    }

    void write(BitOutput out, int symbol) throws IOException {
        out.writeBitsLittleEndian(this.m_huffmanCodesAndLengthsPerSymbol[symbol][0], this.m_huffmanCodesAndLengthsPerSymbol[symbol][1]);
    }

    int getBitLength(int symbol) {
        return this.m_huffmanCodesAndLengthsPerSymbol[symbol][1];
    }

    static int[] createCodeLengths(int[] frequencies, int noSymbols, int maxLength, EncodingScratchpad scratchpad) {
        int[] heap = scratchpad.m_htHeap;
        int[] weight = scratchpad.m_htWeight;
        int[] parent = scratchpad.m_htParent;
        int[] res = new int[noSymbols];
        int actualMaxLength = -1;
        int actualMinLength = Integer.MAX_VALUE;
        for (int i = 0; i < noSymbols; ++i) {
            weight[i + 1] = (frequencies[i] == 0 ? 1 : frequencies[i]) << 8;
        }
        block1: while (true) {
            int j;
            int i;
            int noNodes = noSymbols;
            int nHeap = 0;
            heap[0] = 0;
            weight[0] = 0;
            parent[0] = -2;
            int i2 = 1;
            while (i2 <= noSymbols) {
                parent[i2] = -1;
                heap[++nHeap] = i2++;
                HighValueBranchHuffmanTree.upHeap(heap, weight, nHeap);
            }
            assert (nHeap < 260);
            while (nHeap > 1) {
                int n1 = heap[1];
                heap[1] = heap[nHeap];
                HighValueBranchHuffmanTree.downHeap(heap, weight, --nHeap, 1);
                int n2 = heap[1];
                heap[1] = heap[nHeap];
                HighValueBranchHuffmanTree.downHeap(heap, weight, --nHeap, 1);
                parent[n1] = parent[n2] = ++noNodes;
                weight[noNodes] = HighValueBranchHuffmanTree.addWeights(weight[n1], weight[n2]);
                parent[noNodes] = -1;
                heap[++nHeap] = noNodes;
                HighValueBranchHuffmanTree.upHeap(heap, weight, nHeap);
            }
            assert (noNodes < 516);
            boolean tooLong = false;
            for (i = 1; i <= noSymbols; ++i) {
                j = 0;
                int k = i;
                while (parent[k] >= 0) {
                    k = parent[k];
                    ++j;
                }
                res[i - 1] = j;
                if (j > maxLength) {
                    tooLong = true;
                    break;
                }
                if (j > actualMaxLength) {
                    actualMaxLength = j;
                }
                if (j >= actualMinLength) continue;
                actualMinLength = j;
            }
            if (!tooLong) break;
            i = 1;
            while (true) {
                if (i > noSymbols) continue block1;
                j = weight[i] >> 8;
                j = 1 + j / 2;
                weight[i] = j << 8;
                ++i;
            }
            break;
        }
        return res;
    }
}

