/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.at4j.comp.bzip2.BZip2EncoderExecutorServiceImpl;
import org.at4j.comp.bzip2.BlockEncodedCallback;
import org.at4j.comp.bzip2.BlockEncoder;
import org.at4j.comp.bzip2.BlockEncoderRunnable;
import org.at4j.comp.bzip2.CRC;
import org.at4j.comp.bzip2.EncodedBlockWriter;
import org.at4j.comp.bzip2.EncodingScratchpad;
import org.at4j.support.io.BitOutput;
import org.at4j.support.io.LittleEndianBitOutputStream;

final class BlockOutputStream
extends OutputStream {
    private static final int MAX_NO_OF_RLE_REPEATS = 251;
    private RLEState m_rleState;
    private int m_last = -1;
    private int m_numberOfSame;
    private final BitOutput m_wrapped;
    private final int m_blockSize;
    private final int m_numberOfHuffmanTreeRefinementIterations;
    private boolean[] m_seenDifferentBytesInCurBlock;
    private byte[] m_block;
    private final BZip2EncoderExecutorServiceImpl m_encodingExecutor;
    private final Object m_errorOwner;
    private final EncodingScratchpad m_scratchpad;
    private final EncodedBlockWriter m_encodedBlockWriter;
    private CRC m_blockChecksum;
    private int m_fileChecksum = 0;
    private int m_noSeenDifferentBytesInCurBlock;
    private int m_blockPointer;
    private int m_blockNo = 0;

    BlockOutputStream(BitOutput wrapped, int blockSize, int numberOfHuffmanTreeRefinementIterations, BZip2EncoderExecutorServiceImpl ex, Object errorOwner, EncodedBlockWriter ebw, EncodingScratchpad sp) {
        assert (ex == null ^ sp == null);
        this.m_wrapped = wrapped;
        this.m_blockSize = blockSize;
        this.m_numberOfHuffmanTreeRefinementIterations = numberOfHuffmanTreeRefinementIterations;
        this.m_blockChecksum = new CRC();
        this.m_scratchpad = sp;
        this.m_encodingExecutor = ex;
        this.m_errorOwner = errorOwner;
        this.m_encodedBlockWriter = ebw;
        this.startNewBlock();
    }

    private void startNewBlock() {
        this.m_blockPointer = 0;
        if (this.m_encodingExecutor != null) {
            this.m_seenDifferentBytesInCurBlock = new boolean[256];
            this.m_block = new byte[this.m_blockSize + 20];
        } else {
            if (this.m_seenDifferentBytesInCurBlock == null) {
                this.m_seenDifferentBytesInCurBlock = new boolean[256];
            } else {
                Arrays.fill(this.m_seenDifferentBytesInCurBlock, false);
            }
            if (this.m_block == null) {
                this.m_block = new byte[this.m_blockSize + 20];
            }
        }
        this.m_noSeenDifferentBytesInCurBlock = 0;
        this.m_last = -1;
        this.m_numberOfSame = 0;
        this.m_rleState = RLEState.ENCODING_SINGLE;
    }

    private boolean isFull() {
        return this.m_blockPointer == this.m_blockSize;
    }

    private boolean isEmpty() {
        return this.m_blockPointer == 0;
    }

    int getFileChecksum() {
        return this.m_fileChecksum;
    }

    private void writeCurBlock() throws IOException {
        int blockChecksum = this.m_blockChecksum.getValue();
        this.m_blockChecksum = new CRC();
        if (this.m_encodingExecutor == null) {
            BlockEncoder be = new BlockEncoder(this.m_block, this.m_blockNo, this.m_blockPointer, blockChecksum, this.m_seenDifferentBytesInCurBlock, this.m_noSeenDifferentBytesInCurBlock, this.m_numberOfHuffmanTreeRefinementIterations, this.m_wrapped, null);
            be.setScratchpad(this.m_scratchpad);
            be.encode();
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(2 * this.m_blockPointer / 3);
            LittleEndianBitOutputStream out = new LittleEndianBitOutputStream(baos);
            BlockEncodedCallback bec = new BlockEncodedCallback(this.m_blockNo, baos, out, this.m_encodedBlockWriter);
            BlockEncoder be = new BlockEncoder(this.m_block, this.m_blockNo, this.m_blockPointer, blockChecksum, this.m_seenDifferentBytesInCurBlock, this.m_noSeenDifferentBytesInCurBlock, this.m_numberOfHuffmanTreeRefinementIterations, out, bec);
            this.m_encodingExecutor.execute(new BlockEncoderRunnable(be, this.m_errorOwner));
        }
        this.m_fileChecksum = this.m_fileChecksum << 1 | this.m_fileChecksum >>> 31;
        this.m_fileChecksum ^= blockChecksum;
        ++this.m_blockNo;
    }

    private void writeByte(int b) throws IOException {
        this.m_block[this.m_blockPointer++] = (byte)(b & 0xFF);
        if (!this.m_seenDifferentBytesInCurBlock[b]) {
            this.m_seenDifferentBytesInCurBlock[b] = true;
            ++this.m_noSeenDifferentBytesInCurBlock;
        }
        if (this.isFull()) {
            this.writeCurBlock();
            this.startNewBlock();
        }
    }

    @Override
    public void write(int b) throws IOException {
        switch (this.m_rleState) {
            case ENCODING_SINGLE: {
                if (b == this.m_last) {
                    ++this.m_numberOfSame;
                    if (this.m_numberOfSame == 4) {
                        if (this.m_blockPointer == this.m_blockSize - 1) {
                            this.writeCurBlock();
                            this.startNewBlock();
                            this.write(b);
                            return;
                        }
                        this.m_rleState = RLEState.COUNTING_MULTIPLE;
                        this.m_numberOfSame = 0;
                    }
                } else {
                    this.m_last = b;
                    this.m_numberOfSame = 1;
                }
                this.m_blockChecksum.update(b);
                this.writeByte(b);
                break;
            }
            case COUNTING_MULTIPLE: {
                if (b == this.m_last) {
                    ++this.m_numberOfSame;
                    if (this.m_numberOfSame != 251) break;
                    for (int i = 0; i < 251; ++i) {
                        this.m_blockChecksum.update(b);
                    }
                    this.writeByte(251);
                    this.m_rleState = RLEState.ENCODING_SINGLE;
                    this.m_numberOfSame = 0;
                    break;
                }
                for (int i = 0; i < this.m_numberOfSame; ++i) {
                    this.m_blockChecksum.update(this.m_last);
                }
                this.writeByte(this.m_numberOfSame);
                this.m_blockChecksum.update(b);
                this.writeByte(b);
                this.m_numberOfSame = 1;
                this.m_last = b;
                this.m_rleState = RLEState.ENCODING_SINGLE;
                break;
            }
            default: {
                throw new RuntimeException("Unknown encoding state " + this.m_rleState + ". This is a bug");
            }
        }
    }

    @Override
    public void write(byte[] data) throws IOException {
        for (byte datum : data) {
            this.write(datum & 0xFF);
        }
    }

    @Override
    public void write(byte[] data, int offset, int len) throws IOException {
        for (int i = offset; i < offset + len; ++i) {
            this.write(data[i] & 0xFF);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.m_rleState == RLEState.COUNTING_MULTIPLE) {
            for (int i = 0; i < this.m_numberOfSame; ++i) {
                this.m_blockChecksum.update(this.m_last & 0xFF);
            }
            this.writeByte(this.m_numberOfSame);
        }
        if (!this.isEmpty()) {
            this.writeCurBlock();
        }
        if (this.m_encodedBlockWriter != null) {
            this.m_encodedBlockWriter.writeBlock(this.m_blockNo, null);
        }
        super.close();
    }

    private static enum RLEState {
        ENCODING_SINGLE,
        COUNTING_MULTIPLE;

    }
}

