/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.at4j.comp.bzip2.BZip2EncoderExecutorService;
import org.at4j.comp.bzip2.BlockEncoderRunnable;
import org.at4j.comp.bzip2.EncodingThreadFactory;
import org.at4j.comp.bzip2.ErrorState;

final class BZip2EncoderExecutorServiceImpl
implements BZip2EncoderExecutorService {
    private final ThreadPoolExecutor m_executor;
    private final ErrorState m_errorState;

    BZip2EncoderExecutorServiceImpl(int noThreads, ErrorState es) {
        this.m_executor = new ThreadPoolExecutor(noThreads, noThreads, 100L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1), new EncodingThreadFactory(es), ShoehornInJobRejectedExecutionHandler.INSTANCE);
        this.m_errorState = es;
    }

    ErrorState getErrorState() {
        return this.m_errorState;
    }

    void execute(BlockEncoderRunnable r) {
        this.m_executor.execute(r);
    }

    @Override
    public void shutdown() {
        this.m_executor.shutdown();
    }

    private static class ShoehornInJobRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private static final ShoehornInJobRejectedExecutionHandler INSTANCE = new ShoehornInJobRejectedExecutionHandler();

        private ShoehornInJobRejectedExecutionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

