/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.restore.decompressors;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.time.Instant;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.core.Utilities;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;

public class ZipDecompressor {
    private static final TextileLogger log = new TextileLogger("Textile Backup");

    public static void decompress(File inputFile, File target) {
        Instant start = Instant.now();
        try (ZipFile zipFile = new ZipFile(inputFile);){
            zipFile.getEntries().asIterator().forEachRemaining(entry -> {
                File file = target.toPath().resolve(entry.getName()).toFile();
                if (entry.isDirectory()) {
                    file.mkdirs();
                } else {
                    File parent = file.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        log.error("Failed to create {}", parent);
                    } else {
                        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
                            IOUtils.copy((InputStream)zipFile.getInputStream(entry), (OutputStream)bufferedOutputStream);
                        }
                        catch (IOException e) {
                            log.error("An exception occurred while trying to decompress file: {}", entry.getName(), e);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            log.error("An exception occurred! ", e);
        }
        log.info("Decompression took: {} seconds.", Utilities.formatDuration(Duration.between(start, Instant.now())));
    }
}

