/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.restore.decompressors;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.time.Instant;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.core.Utilities;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;

public class GenericTarDecompressor {
    private static final TextileLogger log = new TextileLogger("Textile Backup");

    public static void decompress(File input, File target) {
        Instant start;
        block41: {
            start = Instant.now();
            try (FileInputStream fileInputStream = new FileInputStream(input);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                 InputStream compressorInputStream = GenericTarDecompressor.getCompressorInputStream(bufferedInputStream);){
                TarArchiveInputStream archiveInputStream = new TarArchiveInputStream(compressorInputStream);
                block34: while (true) {
                    TarArchiveEntry entry;
                    while ((entry = archiveInputStream.getNextTarEntry()) != null) {
                        if (!archiveInputStream.canReadEntryData((ArchiveEntry)entry)) {
                            log.error("Something when wrong while trying to decompress {}", entry.getName());
                            continue;
                        }
                        File file = target.toPath().resolve(entry.getName()).toFile();
                        if (entry.isDirectory()) {
                            file.mkdirs();
                            continue;
                        }
                        File parent = file.getParentFile();
                        if (!parent.isDirectory() && !parent.mkdirs()) {
                            log.error("Failed to create {}", parent);
                            continue;
                        }
                        try {
                            OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                            try {
                                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                                try {
                                    IOUtils.copy((InputStream)archiveInputStream, (OutputStream)bufferedOutputStream);
                                    continue block34;
                                }
                                finally {
                                    bufferedOutputStream.close();
                                    continue block34;
                                }
                            }
                            finally {
                                if (outputStream != null) {
                                    outputStream.close();
                                }
                                continue block34;
                            }
                        }
                        catch (IOException e) {
                            log.error("An exception occurred while trying to decompress file: {}", file.getName(), e);
                        }
                    }
                    break block41;
                    {
                        continue block34;
                        break;
                    }
                    break;
                }
                finally {
                    archiveInputStream.close();
                }
            }
            catch (IOException | CompressorException e) {
                log.error("An exception occurred! ", e);
            }
        }
        log.info("Decompression took {} seconds.", Utilities.formatDuration(Duration.between(start, Instant.now())));
    }

    private static InputStream getCompressorInputStream(InputStream inputStream) throws CompressorException {
        try {
            return new CompressorStreamFactory().createCompressorInputStream(inputStream);
        }
        catch (CompressorException e) {
            int signatureLength;
            byte[] tarHeader = new byte[512];
            inputStream.mark(tarHeader.length);
            try {
                signatureLength = IOUtils.readFully((InputStream)inputStream, (byte[])tarHeader);
                inputStream.reset();
            }
            catch (IOException e1) {
                throw new CompressorException("IOException while reading tar signature", (Throwable)e1);
            }
            if (TarArchiveInputStream.matches((byte[])tarHeader, (int)signatureLength)) {
                return inputStream;
            }
            throw e;
        }
    }
}

