/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.restore;

import java.io.File;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import net.szum123321.textile_backup.Statics;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.config.ConfigHelper;
import net.szum123321.textile_backup.config.ConfigPOJO;
import net.szum123321.textile_backup.core.ActionInitiator;
import net.szum123321.textile_backup.core.Utilities;
import net.szum123321.textile_backup.core.restore.AwaitThread;
import net.szum123321.textile_backup.core.restore.RestoreBackupRunnable;
import net.szum123321.textile_backup.core.restore.RestoreContext;
import org.jetbrains.annotations.NotNull;

public class RestoreHelper {
    private static final TextileLogger log = new TextileLogger("Textile Backup");
    private static final ConfigHelper config = ConfigHelper.INSTANCE;

    public static Optional<RestoreableFile> findFileAndLockIfPresent(LocalDateTime backupTime, MinecraftServer server) {
        File root = Utilities.getBackupRootPath(Utilities.getLevelName(server));
        Optional<RestoreableFile> optionalFile = Arrays.stream(root.listFiles()).map(RestoreableFile::newInstance).flatMap(Optional::stream).filter(rf -> rf.getCreationTime().equals(backupTime)).findFirst();
        Statics.untouchableFile = optionalFile.map(RestoreableFile::getFile);
        return optionalFile;
    }

    public static AwaitThread create(RestoreContext ctx) {
        if (ctx.getInitiator() == ActionInitiator.Player) {
            log.info("Backup restoration was initiated by: {}", ctx.getCommandSource().method_9214());
        } else {
            log.info("Backup restoration was initiated form Server Console", new Object[0]);
        }
        Utilities.notifyPlayers(ctx.server(), ctx.getInitiatorUUID(), "Warning! The server is going to shut down in " + RestoreHelper.config.get().restoreDelay + " seconds!");
        return new AwaitThread(RestoreHelper.config.get().restoreDelay, (Runnable)new RestoreBackupRunnable(ctx));
    }

    public static List<RestoreableFile> getAvailableBackups(MinecraftServer server) {
        File root = Utilities.getBackupRootPath(Utilities.getLevelName(server));
        return Arrays.stream(root.listFiles()).filter(Utilities::isValidBackup).map(RestoreableFile::newInstance).flatMap(Optional::stream).collect(Collectors.toList());
    }

    public static class RestoreableFile
    implements Comparable<RestoreableFile> {
        private final File file;
        private final ConfigPOJO.ArchiveFormat archiveFormat;
        private final LocalDateTime creationTime;
        private final String comment;

        private RestoreableFile(File file) throws NoSuchElementException {
            this.file = file;
            this.archiveFormat = Utilities.getArchiveExtension(file).orElseThrow(() -> new NoSuchElementException("Couldn't get file extension!"));
            String extension = this.archiveFormat.getCompleteString();
            this.creationTime = Utilities.getFileCreationTime(file).orElseThrow(() -> new NoSuchElementException("Couldn't get file creation time!"));
            String filename = file.getName();
            this.comment = filename.split("#").length > 1 ? filename.split("#")[1].split(extension)[0] : null;
        }

        public static Optional<RestoreableFile> newInstance(File file) {
            try {
                return Optional.of(new RestoreableFile(file));
            }
            catch (NoSuchElementException noSuchElementException) {
                return Optional.empty();
            }
        }

        public File getFile() {
            return this.file;
        }

        public ConfigPOJO.ArchiveFormat getArchiveFormat() {
            return this.archiveFormat;
        }

        public LocalDateTime getCreationTime() {
            return this.creationTime;
        }

        public String getComment() {
            return this.comment;
        }

        @Override
        public int compareTo(@NotNull RestoreableFile o) {
            return this.creationTime.compareTo(o.creationTime);
        }

        public String toString() {
            return this.getCreationTime().format(Statics.defaultDateTimeFormatter) + (String)(this.comment != null ? "#" + this.comment : "");
        }
    }
}

