/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.restore;

import java.io.File;
import net.szum123321.textile_backup.Statics;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.config.ConfigHelper;
import net.szum123321.textile_backup.config.ConfigPOJO;
import net.szum123321.textile_backup.core.ActionInitiator;
import net.szum123321.textile_backup.core.LivingServer;
import net.szum123321.textile_backup.core.Utilities;
import net.szum123321.textile_backup.core.create.BackupContext;
import net.szum123321.textile_backup.core.create.BackupHelper;
import net.szum123321.textile_backup.core.restore.RestoreContext;
import net.szum123321.textile_backup.core.restore.decompressors.GenericTarDecompressor;
import net.szum123321.textile_backup.core.restore.decompressors.ZipDecompressor;

public class RestoreBackupRunnable
implements Runnable {
    private static final TextileLogger log = new TextileLogger("Textile Backup");
    private static final ConfigHelper config = ConfigHelper.INSTANCE;
    private final RestoreContext ctx;

    public RestoreBackupRunnable(RestoreContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void run() {
        Statics.globalShutdownBackupFlag.set(false);
        log.info("Shutting down server...", new Object[0]);
        this.ctx.getServer().method_3747(false);
        this.awaitServerShutdown();
        if (RestoreBackupRunnable.config.get().backupOldWorlds) {
            BackupHelper.create(BackupContext.Builder.newBackupContextBuilder().setServer(this.ctx.getServer()).setInitiator(ActionInitiator.Restore).setComment("Old_World" + (String)(this.ctx.getComment() != null ? "_" + this.ctx.getComment() : "")).build()).run();
        }
        File worldFile = Utilities.getWorldFolder(this.ctx.getServer());
        log.info("Deleting old world...", new Object[0]);
        if (!RestoreBackupRunnable.deleteDirectory(worldFile)) {
            log.error("Something went wrong while deleting old world!", new Object[0]);
        }
        worldFile.mkdirs();
        log.info("Starting decompression...", new Object[0]);
        if (this.ctx.getFile().getArchiveFormat() == ConfigPOJO.ArchiveFormat.ZIP) {
            ZipDecompressor.decompress(this.ctx.getFile().getFile(), worldFile);
        } else {
            GenericTarDecompressor.decompress(this.ctx.getFile().getFile(), worldFile);
        }
        if (RestoreBackupRunnable.config.get().deleteOldBackupAfterRestore) {
            log.info("Deleting old backup", new Object[0]);
            if (!this.ctx.getFile().getFile().delete()) {
                log.info("Something went wrong while deleting old backup", new Object[0]);
            }
        }
        Statics.globalShutdownBackupFlag.set(true);
        log.info("Done!", new Object[0]);
    }

    private void awaitServerShutdown() {
        while (((LivingServer)this.ctx.getServer()).isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                log.error("Exception occurred!", e);
            }
        }
    }

    private static boolean deleteDirectory(File f) {
        boolean state = true;
        if (f.isDirectory()) {
            for (File f2 : f.listFiles()) {
                state &= RestoreBackupRunnable.deleteDirectory(f2);
            }
        }
        return f.delete() && state;
    }
}

