/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.create.compressors.tar;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.szum123321.textile_backup.core.create.BackupContext;
import net.szum123321.textile_backup.core.create.compressors.AbstractCompressor;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class AbstractTarArchiver
extends AbstractCompressor {
    protected OutputStream getCompressorOutputStream(OutputStream stream, BackupContext ctx, int coreLimit) throws IOException {
        return stream;
    }

    @Override
    protected OutputStream createArchiveOutputStream(OutputStream stream, BackupContext ctx, int coreLimit) throws IOException {
        TarArchiveOutputStream tar = new TarArchiveOutputStream(this.getCompressorOutputStream(stream, ctx, coreLimit));
        tar.setLongFileMode(3);
        tar.setBigNumberMode(2);
        return tar;
    }

    @Override
    protected void addEntry(File file, String entryName, OutputStream arc) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            TarArchiveEntry entry = (TarArchiveEntry)((TarArchiveOutputStream)arc).createArchiveEntry(file, entryName);
            ((TarArchiveOutputStream)arc).putArchiveEntry((ArchiveEntry)entry);
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)arc);
            ((TarArchiveOutputStream)arc).closeArchiveEntry();
        }
    }
}

