/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.create.compressors;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.zip.CRC32;
import net.szum123321.textile_backup.config.ConfigHelper;
import net.szum123321.textile_backup.core.Utilities;
import net.szum123321.textile_backup.core.create.BackupContext;
import net.szum123321.textile_backup.core.create.compressors.AbstractCompressor;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class ZipCompressor
extends AbstractCompressor {
    private static final ConfigHelper config = ConfigHelper.INSTANCE;

    public static ZipCompressor getInstance() {
        return new ZipCompressor();
    }

    @Override
    protected OutputStream createArchiveOutputStream(OutputStream stream, BackupContext ctx, int coreLimit) {
        ZipArchiveOutputStream arc = new ZipArchiveOutputStream(stream);
        arc.setMethod(8);
        arc.setUseZip64(Zip64Mode.AsNeeded);
        arc.setLevel(ZipCompressor.config.get().compression);
        arc.setComment("Created on: " + Utilities.getDateTimeFormatter().format(LocalDateTime.now()));
        return arc;
    }

    @Override
    protected void addEntry(File file, String entryName, OutputStream arc) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            ZipArchiveEntry entry = (ZipArchiveEntry)((ZipArchiveOutputStream)arc).createArchiveEntry(file, entryName);
            if (ZipCompressor.isDotDat(file.getName())) {
                entry.setMethod(0);
                entry.setSize(file.length());
                entry.setCompressedSize(file.length());
                entry.setCrc(ZipCompressor.getCRC(file));
            }
            ((ZipArchiveOutputStream)arc).putArchiveEntry((ArchiveEntry)entry);
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)arc);
            ((ZipArchiveOutputStream)arc).closeArchiveEntry();
        }
    }

    protected static boolean isDotDat(String filename) {
        String[] arr = filename.split("\\.");
        return arr[arr.length - 1].contains("dat");
    }

    protected static long getCRC(File file) throws IOException {
        CRC32 sum = new CRC32();
        byte[] buffer = new byte[8192];
        try (FileInputStream stream = new FileInputStream(file);){
            int len;
            while ((len = ((InputStream)stream).read(buffer)) != -1) {
                sum.update(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new IOException("Error while calculating CRC of: " + file.getAbsolutePath(), e);
        }
        return sum.getValue();
    }
}

